package com.ejianc.business.car.controller;

import java.io.Serializable;

import com.ejianc.business.car.bean.CarEntity;
import com.ejianc.business.car.service.ICarService;
import com.ejianc.business.car.vo.OilFeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.car.bean.DispatchEntity;
import com.ejianc.business.car.service.IDispatchService;
import com.ejianc.business.car.vo.DispatchVO;

/**
 * 车辆调度
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dispatch")
public class DispatchController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "DISP-CODE";//此处需要根据实际修改

    @Autowired
    private IDispatchService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICarService carService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DispatchVO> saveOrUpdate(@RequestBody DispatchVO saveOrUpdateVO) {
    	DispatchEntity entity = BeanMapper.map(saveOrUpdateVO, DispatchEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	DispatchVO vo = BeanMapper.map(entity, DispatchVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DispatchVO> queryDetail(Long id) {
    	DispatchEntity entity = service.selectById(id);
//        if ("1".equals(entity.getDispatchType())&& null!=entity.getDispatchProjectId()){
//            CarEntity car = carService.selectById(entity.getCarId());
//            entity.setHistoryProjectId(car.getCarProjectId());
//            entity.setHistoryProjectName(car.getCarProjectName());
//            entity.setCarProjectName(entity.getDispatchProjectName());
//            entity.setCarProjectId(entity.getDispatchProjectId());
//            service.saveOrUpdate(entity);
//            car.setCarProjectId(entity.getDispatchProjectId());
//            car.setCarProjectName(entity.getDispatchProjectName());
//            carService.saveOrUpdate(car);
//        }
    	DispatchVO vo = BeanMapper.map(entity, DispatchVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DispatchVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DispatchVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DispatchVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DispatchVO>> queryList(@RequestBody QueryParam param) {

        /** 车牌号、车辆名称、申请部门
         * */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("carCode", "carName", "applyDeptName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

//        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse = iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                    collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<DispatchEntity> page = service.queryPage(param,false);
        IPage<DispatchVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DispatchVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 车牌号、车辆名称、申请部门
         * */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("carCode", "carName", "applyDeptName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

//        /** 数据隔离 本下 */
//        UserContext userContext = sessionManager.getUserContext();
//        String authOrgIds = userContext.getAuthOrgIds();
//        if (StringUtils.isNotEmpty(authOrgIds)) {
//            CommonResponse<List<OrgVO>> authResponse = iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
//                    collect(Collectors.toList()));
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        } else {
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        }
        List<DispatchEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<DispatchVO> dispatchVOS = BeanMapper.mapList(list, DispatchVO.class);
        if (CollectionUtils.isNotEmpty(dispatchVOS)) {
            dispatchVOS.forEach(t -> {
                t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
                t.setDispatchTypeName("1".equals(t.getDispatchType())?"长期调度":"临时调度");
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", dispatchVOS);
        ExcelExport.getInstance().export("Dispatch-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDispatchData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DispatchVO>> refDispatchData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DispatchEntity> page = service.queryPage(param,false);
        IPage<DispatchVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DispatchVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
