package com.ejianc.business.car.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.car.bean.OilRecordEntity;
import com.ejianc.business.car.bean.WageUserDetailEntity;
import com.ejianc.business.car.service.IWageUserDetailService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.car.bean.WageUserEntity;
import com.ejianc.business.car.service.IWageUserService;
import com.ejianc.business.car.vo.WageUserVO;

/**
 * 组织人员登记
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("wageUser")
public class WageUserController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "WAGE_USER";//此处需要根据实际修改

    @Autowired
    private IWageUserService service;
    @Autowired
    private IWageUserDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WageUserVO> saveOrUpdate(@RequestBody WageUserVO saveOrUpdateVO) {
        Long id = saveOrUpdateVO.getId();
        LambdaQueryWrapper<WageUserEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(WageUserEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(WageUserEntity::getOrgId, saveOrUpdateVO.getOrgId());
        queryWrapper.ne(id != null, WageUserEntity::getId, id);
        int count = service.count(queryWrapper);
        if (count > 0) {
            throw new BusinessException("该组织已制单，不允许重复新增！");
        }
    	WageUserEntity entity = BeanMapper.map(saveOrUpdateVO, WageUserEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	WageUserVO vo = BeanMapper.map(entity, WageUserVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WageUserVO> queryDetail(Long id) {
    	WageUserEntity entity = service.selectById(id);
    	WageUserVO vo = BeanMapper.map(entity, WageUserVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * 校验该组织是否已做单据
     * @param
     * @return
     */
    @GetMapping(value = "orgCheck")
    @ResponseBody
    public CommonResponse<String> orgCheck(@RequestParam(value = "orgId") Long orgId,
                                                   @RequestParam(value = "billId", required = false) Long billId) {
        QueryWrapper<WageUserEntity> query = new QueryWrapper<>();
        if(billId!=null){
            query.notIn("id", billId);
        }
        query.eq("org_id", orgId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<WageUserEntity> wageUserEntities = service.list(query);
        if(CollectionUtils.isNotEmpty(wageUserEntities)) {
            return CommonResponse.error("该组织已制单，不允许重复新增！");
        }
        return CommonResponse.success("该组织可以制单！");
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WageUserVO> vos) {
        service.removeByIds(vos.stream().map(WageUserVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WageUserVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("departmentName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse = iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                    collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<WageUserEntity> page = service.queryPage(param,false);
        IPage<WageUserVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WageUserVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("departmentName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WageUserEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<WageUserVO> wageUserVOS = BeanMapper.mapList(list, WageUserVO.class);
        if (CollectionUtils.isNotEmpty(wageUserVOS)) {
            wageUserVOS.forEach(t -> {
                t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", wageUserVOS);
        ExcelExport.getInstance().export("WageUser-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refWageUserData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WageUserVO>> refWageUserData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        /** 已提交的数据 或者 审批通过的数据 */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage<WageUserEntity> page = service.queryPage(param,false);
        List<WageUserEntity> records = page.getRecords();
        QueryParam datailParam = new QueryParam();
        for (WageUserEntity record : records) {
            datailParam.getParams().put("dr", new Parameter(QueryParam.EQ,0));
            datailParam.getParams().put("wage_user_id", new Parameter(QueryParam.EQ,record.getId()));
            datailParam.getOrderMap().put("createTime", "desc");
            List<WageUserDetailEntity> wageUserDetailEntities = detailService.queryList(datailParam);
            record.setWageUserDetailList(wageUserDetailEntities);
        }
        IPage<WageUserVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WageUserVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
