/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.car.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.car.bean.CarEntity;
import com.ejianc.business.car.bean.DispatchEntity;
import com.ejianc.business.car.bean.MaintainEntity;
import com.ejianc.business.car.bean.OilFeeEntity;
import com.ejianc.business.car.bean.OilRecordEntity;
import com.ejianc.business.car.service.ICarService;
import com.ejianc.business.car.service.IDispatchService;
import com.ejianc.business.car.service.IMaintainService;
import com.ejianc.business.car.service.IOilFeeService;
import com.ejianc.business.car.service.IOilRecordService;
import com.ejianc.business.car.vo.CarVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"car"})
public class CarController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICarService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaintainService maintainService;
    @Autowired
    private IDispatchService dispatchService;
    @Autowired
    private IOilRecordService oilRecordService;
    @Autowired
    private IOilFeeService oilFeeService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CarVO> saveOrUpdate(@RequestBody CarVO saveOrUpdateVO) {
        Long id = saveOrUpdateVO.getId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(CarEntity::getCode, (Object)saveOrUpdateVO.getCode());
        queryWrapper.ne(id != null, BaseEntity::getId, (Object)id);
        int count = this.service.count((Wrapper)queryWrapper);
        if (count > 0) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8f66\u724c\u53f7\u5df2\u5b58\u5728\uff01");
        }
        CarEntity entity = (CarEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CarEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CarVO vo = (CarVO)BeanMapper.map((Object)((Object)entity), CarVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CarVO> queryDetail(Long id) {
        CarEntity entity = (CarEntity)((Object)this.service.selectById(id));
        CarVO vo = (CarVO)BeanMapper.map((Object)((Object)entity), CarVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CarVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CarVO carVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CarVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "carName", "orgName", "carAreaName", "carProjectName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CarVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "carName", "orgName", "carAreaName", "carProjectName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList((Iterable)list, CarVO.class));
        ExcelExport.getInstance().exportWithTrans("Car-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCarData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CarVO>> refCarData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "carName", "orgName", "carAreaName", "carProjectName"));
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).get((Object)"range")) {
            param.getParams().remove("orgId");
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CarVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/carCount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> carCount() {
        return CommonResponse.success((Object)this.service.carCount());
    }

    @RequestMapping(value={"/carCountDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<CarVO>> carCountDetail(@RequestParam Long carTypeId, @RequestParam Long carAreaId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CarEntity::getCarTypeId, (Object)carTypeId);
        queryWrapper.eq(CarEntity::getCarAreaId, (Object)carAreaId);
        queryWrapper.in(CarEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in(CarEntity::getOrgId, (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        queryWrapper.orderByAsc(CarEntity::getCarModelId);
        List list = this.service.list((Wrapper)queryWrapper);
        return CommonResponse.success((Object)BeanMapper.mapList((Iterable)list, CarVO.class));
    }

    @RequestMapping(value={"exportCarCount"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportCarCount(HttpServletResponse response) throws IOException {
        JSONObject dataObj = this.service.carCount();
        List data = (List)dataObj.get((Object)"data");
        List head = (List)dataObj.get((Object)"head");
        if (ListUtil.isEmpty((List)data)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        }
        int lastColIndex = head.size();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        sheet.createFreezePane(0, 2, 0, 2);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, lastColIndex - 1));
        XSSFRow row = sheet.createRow(0);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern((short)1);
        style.setAlignment((short)2);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("\u8f66\u8f86\u7edf\u8ba1\u8868");
        cell.setCellStyle((CellStyle)style);
        row = sheet.createRow(1);
        for (int a = 0; a < head.size(); ++a) {
            cell = row.createCell(a);
            cell.setCellValue(((JSONObject)head.get(a)).get((Object)"name").toString());
            cell.setCellStyle((CellStyle)style);
        }
        for (int i = 0; i < lastColIndex; ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 10);
        }
        XSSFCellStyle dataStyle = workbook.createCellStyle();
        dataStyle.setAlignment((short)3);
        for (int i = 0; i < data.size(); ++i) {
            JSONObject vo = (JSONObject)data.get(i);
            row = sheet.createRow(i + 2);
            for (int j = 0; j < lastColIndex; ++j) {
                String key = ((JSONObject)head.get(j)).get((Object)"key").toString();
                cell = row.createCell(j);
                String val = vo.get((Object)key) == null ? "" : vo.get((Object)key).toString();
                cell.setCellValue(val);
                if ("carType".equals(key)) continue;
                cell.setCellStyle((CellStyle)dataStyle);
            }
        }
        workbook.write((OutputStream)outputStream);
    }

    @RequestMapping(value={"/queryMaintainInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryMaintainInfo(@RequestParam Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaintainEntity::getCarId, (Object)id);
        wrapper.in(MaintainEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.maintainService.list((Wrapper)wrapper);
        JSONObject resObj = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal maintainTaxMny = list.stream().filter(t -> t.getMaintainTaxMny() != null).map(MaintainEntity::getMaintainTaxMny).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            resObj.put("maintainTaxMny", (Object)maintainTaxMny);
            resObj.put("maintainCount", (Object)list.size());
        }
        resObj.put("list", (Object)list);
        return CommonResponse.success((Object)resObj);
    }

    @RequestMapping(value={"/queryDispatch"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDispatch(@RequestParam Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DispatchEntity::getCarId, (Object)id);
        wrapper.in(DispatchEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.dispatchService.list((Wrapper)wrapper);
        JSONObject resObj = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resObj.put("dispatchCount", (Object)list.size());
        }
        resObj.put("list", (Object)list);
        return CommonResponse.success((Object)resObj);
    }

    @RequestMapping(value={"/queryOilRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryOilRecord(@RequestParam Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OilRecordEntity::getCarId, (Object)id);
        wrapper.in(OilRecordEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.oilRecordService.list((Wrapper)wrapper);
        JSONObject resObj = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal totalOilConsumption = list.stream().filter(t -> t.getTotalOilConsumption() != null).map(OilRecordEntity::getTotalOilConsumption).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            resObj.put("totalOilConsumption", (Object)totalOilConsumption);
        }
        resObj.put("list", (Object)list);
        return CommonResponse.success((Object)resObj);
    }

    @RequestMapping(value={"/queryOilFee"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryOilFee(@RequestParam Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OilFeeEntity::getCarId, (Object)id);
        wrapper.in(OilFeeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.oilFeeService.list((Wrapper)wrapper);
        JSONObject resObj = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal useAmount = list.stream().filter(t -> t.getUseAmount() != null).map(OilFeeEntity::getUseAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal totalRechargeAmount = list.stream().filter(t -> t.getTotalRechargeAmount() != null).map(OilFeeEntity::getTotalRechargeAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            resObj.put("useAmount", (Object)useAmount);
            resObj.put("totalRechargeAmount", (Object)totalRechargeAmount);
        }
        resObj.put("list", (Object)list);
        return CommonResponse.success((Object)resObj);
    }
}

