package com.ejianc.business.car.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.car.bean.WageEnterEntity;
import com.ejianc.business.car.service.IWageEnterService;
import com.ejianc.business.car.vo.SalaryReportVo;
import com.ejianc.business.car.vo.WageEnterDetailVO;
import com.ejianc.business.car.vo.WageEnterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 人员工资
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("wageEnter")
public class WageEnterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SALARY_WAGE";//此处需要根据实际修改

    @Autowired
    private IWageEnterService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WageEnterVO> saveOrUpdate(@RequestBody WageEnterVO saveOrUpdateVO) {
    	WageEnterEntity entity = BeanMapper.map(saveOrUpdateVO, WageEnterEntity.class);
        CommonResponse<String> stringCommonResponse = service.queryUnEnter(saveOrUpdateVO.getOrgId(), saveOrUpdateVO.getSalaryMoth(),null == entity.getId() ? null : saveOrUpdateVO.getId(),saveOrUpdateVO.getTeam());
        if (!stringCommonResponse.isSuccess()){
            return CommonResponse.error(stringCommonResponse.getMsg());
        }
        if(entity.getId() == null || entity.getId() == 0){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
        }
        // 默认放未确认
        entity.setConfirmFlag(Optional.ofNullable(entity.getConfirmFlag()).orElse(0));
    	service.saveOrUpdate(entity, false);
    	WageEnterVO vo = BeanMapper.map(entity, WageEnterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WageEnterVO> queryDetail(Long id) {
    	WageEnterEntity entity = service.selectById(id);
    	WageEnterVO vo = BeanMapper.map(entity, WageEnterVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @description: 确认操作
     *
     * @return {@link CommonResponse< WageEnterVO>}
     * @author songlx
     * @date: 2024/3/26
     */
    @RequestMapping(value = "/confirm", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WageEnterVO> confirm(@RequestBody List<WageEnterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            LambdaUpdateWrapper<WageEnterEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(WageEnterEntity::getId, vos.stream().map(WageEnterVO::getId).collect(Collectors.toList()));
            updateWrapper.set(WageEnterEntity::getConfirmFlag, 1);
            service.update(updateWrapper);
        }
        return CommonResponse.success("确认成功！");
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WageEnterVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WageEnterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WageEnterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WageEnterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("wageOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("team");
        fuzzyFields.add("salaryMoth");
        fuzzyFields.add("totalSalaryMny");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse = iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                    collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<WageEnterEntity> page = service.queryPage(param,false);
        IPage<WageEnterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WageEnterVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("wageOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("team");
        fuzzyFields.add("salaryMoth");
        fuzzyFields.add("totalSalaryMny");
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        CommonResponse<IPage<WageEnterVO>> iPageCommonResponse = queryList(param);
        List<WageEnterVO> records = new ArrayList<>();
        if (iPageCommonResponse.isSuccess()){
             records = iPageCommonResponse.getData().getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        records.forEach(t -> {
            t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
        });
        beans.put("records", records);
        ExcelExport.getInstance().export("WageEnter-export.xlsx", beans, response);
    }


    @RequestMapping(value = "/excelExportDetail", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDetail(@RequestBody List<WageEnterDetailVO> detailVOS, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", detailVOS);
        ExcelExport.getInstance().export("wageDetail-export.xlsx", beans, response);
    }
    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refWageEnterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WageEnterVO>> refWageEnterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WageEnterEntity> page = service.queryPage(param,false);
        IPage<WageEnterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WageEnterVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "project-moth-detail-import.xlsx", "项目月度工资表导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request,response);
    }


    /**
     * @Description queryUnusedContract 查询本月份是否存在工资单
     */
    @RequestMapping(value = "/queryUnEnter", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryUnEnter(Long wageOrgId, Date salaryMoth,String team) {
        return service.queryUnEnter(wageOrgId, salaryMoth,null,team);
    }
    @RequestMapping(value = "/queryReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryReport(@RequestBody QueryParam param) {

        return CommonResponse.success("查询人员工资统计", service.queryReport(param));
    }
    @RequestMapping(value = "/excelExportReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<SalaryReportVo> records = service.excelExportReport(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("salary-report-export.xlsx", beans, response);
    }
}
