/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.car.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.car.bean.MaintainEntity;
import com.ejianc.business.car.service.IMaintainService;
import com.ejianc.business.car.vo.MaintainMaterialVO;
import com.ejianc.business.car.vo.MaintainVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"maintain"})
public class MaintainController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "MAIN-CODE";
    @Autowired
    private IMaintainService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaintainVO> saveOrUpdate(@RequestBody MaintainVO saveOrUpdateVO) {
        MaintainEntity entity = (MaintainEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaintainEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaintainVO vo = (MaintainVO)BeanMapper.map((Object)((Object)entity), MaintainVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaintainVO> queryDetail(Long id) {
        MaintainEntity entity = (MaintainEntity)((Object)this.service.selectById(id));
        MaintainVO vo = (MaintainVO)BeanMapper.map((Object)((Object)entity), MaintainVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaintainVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaintainVO maintainVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaintainVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("carCode", "carName", "carAreaName", "carProjectName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaintainVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List dispatchVOS = BeanMapper.mapList((Iterable)list, MaintainVO.class);
        if (CollectionUtils.isNotEmpty((Collection)dispatchVOS)) {
            dispatchVOS.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription()));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", dispatchVOS);
        ExcelExport.getInstance().export("Maintain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaintainData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaintainVO>> refMaintainData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaintainVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Maintain-import.xlsx", (String)"\u8f66\u8f86\u7ef4\u4fee\u6750\u6599\u8d39\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<MaintainMaterialVO> successList = new ArrayList<MaintainMaterialVO>();
        ArrayList<MaintainMaterialVO> errorList = new ArrayList<MaintainMaterialVO>();
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaintainMaterialVO vo = new MaintainMaterialVO();
                StringBuilder errMsg = new StringBuilder();
                if (StringUtils.isBlank((CharSequence)((String)datas.get(0)).trim())) {
                    errMsg.append("`\u6750\u6599\u540d\u79f0\u4e3a\u5fc5\u586b\u9879`");
                } else {
                    vo.setMaterialName(((String)datas.get(0)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(1)).trim())) {
                    try {
                        vo.setNum(new BigDecimal(((String)datas.get(1)).trim()));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(2)).trim())) {
                    try {
                        vo.setPrice(new BigDecimal(((String)datas.get(2)).trim()));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u5355\u4ef7\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(3)).trim())) {
                    try {
                        vo.setTaxMny(new BigDecimal(((String)datas.get(3)).trim()));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                } else {
                    errMsg.append("`\u91d1\u989d\u4e3a\u5fc5\u586b\u9879`");
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(4)).trim())) {
                    vo.setMemo(((String)datas.get(4)).trim());
                }
                if (vo.getNum() != null && vo.getPrice() != null) {
                    vo.setTaxMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)vo.getPrice(), (BigDecimal)vo.getNum())));
                }
                vo.setAddType("2");
                if (StringUtils.isNotBlank((CharSequence)errMsg.toString())) {
                    vo.setId(Long.valueOf(i));
                    vo.setErrorMessage(errMsg.toString());
                    errorList.add(vo);
                    continue;
                }
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

