/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.car.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.car.bean.CarEntity;
import com.ejianc.business.car.mapper.CarMapper;
import com.ejianc.business.car.service.ICarService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="carService")
public class CarServiceImpl
extends BaseServiceImpl<CarMapper, CarEntity>
implements ICarService {
    private final String CAR_TYPE = "car-type";
    private final String CAR_AREA = "car-area";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public JSONObject carCount() {
        List carTypeData;
        JSONObject obj = new JSONObject();
        LinkedList<JSONObject> head = new LinkedList<JSONObject>();
        LinkedList<JSONObject> data = new LinkedList<JSONObject>();
        CommonResponse carTypeRes = this.defdocApi.getDefDocByDefCode("car-type");
        CommonResponse carAreaRes = this.defdocApi.getDefDocByDefCode("car-area");
        LambdaQueryWrapper queryWrapper = new QueryWrapper().select(new String[]{"CONCAT( car_type_id, car_area_id ) typeAreaKey, COUNT( 1 ) num"}).lambda();
        queryWrapper.in(CarEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in(CarEntity::getOrgId, (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        queryWrapper.groupBy((Object[])new SFunction[]{CarEntity::getCarTypeId, CarEntity::getCarAreaId});
        List maps = this.listMaps((Wrapper)queryWrapper);
        HashMap<String, Integer> countData = new HashMap<String, Integer>();
        if (CollectionUtils.isNotEmpty((Collection)maps)) {
            for (Map map : maps) {
                countData.put(String.valueOf(map.get("typeAreaKey")), Integer.parseInt(String.valueOf(map.get("num"))));
            }
        }
        List<DefdocDetailVO> carAreaData = new ArrayList();
        if (carAreaRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)carAreaRes.getData()))) {
            carAreaData = (List)carAreaRes.getData();
            carAreaData.sort(Comparator.comparing(BaseVO::getId));
        }
        if (carTypeRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)(carTypeData = (List)carTypeRes.getData()))) {
            carTypeData.sort(Comparator.comparing(BaseVO::getId));
            JSONObject areaHead = new JSONObject();
            areaHead.put("key", (Object)"carType");
            areaHead.put("name", (Object)"\u8f66\u8f86\u7c7b\u578b");
            head.add(areaHead);
            for (DefdocDetailVO datum : carAreaData) {
                JSONObject hh = new JSONObject();
                String key = String.valueOf(datum.getId());
                hh.put("key", (Object)key);
                hh.put("name", (Object)datum.getName());
                head.add(hh);
            }
            JSONObject totalHead = new JSONObject();
            totalHead.put("key", (Object)"total");
            totalHead.put("name", (Object)"\u5408\u8ba1");
            head.add(totalHead);
            for (DefdocDetailVO carType : carTypeData) {
                String carTypeKey = String.valueOf(carType.getId());
                JSONObject dd = new JSONObject();
                dd.put("carTypeId", (Object)carType.getId());
                dd.put("carType", (Object)carType.getName());
                int total = 0;
                for (DefdocDetailVO datum : carAreaData) {
                    Integer num = (Integer)countData.get(carTypeKey + datum.getId());
                    dd.put(String.valueOf(datum.getId()), (Object)num);
                    total += num == null ? 0 : num;
                }
                dd.put("total", (Object)total);
                data.add(dd);
            }
        }
        obj.put("head", head);
        obj.put("data", data);
        return obj;
    }
}

