package com.ejianc.cefoc.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 通用费用报销单
 * 
 * @author generator
 * 
 */
public class FeeCostVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 单据名称
    private Integer billState; // 单据状态：0 自由态，1 已提交，2 审批中，3 审批通过，4 驳回，5 提交后有人审批中
    private Long personId; // 报销人
    private String adress; // 报销地点
    private String workNum; // 工号
    private BigDecimal costMny; // 报销金额
    private Long feeType; // 费用类别
    
    private List<FeeCostSubVO> feeCostSubList = new ArrayList<>(); // 费用信息
    private List<FeeCostByjVO> feeCostByjList = new ArrayList<>(); // 备用金

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getPersonId() {
        return personId;
    }

    @ReferDeserialTransfer
    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public String getAdress() {
        return adress;
    }

    public void setAdress(String adress) {
        this.adress = adress;
    }
    public String getWorkNum() {
        return workNum;
    }

    public void setWorkNum(String workNum) {
        this.workNum = workNum;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFeeType() {
        return feeType;
    }

    @ReferDeserialTransfer
    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }
    
     public List<FeeCostSubVO> getFeeCostSubList() {
        return feeCostSubList;
     }

     public void setFeeCostSubList(List<FeeCostSubVO> feeCostSubList) {
        this.feeCostSubList = feeCostSubList;
     }
     public List<FeeCostByjVO> getFeeCostByjList() {
        return feeCostByjList;
     }

     public void setFeeCostByjList(List<FeeCostByjVO> feeCostByjList) {
        this.feeCostByjList = feeCostByjList;
     }
}
