package com.ejianc.foundation.cfs.api;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.cfs.vo.ColumnVO;
import com.ejianc.foundation.cfs.vo.PageData;
import com.ejianc.framework.core.response.CommonResponse;


@FeignClient(name= "ejc-cfs-web", url="${common.env.feign-client-url}", path="ejc-cfs-web" )
public interface ICustomTableApi {

    @PostMapping(value = "/no_auth/api/customtable/parse")
    public CommonResponse<String> parse(@RequestBody PageData pageData);

	/**
	 * 根据appCode查询其下所有属性值
	 * 
	 * @param appCode:应用code
	 * @param range: 为children时查询主子，否则查询主表字段
	 * @return
	 */
	@RequestMapping(value = "/no_auth/api/customtable/queryColumnList", method= RequestMethod.GET)
	public CommonResponse<List<ColumnVO>> queryColumnList(@RequestParam(value="appCode", required=true) String appCode,
			@RequestParam(value="range", required=true) String range);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/12/16 更新应用单据状态
	 * @Description updateBillState
	 * @Param [appCode, id, billState]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.ejianc.foundation.cfs.vo.ColumnVO>>
	 */
	@RequestMapping(value = "/no_auth/api/customtable/updateBillState", method= RequestMethod.GET)
	public CommonResponse<Boolean> updateBillState(@RequestParam(value="appCode", required=true) String appCode,
														  @RequestParam(value="id", required=true) Long id,
														  @RequestParam(value="billState", required=true) Integer billState);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/12/16 查询应用单据详情
	 * @Description updateBillState
	 * @Param [appCode, id, billState]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.ejianc.foundation.cfs.vo.ColumnVO>>
	 */
	@RequestMapping(value = "/no_auth/api/customtable/queryDetail", method= RequestMethod.GET)
	public CommonResponse<JSONObject> queryDetail(@RequestParam(value="appCode", required=true) String appCode,
												  @RequestParam(value="id", required=true) Long id);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/12/24 查询应用单据 打印详情
	 * @Description updateBillState
	 * @Param [appCode, id, billState]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.ejianc.foundation.cfs.vo.ColumnVO>>
	 */
	@RequestMapping(value = "/no_auth/api/customtable/queryPrintDetail", method= RequestMethod.GET)
	public CommonResponse<JSONObject> queryPrintDetail(@RequestParam(value="appCode", required=true) String appCode,
												  @RequestParam(value="id", required=true) Long id);
}
