package com.ejianc.foundation.cfs.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 自定义应用
 * 
 * @author lyj
 *
 */
public class CustomAppVO extends BaseVO {

	private static final long serialVersionUID = -8878993756357134195L;

	private Long appGroupId; // 应用分组Id

	private String appCode; // 应用编码

	private String appName; // 应用名称

	private String appIcon; // 应用图标

	private Integer queryRange; // 查询范围: 0:本下，1:本人，2:租户

	private Integer authFlag; // 是否控权: 1:控权， 0： 不控权

	private Integer appState; // 应用状态： 1：启用， 0：停用

	private Integer publishState; // 发布状态： 1：已发布， 0：未发布

	private Integer sequence; // 排序号

	private String type; // '应用类型 1PC 2移动'

	private String pcUrl;// pcUrl

	private String mobileUrl; // 移动Url

	private String appPath; // pc 菜单应用链接
	private String icon; // pc 菜单应用图标
	private String name; // pc 菜单应用名称

	private String code; // pc 菜单应用名称
	private String openMode; // pc 菜单应用打开方式
	private Long appId; // pc 菜单应用id
	private String queryAllRangeUserIds;// 能够查询所有数据的用户id集合
	private List<CustomAppVO> children = new ArrayList<>();

	@ReferSerialTransfer(referCode="idm-user")
	public String getQueryAllRangeUserIds() {
		return queryAllRangeUserIds;
	}

	@ReferDeserialTransfer
	public void setQueryAllRangeUserIds(String queryAllRangeUserIds) {
		this.queryAllRangeUserIds = queryAllRangeUserIds;
	}

	public String getAppPath() {
		return appPath;
	}

	public void setAppPath(String appPath) {
		this.appPath = appPath;
	}

	public String getIcon() {
		return icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOpenMode() {
		return openMode;
	}

	public void setOpenMode(String openMode) {
		this.openMode = openMode;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public List<CustomAppVO> getChildren() {
		return children;
	}

	public void setChildren(List<CustomAppVO> children) {
		this.children = children;
	}

	public Long getAppGroupId() {
		return appGroupId;
	}

	public void setAppGroupId(Long appGroupId) {
		this.appGroupId = appGroupId;
	}

	public String getAppCode() {
		return appCode;
	}

	public void setAppCode(String appCode) {
		this.appCode = appCode;
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getAppIcon() {
		return appIcon;
	}

	public void setAppIcon(String appIcon) {
		this.appIcon = appIcon;
	}

	public Integer getQueryRange() {
		return queryRange;
	}

	public void setQueryRange(Integer queryRange) {
		this.queryRange = queryRange;
	}

	public Integer getAuthFlag() {
		return authFlag;
	}

	public void setAuthFlag(Integer authFlag) {
		this.authFlag = authFlag;
	}

	public Integer getAppState() {
		return appState;
	}

	public void setAppState(Integer appState) {
		this.appState = appState;
	}

	public Integer getPublishState() {
		return publishState;
	}

	public void setPublishState(Integer publishState) {
		this.publishState = publishState;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getPcUrl() {
		return pcUrl;
	}

	public void setPcUrl(String pcUrl) {
		this.pcUrl = pcUrl;
	}

	public String getMobileUrl() {
		return mobileUrl;
	}

	public void setMobileUrl(String mobileUrl) {
		this.mobileUrl = mobileUrl;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
