/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller;

import com.ejianc.foundation.cfs.bean.CustomListEntity;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.vo.CustomAppVO;
import com.ejianc.foundation.cfs.vo.CustomListVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"custom/list"})
public class CustomListController
implements Serializable {
    private static final long serialVersionUID = -2549939173725536626L;
    @Autowired
    private ICustomListService customListService;

    @RequestMapping(value={"/queryListConfigureList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<CustomAppVO>> queryListConfigureList(@RequestBody Map<String, Object> map) {
        if (map.get("appId") != null) {
            return CommonResponse.error((String)"\u7f3a\u5c11\u53c2\u6570\uff1aappId");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("appId", new Parameter("eq", map.get("appId")));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.customListService.queryList(param, false);
        List back = BeanMapper.mapList((Iterable)list, CustomAppVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)back);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody List<CustomListVO> customListVO) {
        ArrayList<Object> addList = new ArrayList<Object>();
        ArrayList<Long> delIds = new ArrayList<Long>();
        for (CustomListVO vo : customListVO) {
            if ("del".equals(vo.getRowState())) {
                delIds.add(vo.getId());
            }
            if (!"add".equals(vo.getRowState()) && !"edit".equals(vo.getRowState())) continue;
            addList.add(BeanMapper.map((Object)((Object)vo), CustomListEntity.class));
        }
        if (addList.size() > 0) {
            this.customListService.saveOrUpdateBatch(addList, addList.size(), false);
        }
        if (delIds.size() > 0) {
            this.customListService.removeByIds(delIds);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

