/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.util.ParsePageMetaUtils;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/no_auth/api/customtable/"})
public class CustomTableApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SESSION_PREFIX = "ICOP_SESSION_USER:";
    private static final Gson gson = new Gson();
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICustomTableService customTableService;
    @Autowired
    private ICustomColumnService customColumnService;

    @GetMapping(value={"parse"})
    public CommonResponse<String> parse(@RequestParam(value="userId") Long userId, @RequestParam(value="token") String token, @RequestParam(value="appCode") String appCode, @RequestParam(value="pageMeta") String pageMeta) throws IOException {
        String sid = SESSION_PREFIX + userId;
        String userContextStr = this.sessionManager.getSessionCacheAttribute(sid, token);
        if (StringUtils.isBlank((CharSequence)userContextStr)) {
            return CommonResponse.error((String)"\u7528\u6237\u4e0a\u4e0b\u6587\u4e3a\u7a7a\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        UserContext userContext = (UserContext)gson.fromJson(userContextStr, UserContext.class);
        CustomAppEntity customAppEntity = this.customAppService.queryCustomAppByCode(appCode);
        if (customAppEntity != null) {
            if ("1".equals(customAppEntity.getPublishState())) {
                return CommonResponse.error((String)"\u8be5\u5e94\u7528\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u8fdb\u884c\u8bbe\u8ba1\uff01");
            }
            Map<String, List<JSONObject>> pageMetaMap = ParsePageMetaUtils.parse(pageMeta);
            List<JSONObject> formWidgetList = pageMetaMap.get("FormWidget");
            List<JSONObject> editTableWidgetList = pageMetaMap.get("EditTableWidget");
            Long mainFormId = IdWorker.getId();
            this.clearCustomTable(appCode, mainFormId);
            if (formWidgetList != null && formWidgetList.size() > 0) {
                CustomTableEntity customTableEntity = new CustomTableEntity();
                customTableEntity.setId(mainFormId);
                customTableEntity.setAppId(customAppEntity.getId());
                customTableEntity.setTableName("formWidget_" + appCode);
                customTableEntity.setTenantId(userContext.getTenantid());
                customTableEntity.setCreateUserCode(userContext.getUserCode());
                customTableEntity.setCreateTime(new Date());
                this.customTableService.saveOrUpdate((Object)customTableEntity);
                XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("formWidget_" + appCode).startObject("properties");
                mapping.startObject("id").field("type", "long").endObject();
                mapping.startObject("org_id").field("type", "long").endObject();
                mapping.startObject("bill_state").field("type", "integer").endObject();
                for (int i = 0; i < formWidgetList.size(); ++i) {
                    JSONArray mainChildren = formWidgetList.get(i).getJSONArray("children");
                    for (int m = 0; m < mainChildren.size(); ++m) {
                        String uitype;
                        JSONObject mainField = mainChildren.getJSONObject(m);
                        CustomColumnEntity customColumnEntity = new CustomColumnEntity();
                        customColumnEntity.setId(IdWorker.getId());
                        customColumnEntity.setCustomTableId(mainFormId);
                        customColumnEntity.setColumnName(mainField.getString("uititle"));
                        customColumnEntity.setProperty(mainField.getString("uikey"));
                        switch (uitype = mainField.getString("uisubtype")) {
                            case "date": {
                                customColumnEntity.setType("date");
                                mapping.startObject(mainField.getString("uikey")).field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject();
                                break;
                            }
                            case "time": {
                                customColumnEntity.setType("date");
                                mapping.startObject(mainField.getString("uikey")).field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject();
                                break;
                            }
                            case "number": {
                                customColumnEntity.setType("number");
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "inputrefer": {
                                customColumnEntity.setType("string");
                                customColumnEntity.setVal(mainField.getString("refinfokey"));
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "switch": {
                                customColumnEntity.setType("integer");
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "currency": {
                                customColumnEntity.setType("bigdecimal");
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "refAutoGrid": {
                                customColumnEntity.setType("string");
                                customColumnEntity.setVal(mainField.getString("refinfokey"));
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            default: {
                                customColumnEntity.setType("string");
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                            }
                        }
                        customColumnEntity.setSequence(m);
                        this.customColumnService.save((Object)customColumnEntity);
                    }
                }
                mapping.endObject().endObject().endObject();
                CreateIndexRequest createIndexRequest = new CreateIndexRequest("formWidget_" + appCode);
                createIndexRequest.settings(Settings.builder().put("index.number_of_shards", 5).put("index.number_of_replicas", 1));
                createIndexRequest.mapping(mapping);
                CreateIndexResponse createIndexResponse = this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
                boolean acknowledged = createIndexResponse.isAcknowledged();
                if (!acknowledged) {
                    this.logger.info("es\u5e93\u521b\u5efa\u5931\u8d25");
                    return CommonResponse.error((String)"es\u5e93\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                }
            }
            if (editTableWidgetList != null && editTableWidgetList.size() > 0) {
                for (int i = 0; i < editTableWidgetList.size(); ++i) {
                    String childUiKey = formWidgetList.get(i).getString("uikey");
                    Long childPkId = IdWorker.getId();
                    CustomTableEntity customTableEntity = new CustomTableEntity();
                    customTableEntity.setId(childPkId);
                    customTableEntity.setParentId(mainFormId);
                    customTableEntity.setAppId(customAppEntity.getId());
                    customTableEntity.setTableName("editTableWidget_" + appCode + "_" + childUiKey);
                    customTableEntity.setTenantId(userContext.getTenantid());
                    customTableEntity.setCreateUserCode(userContext.getUserCode());
                    customTableEntity.setCreateTime(new Date());
                    this.customTableService.saveOrUpdate((Object)customTableEntity);
                    JSONArray childrenArray = editTableWidgetList.get(i).getJSONArray("children");
                    XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("editTableWidget_" + appCode + "_" + childUiKey).startObject("properties");
                    mapping.startObject("id").field("type", "long").endObject();
                    mapping.startObject("pid").field("type", "long").endObject();
                    for (int m = 0; m < childrenArray.size(); ++m) {
                        String uitype;
                        JSONObject childField = childrenArray.getJSONObject(m);
                        CustomColumnEntity customColumnEntity = new CustomColumnEntity();
                        customColumnEntity.setId(IdWorker.getId());
                        customColumnEntity.setCustomTableId(childPkId);
                        customColumnEntity.setColumnName(childField.getString("uititle"));
                        customColumnEntity.setProperty(childField.getString("uikey"));
                        switch (uitype = childField.getString("uisubtype")) {
                            case "date": {
                                customColumnEntity.setType("date");
                                mapping.startObject(childField.getString("uikey")).field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject();
                                break;
                            }
                            case "time": {
                                customColumnEntity.setType("date");
                                mapping.startObject(childField.getString("uikey")).field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject();
                                break;
                            }
                            case "number": {
                                customColumnEntity.setType("number");
                                mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "inputrefer": {
                                customColumnEntity.setType("string");
                                customColumnEntity.setVal(childField.getString("refinfokey"));
                                mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "switch": {
                                customColumnEntity.setType("integer");
                                mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "currency": {
                                customColumnEntity.setType("bigdecimal");
                                mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "refAutoGrid": {
                                customColumnEntity.setType("string");
                                customColumnEntity.setVal(childField.getString("refinfokey"));
                                mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            default: {
                                customColumnEntity.setType("string");
                                mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                            }
                        }
                        customColumnEntity.setSequence(m);
                        this.customColumnService.save((Object)customColumnEntity);
                        mapping.endObject().endObject().endObject();
                        CreateIndexRequest createIndexRequest = new CreateIndexRequest("editTableWidget_" + appCode + "_" + childUiKey);
                        createIndexRequest.settings(Settings.builder().put("index.number_of_shards", 5).put("index.number_of_replicas", 1));
                        createIndexRequest.mapping(mapping);
                        CreateIndexResponse createIndexResponse = this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
                        boolean acknowledged = createIndexResponse.isAcknowledged();
                        if (acknowledged) continue;
                        this.logger.info("es\u5e93\u521b\u5efa\u5931\u8d25");
                        return CommonResponse.error((String)"es\u5e93\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                    }
                }
            }
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return CommonResponse.error((String)"\u5e94\u7528\u7f16\u7801\u67e5\u8be2\u5931\u8d25\u3002");
    }

    private void clearCustomTable(String appCode, Long mainFormId) throws IOException {
        QueryWrapper childWrapper = new QueryWrapper();
        childWrapper.eq((Object)"parent_id", (Object)mainFormId);
        List childCustomTableEntities = this.customTableService.list((Wrapper)childWrapper);
        this.customTableService.deleteCustomTable(mainFormId);
        this.customColumnService.deleteCustomColumnByTableId(mainFormId);
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest("formWidget_" + appCode);
        this.client.indices().delete(deleteIndexRequest, RequestOptions.DEFAULT);
        if (childCustomTableEntities != null && childCustomTableEntities.size() > 0) {
            for (int i = 0; i < childCustomTableEntities.size(); ++i) {
                CustomTableEntity childCustomTableEntity = (CustomTableEntity)((Object)childCustomTableEntities.get(i));
                this.customTableService.deleteCustomTable(childCustomTableEntity.getId());
                this.customColumnService.deleteCustomColumnByTableId(childCustomTableEntity.getId());
                DeleteIndexRequest childDeleteIndexRequest = new DeleteIndexRequest("editTableWidget_" + appCode + "_" + i);
                this.client.indices().delete(childDeleteIndexRequest, RequestOptions.DEFAULT);
            }
        }
    }
}

