package com.ejianc.foundation.cfs.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.ejianc.foundation.cfs.bean.CustomListEntity;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.vo.CustomListVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("custom/list")
public class CustomListController implements Serializable {

	private static final long serialVersionUID = -2549939173725536626L;

    @Autowired
    private ICustomListService customListService;
    @Autowired
	private ICustomAppService iCustomAppService;
    
    /**
     * @Description queryList 查询应用列表信息
     * @param map
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
	@RequestMapping(value = "/queryListConfigureList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<CustomListVO>> queryListConfigureList(@RequestBody Map<String,Object> map) {
		if(map.get("appId")==null){
			return CommonResponse.error("缺少参数：appId");
		}
		QueryParam param = new QueryParam();
    	param.getParams().put("appId", new Parameter(QueryParam.EQ, map.get("appId")));
    	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    	List<CustomListEntity> list = customListService.queryList(param,false);
        List<CustomListVO> back = BeanMapper.mapList(list, CustomListVO.class);
        return CommonResponse.success("查询列表数据成功！",back);
    }
	/**
	 * 保存列表项
	 * 
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody List<CustomListVO> customListVO) {
		List<CustomListEntity> addList = new ArrayList<>();
		List<Long> delIds = new ArrayList<>();
		for(CustomListVO vo : customListVO){
			if("del".equals(vo.getRowState())){
				delIds.add(vo.getId());
			}
			if("add".equals(vo.getRowState())||"edit".equals(vo.getRowState())){
				addList.add(BeanMapper.map(vo, CustomListEntity.class));
			}
		}
		if(addList.size()>0){
			customListService.saveOrUpdateBatch(addList, addList.size(),false);
		}
		if(delIds.size()>0){
			customListService.removeByIds(delIds);
		}
    	return CommonResponse.success("保存成功！");
	}


	/**
	 * @Description queryList 查询应用列表信息
	 * @param appCode
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/queryListConfigureListByAppCode", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryListConfigureListByAppCode(@RequestParam("appCode") String appCode) {
		if(StringUtils.isEmpty(appCode)){
			return CommonResponse.error("缺少参数：appCode");
		}
		CustomAppEntity app = iCustomAppService.queryCustomAppByCode(appCode);
		if(app == null){
			return CommonResponse.error("应用不存在！");
		}
		QueryParam param = new QueryParam();
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.getParams().put("appId", new Parameter(QueryParam.EQ, app.getId()));
		param.getOrderMap().put("sequence",QueryParam.ASC);
		List<CustomListEntity> list = customListService.queryList(param,false);
		if(ListUtil.isEmpty(list)){
			return CommonResponse.error("应用【"+app.getAppName()+"】尚未配置列表显示字段，请联系管理员配置！");
		}
		List<CustomListVO> colList = BeanMapper.mapList(list, CustomListVO.class);
		JSONObject backData = new JSONObject();
		backData.put("appName",app.getAppName());
		backData.put("colList",colList);
		return CommonResponse.success("查询列表数据成功！",backData);
	}
}
