package com.ejianc.foundation.cfs.controller.api;

import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.ejianc.foundation.cfs.bean.CustomListEntity;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.vo.PageData;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.util.ParsePageMetaUtils;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;

@RestController
@RequestMapping(value = "/no_auth/api/customtable/")
public class CustomTableApi {
	private Logger logger = LoggerFactory.getLogger(getClass());
	
	public static final String SESSION_PREFIX = "ICOP_SESSION_USER:";
	private static final Gson gson = new Gson();
	
	@Autowired
	private RestHighLevelClient client;
	@Autowired
	private ICustomAppService customAppService;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private ICustomTableService customTableService;
	@Autowired
	private ICustomColumnService customColumnService;
	@Autowired
	private ICustomListService customListService;


	@PostMapping(value = "parse")
    public CommonResponse<String> parse(@RequestBody PageData pageData) throws IOException {
		logger.info(pageData.toString());
		String sid = SESSION_PREFIX + pageData.getUserId();
		String userContextStr = (String) sessionManager.getSessionCacheAttribute(sid, pageData.getToken());
		if(StringUtils.isBlank(userContextStr)) {
			return CommonResponse.error("用户上下文为空，请先登录！");
		}
		UserContext userContext =  gson.fromJson(userContextStr, UserContext.class);
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(pageData.getAppCode());
		if(app != null) {
			if("1".equals(app.getPublishState())) {
				return CommonResponse.error("该应用已发布，不能进行设计！");
			}
			//解析pageMeta
			Map<String, List<JSONObject>> pageMetaMap = ParsePageMetaUtils.parse(pageData.getPageMeta());
			
			List<JSONObject> formWidgetList = pageMetaMap.get("FormWidget");
			List<JSONObject> editTableWidgetList = pageMetaMap.get("EditTableWidget");
			Long mainFormId = IdWorker.getId();
			//先删除table、column表和es库
			clearCustomTable(app.getId());
			//插入table、column和新增es库
			if(ListUtil.isNotEmpty(formWidgetList)) {
				CustomTableEntity mainTable = new CustomTableEntity();
				String mainTableName = "formWidget_"+pageData.getAppCode();
				mainTableName = mainTableName.toLowerCase();
				mainTable.setId(mainFormId);
				mainTable.setAppId(app.getId());
				mainTable.setUiKey("mainUiKey");
				mainTable.setTableName(mainTableName);
				mainTable.setTenantId(userContext.getTenantid());
				mainTable.setCreateUserCode(userContext.getUserCode());
				mainTable.setCreateTime(new Date());
				customTableService.saveOrUpdate(mainTable);
				
				XContentBuilder	mapping = jsonBuilder().startObject().startObject("properties");
				mapping.startObject("id").field("type", "text").endObject();
				mapping.startObject("orgId").field("type", "text").endObject();
				mapping.startObject("orgName").field("type", "text").endObject();
				mapping.startObject("billState").field("type", "integer").endObject();
				mapping.startObject("createTime").field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
				mapping.startObject("createUser").field("type", "text").endObject();
				mapping.startObject("creatorName").field("type", "text").endObject();
				/**插入主表公共字段*/
				List<CustomColumnEntity> entities = getPublicCustomColumnEntity(mainFormId,1);
				entities.forEach(col->customColumnService.save(col));
				/** 循环插入主表字段*/
				for(int i=0; i<formWidgetList.size(); i++) {
					JSONArray mainChildren = formWidgetList.get(i).getJSONArray("children");
					if(mainChildren!=null){
						for(int m=0; m<mainChildren.size(); m++) {
							JSONObject mainField = mainChildren.getJSONObject(m);

							CustomColumnEntity mainCol = new CustomColumnEntity();
							mainCol.setId(IdWorker.getId());
							mainCol.setCustomTableId(mainFormId);
							mainCol.setColumnName(mainField.getString("uititle"));
							mainCol.setProperty(mainField.getString("uikey"));
							String uitype = mainField.getString("uisubtype");
							switch(uitype) {
								case "date":
									mainCol.setType("date");
									mapping.startObject(mainField.getString("uikey")).field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
									break;
								case "time":
									mapping.startObject(mainField.getString("uikey")).field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
									mainCol.setType("date");
									break;
								case "number":
									mainCol.setType("number");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									break;
								case "inputrefer":
									mainCol.setType("refer");
									mainCol.setVal(mainField.getString("refinfokey"));
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									break;
								case "switch":
									mainCol.setType("integer");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									break;
								case "currency":
									mainCol.setType("bigdecimal");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									break;
								case "refAutoGrid":
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									mainCol.setType("refer");
									mainCol.setVal(mainField.getString("refinfokey"));
									break;
								default:
									mainCol.setType("string");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
							}
							mainCol.setSequence(m);
							customColumnService.save(mainCol);
						}
					}
				}
				mapping.endObject().endObject();
				CreateIndexRequest createIndexRequest = new CreateIndexRequest(mainTableName);
				createIndexRequest.settings(Settings.builder()
												.put("index.number_of_shards", 5)
												.put("index.number_of_replicas", 1)
											);
				createIndexRequest.mapping(mapping);
				/** 设置索引别名*/
				createIndexRequest.alias(new Alias(app.getAppName()+"主表"));
				/** 创建es库 */
				CreateIndexResponse createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
	            boolean acknowledged = createIndexResponse.isAcknowledged();
	            if (!acknowledged) {
	            	logger.info("es库创建失败");
	            	return CommonResponse.error("es库创建失败，请重试");
	            }
			}
			/** 处理子表 */
			if(ListUtil.isNotEmpty(editTableWidgetList)) {
				for(int i=0; i<editTableWidgetList.size(); i++) {
					String childUiKey = editTableWidgetList.get(i).getString("uikey");
					Long childPkId = IdWorker.getId();
					String subTableName = "editTableWidget_"+pageData.getAppCode()+"_"+childUiKey;
					subTableName = subTableName.toLowerCase();
					CustomTableEntity subTable = new CustomTableEntity();
					subTable.setId(childPkId);
					subTable.setParentId(mainFormId);
					subTable.setAppId(app.getId());
					subTable.setUiKey(childUiKey);
					subTable.setTableName(subTableName);
					subTable.setTenantId(userContext.getTenantid());
					subTable.setCreateUserCode(userContext.getUserCode());
					subTable.setCreateTime(new Date());
					customTableService.saveOrUpdate(subTable);

					JSONArray childrenArray = editTableWidgetList.get(i).getJSONArray("children");

					XContentBuilder	mapping = jsonBuilder().startObject().startObject("properties");
					mapping.startObject("id").field("type", "text").endObject();
					mapping.startObject("pid").field("type", "text").endObject();
					mapping.startObject("createTime").field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
					mapping.startObject("createUser").field("type", "text").endObject();
					mapping.startObject("creatorName").field("type", "text").endObject();

					/**插入子表公共字段*/
					List<CustomColumnEntity> entities = getPublicCustomColumnEntity(childPkId,0);
					entities.forEach(col->customColumnService.save(col));
					/** 循环插入子表字段*/
					if(childrenArray!=null){
						for(int m=0; m<childrenArray.size(); m++) {
							JSONObject childField = childrenArray.getJSONObject(m);

							CustomColumnEntity subCol = new CustomColumnEntity();
							subCol.setId(IdWorker.getId());
							subCol.setCustomTableId(childPkId);
							subCol.setColumnName(childField.getString("uititle"));
							subCol.setProperty(childField.getString("uikey"));
							subCol.setSequence(m);
							String uitype = childField.getString("uisubtype");
							switch(uitype) {
								case "date":
									subCol.setType("date");
									mapping.startObject(childField.getString("uikey")).field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
									break;
								case "time":
									mapping.startObject(childField.getString("uikey")).field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
									subCol.setType("date");
									break;
								case "number":
									subCol.setType("number");
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									break;
								case "inputrefer":
									subCol.setType("string");
									subCol.setVal(childField.getString("refinfokey"));
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									break;
								case "switch":
									subCol.setType("integer");
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									break;
								case "currency":
									subCol.setType("bigdecimal");
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									break;
								case "refAutoGrid":
									subCol.setType("string");
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									subCol.setVal(childField.getString("refinfokey"));
									break;
								default:
									subCol.setType("string");
									mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
							}
							customColumnService.save(subCol);
						}
					}
					mapping.endObject().endObject();
					CreateIndexRequest createIndexRequest = new CreateIndexRequest(subTableName);
					createIndexRequest.settings(Settings.builder()
							.put("index.number_of_replicas", 1)
							.put("index.number_of_shards", 5)
					);
					/** 设置索引别名*/
					createIndexRequest.alias(new Alias(app.getAppName()+"子表"+(i+1)));
					createIndexRequest.mapping(mapping);
					CreateIndexResponse createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
					boolean acknowledged = createIndexResponse.isAcknowledged();
					if (!acknowledged) {
						logger.info("es库创建失败");
						return CommonResponse.error("es库创建失败，请重试");
					}
				}
			}
			return CommonResponse.success("保存成功");
		}
		return CommonResponse.error("应用编码查询失败。");
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/12/9
	 * @Description getPublicCustomColumnEntity
	 * @Param [mainFormId,
	 *        type  1主表字段  0子表字段
	 * @Return java.util.List<com.ejianc.foundation.cfs.bean.CustomColumnEntity>
	 */
	private List<CustomColumnEntity> getPublicCustomColumnEntity(Long mainFormId,int type){
		List<CustomColumnEntity> list = new ArrayList<>();
		CustomColumnEntity col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setColumnName("id");
		col.setProperty("id");
		col.setType("string");
		col.setSequence(0);
		list.add(col);
		col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setType("date");
		col.setColumnName("创建时间");
		col.setProperty("createTime");
		col.setSequence(0);
		list.add(col);
		col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setType("string");
		col.setColumnName("创建人id");
		col.setProperty("createUser");
		col.setSequence(0);
		list.add(col);
		col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setType("string");
		col.setColumnName("创建人名称");
		col.setProperty("creatorName");
		col.setSequence(0);
		list.add(col);
		if(type == 1){
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("integer");
			col.setColumnName("单据状态");
			col.setProperty("billState");
			col.setSequence(0);
			list.add(col);
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("string");
			col.setColumnName("组织id");
			col.setProperty("orgId");
			col.setSequence(0);
			list.add(col);
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("string");
			col.setColumnName("组织名称");
			col.setProperty("orgName");
			col.setSequence(0);
			list.add(col);
		}else {
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("string");
			col.setColumnName("主表id");
			col.setProperty("pid");
			col.setSequence(0);
			list.add(col);
		}
		return list;
	}

	private void clearCustomTable(Long appId) throws IOException {
		QueryWrapper<CustomTableEntity> childWrapper = new QueryWrapper<>();
		childWrapper.eq("app_id", appId);
		List<CustomTableEntity> childCustomTableEntities = customTableService.list(childWrapper);

		if(childCustomTableEntities != null && childCustomTableEntities.size() > 0) {
			for(int i=0; i<childCustomTableEntities.size(); i++) {
				CustomTableEntity childCustomTableEntity = childCustomTableEntities.get(i);
				customTableService.deleteCustomTable(childCustomTableEntity.getId());
				customColumnService.deleteCustomColumnByTableId(childCustomTableEntity.getId());
				GetIndexRequest request = new GetIndexRequest(childCustomTableEntity.getTableName());
				boolean exists = client.indices().exists(request, RequestOptions.DEFAULT);
				if(exists){
					DeleteIndexRequest childDeleteIndexRequest = new DeleteIndexRequest(childCustomTableEntity.getTableName());
					client.indices().delete(childDeleteIndexRequest, RequestOptions.DEFAULT);
				}
			}
		}
		QueryWrapper<CustomListEntity> lw = new QueryWrapper<>();
		lw.eq("app_id", appId);
		List<CustomListEntity> listEntities = customListService.list(lw);
		if(ListUtil.isNotEmpty(listEntities)){
			customListService.removeByIds(listEntities.stream().map(CustomListEntity::getId).collect(Collectors.toList()));
		}
	}
}
