package com.ejianc.foundation.cfs.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.mapper.CustomTableMapper;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class CustomTableServiceImpl extends BaseServiceImpl<CustomTableMapper, CustomTableEntity> implements ICustomTableService {

	@Autowired
	private CustomTableMapper customTableMapper;
	
	@Override
	public void deleteCustomTable(Long mainFormId) {
		customTableMapper.deleteCustomTable(mainFormId);
	}

	@Override
	public CustomTableEntity queryMainTableByAppId(Long appId) {
		CustomTableEntity customTableEntity = customTableMapper.queryMainTableByAppId(appId);
		return customTableEntity;
	}

	@Override
	public List<CustomTableEntity> queryChildTablesByMainTableId(Long mainTableId) {
		QueryWrapper<CustomTableEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("parent_id", mainTableId);
		List<CustomTableEntity> childTableEntities = customTableMapper.selectList(queryWrapper);
		return childTableEntities;
	}

}
