package com.ejianc.foundation.cfs.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomListEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.vo.CustomAppVO;
import com.ejianc.foundation.front.api.IFrontApi;
import com.ejianc.foundation.front.vo.IdeModuleVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import redis.clients.jedis.Jedis;

@RestController
@RequestMapping("custom/app")
public class CustomAppController implements Serializable {

	private static final long serialVersionUID = -2549939173725536626L;
	//当前用户的角色KEY
	private final static String CURRENTUSER_ROLE_KEY = "currentuser_role_key:";

    @Autowired
    private ICustomAppService customAppService;
	@Autowired
	private ICustomListService customListService;
    @Autowired
    private IFrontApi iFrontApi;
    @Autowired
	private CacheManager cacheManager;

    /**
     * @Description queryList 查询应用列表信息
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
	@RequestMapping(value = "/queryAppList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CustomAppVO>> queryAppList(@RequestBody QueryParam param) {
		
    	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    	IPage<CustomAppEntity> page = customAppService.queryPage(param,false);
    	
    	IPage<CustomAppVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomAppVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

	/**
	 * 保存应用
	 * 
	 * @return
	 */
	@RequestMapping(value = "/saveOrUpdateApp", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<CustomAppEntity> saveOrUpdateApp(@RequestBody CustomAppVO customAppVO) {
		if(customAppVO.getId() != null && customAppVO.getId() > 0) {
			CustomAppEntity uniqueBean = customAppService.selectById(customAppVO.getId());
			uniqueBean.setAppGroupId(customAppVO.getAppGroupId());
			if(!Objects.equals(customAppVO.getAppCode(),uniqueBean.getAppCode())){
				return CommonResponse.error("应用编码不可修改！");
			}
			if(!Objects.equals(customAppVO.getAppName(),uniqueBean.getAppName())){
				return CommonResponse.error("应用名称不可修改！");
			}
			if((uniqueBean.getPublishState() == 0 || uniqueBean.getPublishState() == null) && customAppVO.getPublishState() == 1){
				/** 点击发布应用 查询是否配置列表项 */
				QueryParam param = new QueryParam();
				param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
				param.getParams().put("appId", new Parameter(QueryParam.EQ, uniqueBean.getId()));
				List<CustomListEntity> list = customListService.queryList(param,false);
				if(ListUtil.isEmpty(list)){
					return CommonResponse.error("尚未配置列表项，请先配置列表项！");
				}
			}
			uniqueBean.setAppIcon(customAppVO.getAppIcon());
			uniqueBean.setAuthFlag(customAppVO.getAuthFlag());
			uniqueBean.setAppState(customAppVO.getAppState());
			uniqueBean.setPublishState(customAppVO.getPublishState());
			uniqueBean.setSequence(customAppVO.getSequence());
			uniqueBean.setType(customAppVO.getType());
			customAppService.saveOrUpdate(uniqueBean, false);
			return CommonResponse.success("修改成功！",uniqueBean);
		}else{
	    	CustomAppEntity entity = BeanMapper.map(customAppVO, CustomAppEntity.class);
	    	entity.setId(IdWorker.getId());
	    	entity.setAppCode("CFS"+System.currentTimeMillis());

	    	/** 拼装设计器页面数据 */
			IdeModuleVO moduleVO = new IdeModuleVO();
			moduleVO.setId(entity.getId());
			moduleVO.setCode(entity.getAppCode());
			moduleVO.setAppId(entity.getId());
			moduleVO.setAppCode(entity.getAppCode());
			moduleVO.setCreateDate(new Date());
			moduleVO.setName(entity.getAppName());
			moduleVO.setCreateId(InvocationInfoProxy.getUserid());
			moduleVO.setData(customAppService.getPageInitData(entity.getAppName(),entity.getAppCode()));

	    	CommonResponse response = iFrontApi.insertNewCfsPage(moduleVO);
	    	if(!response.isSuccess()){
				return CommonResponse.error(response.getMsg());
			}
            customAppService.saveOrUpdate(entity, false);
	    	return CommonResponse.success("保存成功！",entity);
		}
	}

	/**
	 * 删除应用
	 * 
	 * @param vos
	 * @return
	 */
	@RequestMapping(value = "/deleteApp", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> deleteApp(@RequestBody List<CustomAppVO> vos) {
		customAppService.deleteApp(vos);
        return CommonResponse.success("删除成功！");
	}
	
	/**
	 * 首页----自定义应用
	 * pc端
	 * @return
	 */
	@GetMapping("list")
	public CommonResponse<List<CustomAppVO>> queryList() {
        List<CustomAppVO> appList = new ArrayList<>();
        Map<Long, Long> customAppMap = new HashMap<>();
        Long userId = InvocationInfoProxy.getUserid();
        List<Long> roleIds = getUserRoleCache(userId);
        if(roleIds != null && roleIds.size() > 0) {
        	String roleIdStr = "";
        	for(Long roleId:roleIds) {
        		roleIdStr += roleId + ",";
        	}
        	if(StringUtils.isNotBlank(roleIdStr)) {
        		List<CustomAppVO> customAppVos = customAppService.queryUserCustomAppList(roleIdStr.substring(0, roleIdStr.length()-1));
        		if(customAppVos != null && customAppVos.size() > 0) {
        			for(CustomAppVO customAppVo:customAppVos) {
        				if(StringUtils.isNotBlank(customAppVo.getType()) && customAppVo.getType().contains("1") && customAppVo.getAppState() == 1) {
        					customAppVo.setPcUrl("/ejc-cfs-frontend/#/cfsDefine/"+customAppVo.getAppCode()+"/"+customAppVo.getAppCode());
        					appList.add(customAppVo);
        					customAppMap.put(customAppVo.getId(), customAppVo.getId());
        				}
        			}
        		}
        	}
        }
        //查询不控权的应用
        List<CustomAppVO> noAuthCustomApps = customAppService.queryAllNoAuthCustomApps();
        if(noAuthCustomApps != null && noAuthCustomApps.size() > 0) {
        	for(CustomAppVO customAppVo:noAuthCustomApps) {
        		if(!customAppMap.containsKey(customAppVo.getId()) && (StringUtils.isNotBlank(customAppVo.getType()) && customAppVo.getType().contains("1")) && customAppVo.getAppState() == 1) {
        			customAppVo.setPcUrl("/ejc-cfs-frontend/#/cfsDefine/"+customAppVo.getAppCode()+"/"+customAppVo.getAppCode());
        			appList.add(customAppVo);
        		}
        	}
        }
        return CommonResponse.success(appList);
	}
	
	private List<Long> getUserRoleCache(Long userId) {
		List<Long> resultList = new ArrayList<Long>();
		String key = CURRENTUSER_ROLE_KEY + userId;
		Set<String> roleIds = cacheManager.execute(new CacheManager.JedisAction<Set<String>>() {
			@Override
			public Set<String> action(Jedis jedis) {
				return jedis.smembers(key);
			}
		});
		if(roleIds != null && !roleIds.isEmpty()) {
			for(String roleId:roleIds) {
				resultList.add(Long.parseLong(roleId));
			}
		}
		return resultList;
	}
}
