package com.ejianc.foundation.cfs.controller;

import java.io.Serializable;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomAppRoleRelationEntity;
import com.ejianc.foundation.cfs.service.ICustomAppRoleRelationService;
import com.ejianc.foundation.cfs.vo.CustomAppRoleRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("custom/roleRelation")
public class CustomAppRoleRelationController implements Serializable {

	private static final long serialVersionUID = -2549939173725536626L;

    @Autowired
    private ICustomAppRoleRelationService relationService; 
    
    /*********************角色start*********************/
    /**
     * @Description queryList 查询角色列表信息
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
	@RequestMapping(value = "/queryRoleList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CustomAppRoleRelationVO>> queryRoleList(@RequestBody QueryParam param) {
		
    	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    	IPage<CustomAppRoleRelationEntity> page = relationService.queryPage(param,false);
    	
    	IPage<CustomAppRoleRelationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomAppRoleRelationVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

	/**
	 * 保存套餐角色关系
	 * 
	 * 
	 * 
	 * @return
	 */
	@RequestMapping(value = "/saveAppRole", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveAppRole(@RequestBody List<CustomAppRoleRelationVO> relationList) {
		return relationService.saveAppRole(relationList);
	}

	/**
	 * 删除授权角色
	 * 
	 * 
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/deleteAppRole", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> deleteAppRole(@RequestBody List<CustomAppRoleRelationVO> relationList) {
		return relationService.deleteAppRole(relationList);
	}
    /*********************角色end*********************/
}
