package com.ejianc.foundation.cfs.controller;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.vo.CustomListVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;

@RestController
@RequestMapping("custom/table")
public class CustomTableController implements Serializable {
	private static final long serialVersionUID = 8717661796833595475L;
	
	private Logger logger = LoggerFactory.getLogger(getClass());
	private final static String ID = "id";
	private final static String DEL = "del";
	private final static String PID = "pid";
	private final static String ORG_ID = "orgId";
	private final static String CREATE_USER = "createUser";
	private final static String CREATE_TIME = "createTime";
	private final static String BILL_STATE = "billState";
	private final static Integer QUERY_TIMEOUT = 60;
	
	@Autowired
	private ICustomAppService customAppService;
	@Autowired
	private ICustomTableService customTableService;
	@Autowired
	private ICustomColumnService customColumnService;
	@Autowired
	private RestHighLevelClient client;
	@Autowired
	private ICustomListService customListService;
	@Autowired
	private IOrgApi orgApi;
	@Autowired(required = false)
	private IAttachmentApi attachmentApi;
	
	/**
	 * 保存或修改
	 * 
	 * @param pageCode
	 * @param saveData
	 * @return
	 * @throws IOException
	 */
	@RequestMapping(value = "/{pageCode}/save", method = RequestMethod.POST)
	public CommonResponse<JSONObject> save(@PathVariable String pageCode, @RequestBody JSONObject saveData) throws IOException {
		if(StringUtils.isBlank(pageCode)) {
			logger.error("应用编号不能为空！");
			return CommonResponse.error("应用编号不能为空！");
		}
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
		//根据appid查询主表信息
		CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());
		//根据主表ID查询所有主数据列
		List<CustomColumnEntity> mainColumnEntities = customColumnService.queryColumnsByTableId(mainTableEntity.getId());
		//
		if(saveData != null) {
			Map<String, Object> saveMap = new HashMap<>();
			if(mainColumnEntities != null && mainColumnEntities.size() > 0) {
				for(CustomColumnEntity customColumnEntity:mainColumnEntities) {
					if(ID.equals(customColumnEntity.getProperty())) {
						String value = saveData.getString(customColumnEntity.getProperty());
						if(StringUtils.isNotBlank(value)) {
							saveMap.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
						}
					}else{
						if("refer".equals(customColumnEntity.getType())){
							if(saveData.getJSONObject(customColumnEntity.getProperty())!=null){
								saveMap.put(customColumnEntity.getProperty(), saveData.getJSONObject(customColumnEntity.getProperty()).toJSONString());
							}
						}else {
							if(StringUtils.isNotEmpty(saveData.getString(customColumnEntity.getProperty()))){
								saveMap.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
							}
						}
					}
				}
			}
			
			//elasticsearch的插入和更新
			Long mainPkId = 0L;
			if(saveMap.containsKey(ID)) {
				mainPkId = Long.parseLong(saveMap.get(ID).toString());
				UpdateRequest updateRequest = new UpdateRequest(mainTableEntity.getTableName(), mainPkId.toString());
				updateRequest.doc(saveMap, XContentType.JSON);
				UpdateResponse response = client.update(updateRequest, RequestOptions.DEFAULT);
				if(response.status().getStatus() != RestStatus.OK.getStatus()){
					logger.error(response.toString());
					return CommonResponse.error("保存失败");
				}
			}else{
				IndexRequest indexRequest = new IndexRequest(mainTableEntity.getTableName());
				mainPkId = IdWorker.getId();
				saveMap.put(ID, mainPkId+"");
				indexRequest.id(mainPkId+"");
				saveMap.put(ORG_ID, InvocationInfoProxy.getOrgId()+"");
				saveMap.put(BILL_STATE, 0);
				saveMap.put(CREATE_USER, InvocationInfoProxy.getUserid()+"");

				indexRequest.source(saveMap, XContentType.JSON);
				IndexResponse response = client.index(indexRequest, RequestOptions.DEFAULT);
				if(response.status().getStatus() == RestStatus.CREATED.getStatus()){
					saveData.put("id",saveMap.get(ID));
					saveData.put("orgId",saveMap.get(ORG_ID));
					saveData.put("billState",0);
					saveData.put("createUser",saveMap.get(CREATE_USER));
				}else {
					logger.error(response.toString());
					return CommonResponse.error("保存失败");
				}
			}
			
			//查询子表
			List<CustomTableEntity> childTableEntities = customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
			if(ListUtil.isNotEmpty(childTableEntities)) {
				for(CustomTableEntity childTableEntity:childTableEntities) {
					//查询子表所有列
					List<CustomColumnEntity> childColumnEntities = customColumnService.queryColumnsByTableId(childTableEntity.getId());
					
					if(ListUtil.isNotEmpty(childColumnEntities)) {
						JSONArray childDatas = saveData.getJSONArray(childTableEntity.getUiKey());
						JSONArray saveChildData = new JSONArray();
						if(ListUtil.isNotEmpty(childDatas)) {
							for(int i=0; i<childDatas.size(); i++) {
								JSONObject childData = childDatas.getJSONObject(i);
								String rowState = childData.getString("rowState");
								if(DEL.equals(rowState) && StringUtils.isNotEmpty(childData.getString(ID))) {
									DeleteRequest deleteRequest = new DeleteRequest(childTableEntity.getTableName(), childData.getString(ID));
									client.delete(deleteRequest, RequestOptions.DEFAULT);
								}else{
									Map<String, Object> childSaveMap = new HashMap<>();
									for(CustomColumnEntity childColumnEntity:childColumnEntities) {
										if(ID.equals(childColumnEntity.getProperty())) {
											String value = childData.getString(childColumnEntity.getProperty());
											if(StringUtils.isNotBlank(value)) {
												childSaveMap.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
											}
										}else{
											childSaveMap.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
										}
									}
									
									if(childSaveMap.containsKey(ID)) {
										Long childPkId = Long.parseLong(childSaveMap.get(ID).toString());
										UpdateRequest updateRequest = new UpdateRequest(childTableEntity.getTableName(), childPkId.toString());
										updateRequest.doc(childSaveMap, XContentType.JSON);
										client.update(updateRequest, RequestOptions.DEFAULT);
										saveChildData.add(childData);
									}else{
										IndexRequest indexRequest = new IndexRequest(childTableEntity.getTableName());
										Long childPkId = IdWorker.getId();
										childSaveMap.put(ID, childPkId+"");
										childSaveMap.put(PID, mainPkId+"");
										childSaveMap.put(CREATE_USER, InvocationInfoProxy.getUserid()+"");
										childSaveMap.put(CREATE_TIME, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
										indexRequest.id(childPkId+"");
										indexRequest.source(childSaveMap, XContentType.JSON);
										IndexResponse response = client.index(indexRequest, RequestOptions.DEFAULT);
										if(response.status().getStatus() == RestStatus.CREATED.getStatus()){
											childData.put(ID,childSaveMap.get(ID));
											childData.put(PID,childSaveMap.get(PID));
											childData.put(CREATE_USER,saveMap.get(CREATE_USER));
											childData.put(CREATE_TIME,saveMap.get(CREATE_TIME));
											childData.put("rowState",null);
											saveChildData.add(childData);
										}else {
											logger.error(response.toString());
											return CommonResponse.error("保存失败");
										}
									}
								}
							}
						}
						saveData.put(childTableEntity.getUiKey(),saveChildData);
					}
				}
			}

			/** 处理附件 */
			List<Long> attachIds = new ArrayList<>();
			JSONArray array = saveData.getJSONArray("attachIds");
			if(array!= null && array.size()>0){
				for (int i = 0; i < array.size(); i++) {
					Long attrId = array.getLong(i);
					attachIds.add(attrId);
				}
			}
			if(ListUtil.isNotEmpty(attachIds)){
				attachmentApi.updateAttachRef(mainPkId, attachIds);
			}
		}
		return CommonResponse.success("保存成功",saveData);
	}

	/**
	 * 查询列表
	 * 
	 * @param pageCode
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/{pageCode}/pageList", method = RequestMethod.POST)
	public CommonResponse<IPage<JSONObject>> pageList(@PathVariable String pageCode, @RequestBody QueryParam queryParam) {
		Long orgId = InvocationInfoProxy.getOrgId();
		
		CommonResponse<List<OrgVO>> orgVoResponse = orgApi.findChildrenByParentId(orgId);
		if(orgVoResponse.isSuccess()) {
			List<OrgVO> orgVos = orgVoResponse.getData();
			
			StringBuffer orgIdBuffer = new StringBuffer();
			for(OrgVO orgVo:orgVos) {
				orgIdBuffer.append(orgVo.getId()).append(",");
			}
			queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdBuffer.substring(0, orgIdBuffer.length()-1)));
		}
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
		//根据appid查询主表信息
		CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());

		IPage<JSONObject> page = new Page<>();
		SearchRequest searchRequest = new SearchRequest(mainTableEntity.getTableName());
		SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

		//查询参数
		Map<String, Parameter> paramMap = queryParam.getParams();
		BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
		boolQuery = setParam(boolQuery, paramMap);

		//复杂查询
        if(CollectionUtils.isNotEmpty(queryParam.getComplexParams())) {
            boolQuery.must(parseComplexParams(queryParam.getComplexParams()));
        }

		sourceBuilder.query(boolQuery);
		sourceBuilder.sort(new FieldSortBuilder("createTime").order(SortOrder.DESC));
		sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex()-1)*queryParam.getPageSize());
        sourceBuilder.size(queryParam.getPageSize());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);

        try {
        	page = queryPage(paramMap, searchRequest);
        } catch (IOException e) {
        	try { //重试一次
				page = queryPage(paramMap, searchRequest);
			} catch (IOException e1) {
				e1.printStackTrace();
        		throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG："+e1.getMessage());
			}
        }

		return CommonResponse.success(page);
	}
	
	/**
	 * 根据主键IDS进行删除
	 * 
	 * @param pageCode 应用编号
	 * @param ids 
	 * @return
	 * @throws IOException
	 */
	@RequestMapping(value = "/{pageCode}/delete", method = RequestMethod.POST)
	public CommonResponse<String> delete(@PathVariable String pageCode, @RequestBody List<Long> ids) throws IOException {
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
		//根据appid查询主表信息
		CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());
		//查询子表
		List<CustomTableEntity> childTableEntities = customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
		
		for(Long id:ids) {
			//删除主表数据
			DeleteRequest mainDeleteRequest = new DeleteRequest(mainTableEntity.getTableName(), id.toString());
			client.delete(mainDeleteRequest, RequestOptions.DEFAULT);
			//删除对应的子表数据
			if(childTableEntities != null && childTableEntities.size() > 0) {
				for(CustomTableEntity childTableEntity:childTableEntities) {
					DeleteByQueryRequest childDeleteRequest = new DeleteByQueryRequest(childTableEntity.getTableName());
					childDeleteRequest.setQuery(new TermQueryBuilder(PID, id));
					client.deleteByQuery(childDeleteRequest, RequestOptions.DEFAULT);
				}
			}
		}
		return CommonResponse.success("删除成功");
	}
	
	/**
	 * 根据主键ID进行查询
	 * 
	 * @param pageCode 页面编号
	 * @param id
	 * @return
	 * @throws IOException
	 */
	@RequestMapping(value = "/{pageCode}/queryDetail", method = RequestMethod.GET)
	public CommonResponse<JSONObject> queryDetail(@PathVariable String pageCode, @RequestParam Long id) throws IOException {
		return customTableService.queryDetail(pageCode,id);
	}

	/**
	 * 根据主键ID进行查询
	 *
	 * @param pageCode 页面编号
	 * @param id
	 * @return
	 * @throws IOException
	 */
	@RequestMapping(value = "/{pageCode}/queryPrintDetail", method = RequestMethod.GET)
	public CommonResponse<JSONObject> queryPrintDetail(@PathVariable String pageCode, @RequestParam Long id) throws IOException {
		return customTableService.queryPrintDetail(pageCode,id);
	}

	
	private BoolQueryBuilder setParam(BoolQueryBuilder boolQuery, Map<String, Parameter> paramMap) {
        for(Map.Entry<String, Parameter> entry: paramMap.entrySet()){
            Parameter param = entry.getValue();
            if(param.getValue() == null || StringUtils.isBlank(param.getValue() + "")) {
                continue;
            }
            if(QueryParam.EQ.equals(param.getType())) {
                boolQuery.must(QueryBuilders.termQuery(entry.getKey(), param.getValue().toString()));
            } else if(QueryParam.LIKE.equals(param.getType())) {
                boolQuery.must(QueryBuilders.matchQuery(entry.getKey(), param.getValue().toString()).analyzer("ik_smart"));
            } else if(QueryParam.IN.equals(param.getType())) {
                Object inParam = param.getValue();
                if(inParam instanceof String) {
                    boolQuery.must(QueryBuilders.termsQuery(entry.getKey(), Arrays.asList(inParam.toString().split(","))));
                } else if(inParam instanceof JSONArray) {
                    boolQuery.must(QueryBuilders.termsQuery(entry.getKey(), JSONObject.parseArray(JSONObject.toJSONString(inParam), Long.class)));
                }
            } else if(QueryParam.BETWEEN.equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).from(dataArr[0]).to(dataArr[1]).includeLower(true).includeUpper(true));
//                boolQuery.must(QueryBuilders.rangeQuery(entry.getKey()).from(dataArr[0]).to(dataArr[1]).includeLower(true).includeUpper(true));
            } else if(QueryParam.GT.equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).gt(param.getValue().toString()));
            } else if(QueryParam.GE.equals(param.getType())){
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).gte(param.getValue().toString()));
            } else if(QueryParam.LT.equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).lt(param.getValue().toString()));
            } else if(QueryParam.LE.equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery(entry.getKey()).lte(param.getValue().toString()));
            }
        }
		return boolQuery;
    }
	
	private BoolQueryBuilder parseComplexParams(List<ComplexParam> complexParams) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
	    for(ComplexParam cp : complexParams) {
			if(ComplexParam.AND.equals(cp.getLogic())) {
				if(!cp.getParams().isEmpty()) {
					boolQuery.must(setParam(QueryBuilders.boolQuery(), cp.getParams()));
				}
				if(CollectionUtils.isNotEmpty(cp.getComplexParams())) {
					boolQuery.must(parseComplexParams(cp.getComplexParams()));
				}

			} else {
				if(!cp.getParams().isEmpty()) {
					boolQuery.should(setParam(QueryBuilders.boolQuery(), cp.getParams()));
				}
				if(CollectionUtils.isNotEmpty(cp.getComplexParams())) {
					boolQuery.should(parseComplexParams(cp.getComplexParams()));
				}
			}

        }

	    return boolQuery;
    }

    //查询es
	private IPage<JSONObject> queryPage(Map<String, Parameter> paramMap, SearchRequest searchRequest) throws IOException {
		IPage<JSONObject> page = new Page<>();
		List<JSONObject> list = new ArrayList<>();
        SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
        for(SearchHit hit : response.getHits()){
            Map<String, Object> source = hit.getSourceAsMap();
            //处理高亮片段
            Map<String, HighlightField> highlightFields = hit.getHighlightFields();
            for(Map.Entry<String, HighlightField> highlightEntry:highlightFields.entrySet()) {
            	if(paramMap.containsKey(highlightEntry.getKey())) {
            		Parameter parameter = paramMap.get(highlightEntry.getKey());
            		if(StringUtils.isNotBlank(parameter.getValue() + "")) {
            			HighlightField nameField = highlightEntry.getValue();
            			if(nameField!=null){
            				Text[] fragments = nameField.fragments();
            				StringBuilder nameTmp = new StringBuilder();
            				for(Text text:fragments){
            					nameTmp.append(text);
            				}
            				//将高亮片段组装到结果中去
            				source.put(highlightEntry.getKey(), nameTmp.toString());
            			}
            		}
            	}
            }
        }
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            list.add(new JSONObject(hit.getSourceAsMap()));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
	}
	 
}
