package com.ejianc.foundation.cfs.controller.api;

import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

import java.io.IOException;
import java.util.*;

import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.vo.ColumnVO;
import com.ejianc.foundation.cfs.vo.PageData;
import com.ejianc.foundation.front.api.IFrontApi;
import com.ejianc.foundation.front.vo.IdeModuleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.util.ParsePageMetaUtils;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;

@RestController
@RequestMapping(value = "/no_auth/api/customtable/")
public class CustomTableApi {
	private Logger logger = LoggerFactory.getLogger(getClass());
	
	public static final String SESSION_PREFIX = "ICOP_SESSION_USER:";
	private static final Gson gson = new Gson();
	
	@Autowired
	private RestHighLevelClient client;
	@Autowired
	private ICustomAppService customAppService;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private ICustomTableService customTableService;
	@Autowired
	private ICustomColumnService customColumnService;
	@Autowired
	private IFrontApi iFrontApi;


	@PostMapping(value = "parse")
    public CommonResponse<String> parse(@RequestBody PageData pageData) throws IOException {
		logger.info(pageData.toString());
		String sid = SESSION_PREFIX + pageData.getUserId();
		String userContextStr = (String) sessionManager.getSessionCacheAttribute(sid, pageData.getToken());
		if(StringUtils.isBlank(userContextStr)) {
			return CommonResponse.error("用户上下文为空，请先登录！");
		}
		UserContext userContext =  gson.fromJson(userContextStr, UserContext.class);
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(pageData.getAppCode());
		if(app != null) {
			if("1".equals(app.getPublishState())) {
				return CommonResponse.error("该应用已发布，不能进行设计！");
			}
			JSONObject mobileList = getInitMobilePage(app,false);
			JSONObject mobileCard = getInitMobilePage(app,true);
			List<CustomColumnEntity> mainCols = new ArrayList<>();
			mobileList.put("mainCols",mainCols);
			mobileCard.put("mainCols",mainCols);
			Map<String,List<CustomColumnEntity>> subCols = new HashMap<>();
			mobileCard.put("subCols",subCols);
			//解析pageMeta
			Map<String, List<JSONObject>> pageMetaMap = ParsePageMetaUtils.parse(pageData.getPageMeta());
			
			List<JSONObject> formWidgetList = pageMetaMap.get("FormWidget");
			List<JSONObject> editTableWidgetList = pageMetaMap.get("EditTableWidget");
			Long mainFormId = IdWorker.getId();
			//先删除table、column表和es库
			customTableService.clearCustomTable(app.getId());
			//插入table、column和新增es库
			if(ListUtil.isNotEmpty(formWidgetList)) {
				CustomTableEntity mainTable = new CustomTableEntity();
				String mainTableName = "formWidget_"+pageData.getAppCode();
				mainTableName = mainTableName.toLowerCase();
				mainTable.setId(mainFormId);
				mainTable.setAppId(app.getId());
				mainTable.setUiKey("mainUiKey");
				mainTable.setTableName(mainTableName);
				mainTable.setTenantId(userContext.getTenantid());
				mainTable.setCreateUserCode(userContext.getUserCode());
				mainTable.setCreateTime(new Date());
				customTableService.saveOrUpdate(mainTable);
				
				XContentBuilder	mapping = jsonBuilder().startObject().startObject("properties");
				mapping.startObject("id").field("type", "text").endObject();
				mapping.startObject("orgId").field("type", "text").endObject();
				mapping.startObject("orgName").field("type", "text").endObject();
				mapping.startObject("billState").field("type", "integer").endObject();
				mapping.startObject("createTime").field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
				mapping.startObject("createUser").field("type", "text").endObject();
				mapping.startObject("creatorName").field("type", "text").endObject();
				/**插入主表公共字段*/
				List<CustomColumnEntity> entities = getPublicCustomColumnEntity(mainFormId,1);
				entities.forEach(col->customColumnService.save(col));
				mainCols.addAll(entities);
				/** 循环插入主表字段*/
				for(int i=0; i<formWidgetList.size(); i++) {
					JSONArray mainChildren = formWidgetList.get(i).getJSONArray("children");
					if(mainChildren!=null){
						for(int m=0; m<mainChildren.size(); m++) {
							JSONObject mainField = mainChildren.getJSONObject(m);

							CustomColumnEntity mainCol = new CustomColumnEntity();
							mainCol.setId(IdWorker.getId());
							mainCol.setCustomTableId(mainFormId);
							mainCol.setColumnName(mainField.getString("uititle"));
							mainCol.setProperty(mainField.getString("uikey"));
							String uitype = mainField.getString("uisubtype");
							switch(uitype) {
								case "date":
									mainCol.setType("date");
									mapping.startObject(mainField.getString("uikey")).field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
									break;
								case "time":
									mapping.startObject(mainField.getString("uikey")).field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
									mainCol.setType("date");
									break;
								case "number":
									mainCol.setType("number");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									break;
								case "inputrefer":
								case "enumselect":
									mainCol.setType("refer");
									mainCol.setVal(mainField.getString("refinfokey"));
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
								case "switch":
									mainCol.setType("integer");
									String name = "";
									if(StringUtils.isNotEmpty(mainField.getString("checkedChildren"))){
										name = name + mainField.getString("checkedChildren") +",";
									}else {
										name = name + "是,";
									}
									if(StringUtils.isNotEmpty(mainField.getString("unCheckedChildren"))){
										name = name + mainField.getString("unCheckedChildren");
									}else {
										name = name + "否";
									}
									mainCol.setVal(name);
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									break;
								case "currency":
									mainCol.setType("bigdecimal");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									break;
								case "select":
									mainCol.setType("select");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
								case "refAutoGrid":
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									mainCol.setType("refer");
									mainCol.setVal(mainField.getString("refinfokey"));
									break;
								default:
									mainCol.setType("string");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
							}
							mainCol.setSequence(m+1);
							customColumnService.save(mainCol);
							mainCols.add(mainCol);
						}
					}
				}
				mapping.endObject().endObject();
				CreateIndexRequest createIndexRequest = new CreateIndexRequest(mainTableName);
				createIndexRequest.settings(Settings.builder()
												.put("index.number_of_shards", 5)
												.put("index.number_of_replicas", 1)
											);
				createIndexRequest.mapping(mapping);
				/** 设置索引别名*/
				createIndexRequest.alias(new Alias(app.getAppName()+"主表"));
				CreateIndexResponse createIndexResponse;
				boolean acknowledged;
				try {
					/** 创建es库 */
					createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
					acknowledged = createIndexResponse.isAcknowledged();
					if (!acknowledged) {
						createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
						acknowledged = createIndexResponse.isAcknowledged();
						if (!acknowledged) {
							logger.info("es库创建失败");
							return CommonResponse.error("es库创建失败，请重试");
						}
					}
				}catch (IOException e){
					/** 重试一次*/
					createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
					acknowledged = createIndexResponse.isAcknowledged();
					if (!acknowledged) {
						logger.info("es库创建失败");
						return CommonResponse.error("es库创建失败，请重试");
					}
				}
			}
			/** 处理子表 */
			if(ListUtil.isNotEmpty(editTableWidgetList)) {
				for(int i=0; i<editTableWidgetList.size(); i++) {
					String childUiKey = editTableWidgetList.get(i).getString("uikey");
					Long childPkId = IdWorker.getId();
					String subTableName = "editTableWidget_"+pageData.getAppCode()+"_"+childUiKey;
					subTableName = subTableName.toLowerCase();
					CustomTableEntity subTable = new CustomTableEntity();
					subTable.setId(childPkId);
					subTable.setParentId(mainFormId);
					subTable.setAppId(app.getId());
					subTable.setUiKey(childUiKey);
					subTable.setTableName(subTableName);
					subTable.setTenantId(userContext.getTenantid());
					subTable.setCreateUserCode(userContext.getUserCode());
					subTable.setCreateTime(new Date());
					customTableService.saveOrUpdate(subTable);

					JSONArray childrenArray = editTableWidgetList.get(i).getJSONArray("children");

					XContentBuilder	mapping = jsonBuilder().startObject().startObject("properties");
					mapping.startObject("id").field("type", "text").endObject();
					mapping.startObject("pid").field("type", "text").endObject();
					mapping.startObject("createTime").field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
					mapping.startObject("createUser").field("type", "text").endObject();
					mapping.startObject("creatorName").field("type", "text").endObject();

					/**插入子表公共字段*/
					List<CustomColumnEntity> entities = getPublicCustomColumnEntity(childPkId,0);
					entities.forEach(col->customColumnService.save(col));
					/** 循环插入子表字段*/
					if(childrenArray!=null){
						for(int m=0; m<childrenArray.size(); m++) {
							JSONObject childField = childrenArray.getJSONObject(m);

							CustomColumnEntity subCol = new CustomColumnEntity();
							subCol.setId(IdWorker.getId());
							subCol.setCustomTableId(childPkId);
							subCol.setColumnName(childField.getString("uititle"));
							subCol.setProperty(childField.getString("uikey"));
							subCol.setSequence(m);
							String uitype = childField.getString("uisubtype");
							switch(uitype) {
								case "date":
									subCol.setType("date");
									mapping.startObject(childField.getString("uikey")).field("type", "date").field("format",StringUtils.isNotEmpty(childField.getString("format"))?childField.getString("format"):"yyyy-MM-dd").endObject();
									break;
								case "number":
									subCol.setType("number");
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									break;
								case "inputrefer":
								case "enumselect":
									subCol.setType("refer");
									subCol.setVal(childField.getString("refinfokey"));
									mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
								case "switch":
									subCol.setType("integer");
									String name = "";
									if(StringUtils.isNotEmpty(childField.getString("checkedChildren"))){
										name = name + childField.getString("checkedChildren") +",";
									}else {
										name = name + "是,";
									}
									if(StringUtils.isNotEmpty(childField.getString("unCheckedChildren"))){
										name = name + childField.getString("unCheckedChildren");
									}else {
										name = name + "否";
									}
									subCol.setVal(name);
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									break;
								case "currency":
									subCol.setType("bigdecimal");
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									break;
								case "refAutoGrid":
									subCol.setType("string");
									mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									subCol.setVal(childField.getString("refinfokey"));
									break;
								case "select":
									subCol.setType("select");
									mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
								default:
									subCol.setType("string");
									mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
							}
							customColumnService.save(subCol);
						}
					}
					mapping.endObject().endObject();
					CreateIndexRequest createIndexRequest = new CreateIndexRequest(subTableName);
					createIndexRequest.settings(Settings.builder()
							.put("index.number_of_replicas", 1)
							.put("index.number_of_shards", 5)
					);
					/** 设置索引别名*/
					createIndexRequest.alias(new Alias(app.getAppName()+"子表"+(i+1)));
					createIndexRequest.mapping(mapping);
					CreateIndexResponse createIndexResponse;
					boolean acknowledged;
					try {
						/** 创建es库 */
						createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
						acknowledged = createIndexResponse.isAcknowledged();
						if (!acknowledged) {
							createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
							acknowledged = createIndexResponse.isAcknowledged();
							if (!acknowledged) {
								logger.info("es库创建失败");
								return CommonResponse.error("es库创建失败，请重试");
							}
						}
					}catch (IOException e){
						logger.error("es库创建失败:"+e.getMessage());
						createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
						acknowledged = createIndexResponse.isAcknowledged();
						if (!acknowledged) {
							logger.info("es库创建失败");
							return CommonResponse.error("es库创建失败，请重试");
						}
					}
				}
			}
			saveMobilePage(app,false,mobileList);
			return CommonResponse.success("保存成功");
		}
		return CommonResponse.error("应用编码查询失败。");
	}

	private JSONObject getInitMobilePage(CustomAppEntity app,boolean card){
		JSONObject page = new JSONObject();
		page.put("uikey",app.getAppCode()+"list");
		page.put("uititle",app.getAppName());
		page.put("uitype","EJCPage");
		page.put("cfsAppInfo",app);
		page.put("nid",System.currentTimeMillis()+"");
		if(card){
			page.put("children",new JSONArray());
			page.put("uikey",app.getAppCode()+"card");
			page.put("uititle",app.getAppName()+"详情");
		}else {
			JSONArray pageChildren = new JSONArray();
			page.put("children",pageChildren);
			JSONObject layout = getInitItem("上中下布局","EJCLayout");
			JSONArray layoutChildren = layout.getJSONArray("children");
			JSONObject head = getInitItem("头部","EJCLayoutPanel");
			head.put("position","top");
			head.put("visible",true);
			head.put("height","45px");
			JSONObject center = getInitItem("中部","EJCLayoutPanel");
			center.put("uikey","EJCLayoutPanel2");
			center.put("position","center");
			center.put("visible",true);
			center.put("height","calc(100% - 45px)");
			JSONArray centerChildren = center.getJSONArray("children");
			JSONObject cardList = getInitItem("卡片列表","EJCCardList");
			centerChildren.add(cardList);
			cardList.put("titleName","title");
			cardList.put("thumbName","thumb");
			cardList.put("IconSize","md");
			cardList.put("firstButtonText","取消");
			cardList.put("secondButtonText","删除");
			cardList.put("header","列表头部");
			cardList.put("footerBefore","正在加载");
			cardList.put("footerAfter","加载完成");
			cardList.put("cutheight","0px");
			cardList.put("initialListSize",100);
			cardList.put("onEndReachedThreshold",100);
			cardList.put("pageSize",30);
			cardList.put("showBottom",true);
			cardList.put("showFooter",true);
			cardList.put("disabledFirst",true);
			cardList.put("disabledSecond",true);
			JSONArray cardListChildren = cardList.getJSONArray("children");
			JSONObject cardListHead = getInitItem("头部","EJCCardListTitle");
			JSONObject cardListCenter = getInitItem("中部","EJCCardListContent");
			cardListCenter.put("lineNumber","2");
			JSONObject cardListBottom = getInitItem("底部","EJCCardListBottom");
			cardListBottom.put("approveBtn",true);
			JSONObject createTime = getInitItem("创建时间","EJCCardListItem");
			createTime.put("uikey","createTime");
			createTime.put("itemkey","createTime");
			createTime.put("itemType","date");
			createTime.put("location","left");
			createTime.put("fontSize","12px");
			createTime.put("dateType","ymdhms");
			cardListBottom.getJSONArray("children").add(createTime);
			cardListChildren.add(cardListHead);
			cardListChildren.add(cardListCenter);
			cardListChildren.add(cardListBottom);
			JSONObject bottom = getInitItem("底部","EJCLayoutPanel");
			bottom.put("uikey","EJCLayoutPanel3");
			bottom.put("position","bottom");
			bottom.put("visible",false);
			bottom.put("height","0");
			layoutChildren.add(head);
			layoutChildren.add(center);
			layoutChildren.add(bottom);
			JSONObject addBtn = getInitItem("新增按钮","EJCAddButton");
			addBtn.put("type","1");
			addBtn.put("leaderPage","0");
			pageChildren.add(layout);
			pageChildren.add(addBtn);
		}

		return page;
	}
	private JSONObject getInitItem(String title,String uitype){
		JSONObject item = new JSONObject();
		item.put("uititle",title);
		item.put("uitype",uitype);
		item.put("uikey",uitype+"1");
		item.put("children",new JSONArray());
		item.put("nid",System.currentTimeMillis()+"");
		return item;
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/12/29 保存移动端页面
	 * @Description saveMobilePage
	 * @Param [entity, card, data]
	 * @Return void
	 */
	private void saveMobilePage(CustomAppEntity entity,boolean card,JSONObject data){
		IdeModuleVO moduleVO = new IdeModuleVO();
		moduleVO.setId(entity.getId());
		if(card){
			moduleVO.setCode(entity.getAppCode()+"card");
		}else {
			moduleVO.setCode(entity.getAppCode()+"list");
		}
		moduleVO.setAppId(entity.getId());
		moduleVO.setAppCode(entity.getAppCode());
		moduleVO.setCreateDate(new Date());
		moduleVO.setName(entity.getAppName());
		moduleVO.setClientType("mobile");
		moduleVO.setCreateId(InvocationInfoProxy.getUserid());
		moduleVO.setData(data.toJSONString());
		CommonResponse response = iFrontApi.insertNewCfsPage(moduleVO);
		if(!response.isSuccess()){
			iFrontApi.insertNewCfsPage(moduleVO);
		}
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/12/9
	 * @Description getPublicCustomColumnEntity
	 * @Param [mainFormId,
	 *        type  1主表字段  0子表字段
	 * @Return java.util.List<com.ejianc.foundation.cfs.bean.CustomColumnEntity>
	 */
	private List<CustomColumnEntity> getPublicCustomColumnEntity(Long mainFormId,int type){
		List<CustomColumnEntity> list = new ArrayList<>();
		CustomColumnEntity col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setColumnName("id");
		col.setProperty("id");
		col.setType("string");
		col.setSequence(-1);
		list.add(col);
		col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setType("date");
		col.setColumnName("创建时间");
		col.setProperty("createTime");
		col.setSequence(0);
		list.add(col);
		col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setType("string");
		col.setColumnName("创建人id");
		col.setProperty("createUser");
		col.setSequence(0);
		list.add(col);
		col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setType("string");
		col.setColumnName("创建人名称");
		col.setProperty("creatorName");
		col.setSequence(0);
		list.add(col);
		if(type == 1){
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("integer");
			col.setColumnName("单据状态");
			col.setProperty("billState");
			col.setSequence(0);
			list.add(col);
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("string");
			col.setColumnName("组织id");
			col.setProperty("orgId");
			col.setSequence(0);
			list.add(col);
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("string");
			col.setColumnName("组织名称");
			col.setProperty("orgName");
			col.setSequence(0);
			list.add(col);
		}else {
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("string");
			col.setColumnName("主表id");
			col.setProperty("pid");
			col.setSequence(0);
			list.add(col);
		}
		return list;
	}

	/**
	 * 根据appCode查询其下所有属性值
	 * 
	 * @param appCode:应用code
	 * @param range: 为children时查询主子，否则查询主表字段
	 * @return
	 */
	@RequestMapping(value = "queryColumnList", method= RequestMethod.GET)
	public CommonResponse<List<ColumnVO>> queryColumnList(@RequestParam(value="appCode", required=true) String appCode,
			@RequestParam(value="range", required=true) String range){
		List<ColumnVO> resultList = new ArrayList<>();
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(appCode);
		if(app!=null){
			//1、根据appCode查询主表；
			//3、查询子表
			QueryWrapper<CustomTableEntity> childWrapper = new QueryWrapper<>();
			childWrapper.eq("app_id", app.getId());
			childWrapper.eq("dr", 0);
			List<CustomTableEntity> childCustomTableEntities = customTableService.list(childWrapper);
			Long mainId = null;
			List<CustomTableEntity> childrenCustomTables = new ArrayList<>();
			if(childCustomTableEntities!=null&&childCustomTableEntities.size()>0){
				for(CustomTableEntity entity : childCustomTableEntities){
					if(entity.getParentId()!=null){
						childrenCustomTables.add(entity);
					}else{
						mainId = entity.getId();
					}
				}
				if(mainId!=null){
					QueryWrapper<CustomColumnEntity> mainWrapper = new QueryWrapper<>();
					mainWrapper.eq("custom_table_id", mainId);
					mainWrapper.eq("dr", 0);
					//2、根据主表查询主表字段
					List<CustomColumnEntity> mainColumnList = customColumnService.list(mainWrapper);
					for(CustomColumnEntity entity : mainColumnList){
						ColumnVO vo = new ColumnVO();
						vo.setId(entity.getId());
						vo.setName(entity.getColumnName()+"("+entity.getProperty()+")");
						vo.setCode(entity.getProperty());
						vo.setDataType(entity.getType());
						vo.setDisplayName(entity.getColumnName());
						resultList.add(vo);
					}
					if("children".equals(range)){
						if(childrenCustomTables!=null&&childrenCustomTables.size()>0){
							//4、查询子表字段
							for(CustomTableEntity entity : childrenCustomTables){
								QueryWrapper<CustomColumnEntity> childrenWrapper = new QueryWrapper<>();
								childrenWrapper.eq("custom_table_id", entity.getId());
								childrenWrapper.eq("dr", 0);

								ColumnVO cvo = new ColumnVO();
								cvo.setId(entity.getId());
								cvo.setName(entity.getTableName());
								cvo.setCode(entity.getUiKey());
								cvo.setMainAttributeField(entity.getUiKey());
								cvo.setDisplayName(entity.getTableName());
								resultList.add(cvo);
								
								//2、根据主表查询主表字段
								List<CustomColumnEntity> childrenColumnList = customColumnService.list(childrenWrapper);
								if(childrenColumnList!=null&&childrenColumnList.size()>0){
									for(CustomColumnEntity columnentity : childrenColumnList){
										ColumnVO vo = new ColumnVO();
										vo.setId(columnentity.getId());
										vo.setName(columnentity.getColumnName()+"("+columnentity.getProperty()+")");
										vo.setCode(columnentity.getProperty());
										vo.setDisplayName(columnentity.getColumnName());
										vo.setDataType(columnentity.getType());
										vo.setParentId(entity.getId());
										vo.setMainAttributeField(entity.getUiKey());
										resultList.add(vo);
									}
								}
							}
						}
					}
				}
			}
		}
		return CommonResponse.success(resultList);
		
	}

	@RequestMapping(value = "updateBillState", method= RequestMethod.GET)
	public CommonResponse<Boolean> updateBillState(@RequestParam(value="appCode", required=true) String appCode,
												   @RequestParam(value="id", required=true) Long id,
												   @RequestParam(value="billState", required=true) Integer billState) throws IOException {
		CommonResponse<JSONObject> response = customTableService.queryDetail(appCode,id);
		if(response.isSuccess()){
			//根据应用编号查询应用
			CustomAppEntity app = customAppService.queryCustomAppByCode(appCode);
			//根据appid查询主表信息
			CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());
			JSONObject entity = response.getData();
			entity.put("billState",billState);
			UpdateRequest updateRequest = new UpdateRequest(mainTableEntity.getTableName(), id.toString());
			updateRequest.doc(entity, XContentType.JSON);
			UpdateResponse update = client.update(updateRequest, RequestOptions.DEFAULT);
			if(update.status().getStatus() != RestStatus.OK.getStatus()){
				logger.error(response.toString());
				return CommonResponse.error("更新失败");
			}
			return CommonResponse.success("更新成功！",true);
		}
		return CommonResponse.error("更新失败");
	}


	@RequestMapping(value = "queryDetail", method= RequestMethod.GET)
	public CommonResponse<JSONObject> queryDetail(@RequestParam(value="appCode", required=true) String appCode,
												  @RequestParam(value="id", required=true) Long id) throws IOException {
		return customTableService.queryDetail(appCode,id);
	}


	@RequestMapping(value = "queryPrintDetail", method= RequestMethod.GET)
	public CommonResponse<JSONObject> queryPrintDetail(@RequestParam(value="appCode", required=true) String appCode,
												  @RequestParam(value="id", required=true) Long id) throws IOException {
		return customTableService.queryPrintDetail(appCode,id);
	}
}
