package com.ejianc.foundation.cfs.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomListEntity;
import com.ejianc.foundation.cfs.mapper.CustomListMapper;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.vo.CustomListVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class CustomListServiceImpl extends BaseServiceImpl<CustomListMapper, CustomListEntity> implements ICustomListService {

	@Autowired
	private CustomListMapper customListMapper;
	
	@Override
	public List<CustomListVO> queryHeaderColumnByAppId(Long appId) {
		QueryWrapper<CustomListEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("app_id", appId);
		queryWrapper.orderByAsc("sequence");
		List<CustomListEntity> customListEntities = customListMapper.selectList(queryWrapper);
		
		List<CustomListVO> customListVos = new ArrayList<>();
		if(customListEntities != null && customListEntities.size() > 0) {
			for(CustomListEntity customListEntity:customListEntities) {
				CustomListVO customListVo = BeanMapper.map(customListEntity, CustomListVO.class);
				if("inputrefer".equals(customListVo.getColumnType()) || "refAutoGrid".equals(customListVo.getColumnType())) {
					customListVo.setColumnProperty(customListVo.getColumnProperty()+".name");
				}
				customListVos.add(customListVo);
			}
		}
		return customListVos;
	}

	
}
