package com.ejianc.foundation.cfs.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppRoleRelationEntity;
import com.ejianc.foundation.cfs.mapper.CustomAppRoleRelationMapper;
import com.ejianc.foundation.cfs.service.ICustomAppRoleRelationService;
import com.ejianc.foundation.cfs.vo.CustomAppRoleRelationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 应用角色关系
 * 
 * @author generator
 * 
 */
@Service("docCategoryRoleRelationService")
public class CustomAppRoleRelationServiceImpl extends BaseServiceImpl<CustomAppRoleRelationMapper, CustomAppRoleRelationEntity> implements ICustomAppRoleRelationService{

	@Autowired
	private CustomAppRoleRelationMapper docCategoryMapper;
	
	
	@Override
	public CommonResponse<String> saveAppRole(List<CustomAppRoleRelationVO> relationList) {
		List<CustomAppRoleRelationEntity> addList = new ArrayList<>();
		String roleName = "";
		//1、判重
		QueryWrapper<CustomAppRoleRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("app_id", relationList.get(0).getAppId());
		queryWrapper.eq("dr", 0);
		List<CustomAppRoleRelationEntity> list = this.list(queryWrapper);
		Map<Long,CustomAppRoleRelationEntity> map = new HashMap<>();
		if(list!=null&&list.size()>0){
			for(CustomAppRoleRelationEntity relation : list){
				map.put(relation.getRoleId(), relation);
				if(roleName.length()>0){
					roleName += ("、"+relation.getRoleName());
				}else{
					roleName += relation.getRoleName();
				}
			}
		}
		String message = "";
		Map<Long,String> orgMap = new HashMap<>();
		for(CustomAppRoleRelationVO vo : relationList){
			if(map.get(vo.getRoleId())==null){
				if(orgMap.get(vo.getRoleOrgId())!=null){
					vo.setRoleOrgName(orgMap.get(vo.getRoleOrgId()));
				}else{
					String orgName = vo.getRoleOrgId().toString();
					if(vo.getRoleOrgId()!=null){
						try {
							JSONArray jArray = ReferObjectUtil.getReferEntityValue(vo.getRoleOrgId().toString(), "idm-org");
							if(jArray!=null&&jArray.size()>0){
								JSONObject json = (JSONObject) jArray.get(0);
								orgName = json.get("name").toString();
							}
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
					vo.setRoleOrgName(orgName);
					orgMap.put(vo.getRoleOrgId(), orgName);
				}
				addList.add(BeanMapper.map(vo, CustomAppRoleRelationEntity.class));
			}else{
				if(message.length()>0){
					message += ("、"+vo.getRoleName());
				}else{
					message += vo.getRoleName();
				}
			}
		}
		//2、保存
		if(addList.size()>0){
			this.saveOrUpdateBatch(addList, addList.size(), false);
			for(CustomAppRoleRelationEntity relation : addList){
				map.put(relation.getRoleId(), relation);
				if(roleName.length()>0){
					roleName += ("、"+relation.getRoleName());
				}else{
					roleName += relation.getRoleName();
				}
			}
			if(addList.size()!=relationList.size()){
				//有重复数据
				return CommonResponse.success("添加成功,其中以下角色："+message+"已存在");
			}
		}else{
			return CommonResponse.success("选择的角色都已在该分类下，请重新选择");
		}
		
		return CommonResponse.success("添加成功");
	}

	@Override
	public CommonResponse<String> deleteAppRole(List<CustomAppRoleRelationVO> relationList) {
		List<Long> ids = new ArrayList<>();
		for(CustomAppRoleRelationVO vo : relationList){
			ids.add(vo.getId());
		}
		this.removeByIds(ids, false);

		return CommonResponse.success("删除成功");
	}
}
