package com.ejianc.foundation.cust.service.impl;

import java.util.List;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cust.bean.BusinessObjectEntity;
import com.ejianc.foundation.cust.bean.BusinessTableRel;
import com.ejianc.foundation.cust.bean.FormTemplateEntity;
import com.ejianc.foundation.cust.bean.FormType;
import com.ejianc.foundation.cust.constant.FormTemplateType;
import com.ejianc.foundation.cust.mapper.FormTemplateMapper;
import com.ejianc.foundation.cust.service.IBusinessObjectService;
import com.ejianc.foundation.cust.service.IFormTemplateService;
import com.ejianc.foundation.cust.util.BusTableRelType;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;

@Service
public class FormTemplateServiceImpl extends BaseServiceImpl<FormTemplateMapper, FormTemplateEntity> implements IFormTemplateService {

	@Autowired
	private FormTemplateMapper formTemplateMapper;
	@Autowired
	private IBusinessObjectService businessObjectService;
	
	@Override
	public void init() {
		QueryWrapper<FormTemplateEntity> queryWrapper = new QueryWrapper<>();
		List<FormTemplateEntity> resultList =  formTemplateMapper.selectList(queryWrapper);
		if(resultList.isEmpty()) {
			initTemplate();
		}
	}

	@SuppressWarnings("unchecked")
	private void initTemplate() {
		try {
			String templatePath = "template/formDef/";
			ClassPathResource resource = new ClassPathResource(templatePath + "templates.xml");
			String xml = IOUtils.toString(resource.getInputStream(),"UTF-8");
			Document document = DocumentHelper.parseText(xml);
			Element root = document.getRootElement();
			List<Element> list = root.elements();
			for (Element element : list) {
				String key = element.attributeValue("key");
				String name = element.attributeValue("name");
				String type = element.attributeValue("type");
				String desc = element.attributeValue("desc");
				String dir = element.attributeValue("dir");

				String fileName = templatePath + dir + "/" + key + ".ftl";
				System.out.println(fileName);
				ClassPathResource fileResouce = new ClassPathResource(fileName);
				String html = IOUtils.toString(fileResouce.getInputStream(),"UTF-8");

				FormTemplateEntity formTemplate = new FormTemplateEntity();
				formTemplate.setId(IdWorker.getId());
				formTemplate.setHtml(html);
				formTemplate.setName(name);
				formTemplate.setUniqueKey(key);
				formTemplate.setEditable(0);
				formTemplate.setType(type);
				formTemplate.setFormType(dir);
				formTemplate.setDescription(desc);
				formTemplateMapper.insert(formTemplate);
			}
		}catch(Exception e) {
			e.printStackTrace();
		}
		
	}
	
	public List<FormTemplateEntity> getByType(String type, String formType,Boolean hasDesignForm) {
		QueryWrapper<FormTemplateEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("type", type);
		queryWrapper.eq("form_type", formType);
		if(hasDesignForm) {
			queryWrapper.eq("type", type.concat("FormOverallArrangement"));
		}
		List<FormTemplateEntity> resultList = formTemplateMapper.selectList(queryWrapper);
		return resultList;
	}

	@Override
	public JSONArray templateData(String boKey, String type) {
		QueryWrapper<BusinessObjectEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("unique_key", boKey);
		BusinessObjectEntity bo = businessObjectService.getOne(queryWrapper);
		if(bo == null) {
			throw new BusinessException(String.format("业务对象丢失，请检查业务对象：%s", boKey));
		}
		boolean hasDesignForm = false;
		if(StringUtils.isNotEmpty(businessObjectService.getOverallArrangementByCode(boKey)) && !FormType.MOBILE.value().equals(type)) {
			hasDesignForm = true;
		}
		
		List<BusinessTableRel> rels = (List<BusinessTableRel>) bo.getRelation().list();
		List<FormTemplateEntity> mainTemplates = getByType(FormTemplateType.MAIN.getKey(),type,hasDesignForm);
		List<FormTemplateEntity> subTableTemplates = getByType(FormTemplateType.SUB_TABLE.getKey(),type,hasDesignForm);
		for (FormTemplateEntity template : mainTemplates) {
			template.setHtml(null);
		}
		for (FormTemplateEntity template : subTableTemplates) {
			template.setHtml(null);
		}

		JSONArray jsonArray = new JSONArray();
		for (BusinessTableRel rel : rels) {
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("tableKey", rel.getTableKey());
			jsonObject.put("tableComment", rel.getTableComment());
			jsonObject.put("typeDesc", BusTableRelType.getByKey(rel.getType()).getDesc());
			if (BusTableRelType.MAIN.equalsWithKey(rel.getType())) {
				jsonObject.put("templates", JSON.toJSON(mainTemplates));
			} else {
				jsonObject.put("templates", JSON.toJSON(subTableTemplates));
			}
			jsonArray.add(jsonObject);
		}
		
		return jsonArray;
	}

}
