/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.cust.bean.BusinessObjectEntity;
import com.ejianc.foundation.cust.bean.BusinessTableRel;
import com.ejianc.foundation.cust.service.IBusinessFormdefService;
import com.ejianc.foundation.cust.service.IBusinessObjectService;
import com.ejianc.foundation.cust.util.BusTableRelType;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bus/businessObject/"})
public class BusinessObjectController {
    @Autowired
    private IBusinessObjectService businessObjectService;
    @Autowired
    private IBusinessFormdefService businessFormdefService;

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BusinessObjectEntity>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap order = queryParam.getOrderMap();
        order.put("createTime", "desc");
        IPage pageData = this.businessObjectService.queryPage(queryParam, false);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"getObject"})
    public CommonResponse<BusinessObjectEntity> getObject(HttpServletRequest request) {
        String id = request.getParameter("id");
        String key = request.getParameter("key");
        String fill = request.getParameter("fill");
        BusinessObjectEntity object = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            object = (BusinessObjectEntity)((Object)this.businessObjectService.getById((Serializable)((Object)id)));
        } else if (StringUtils.isNotBlank((CharSequence)key)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"uniqueKey", (Object)key);
            object = (BusinessObjectEntity)((Object)this.businessObjectService.getOne((Wrapper)queryWrapper));
        }
        if ("1".equals(fill) && object != null) {
            object = this.businessObjectService.getFilledByKey(object.getUniqueKey());
        }
        return CommonResponse.success((Object)((Object)object));
    }

    @RequestMapping(value={"save"})
    public CommonResponse<String> save(@RequestBody BusinessObjectEntity businessObject) {
        this.businessObjectService.saveBusinessObject(businessObject);
        return CommonResponse.success();
    }

    @RequestMapping(value={"saveOverallArrangement"})
    public CommonResponse<String> saveOverallArrangement(HttpServletRequest request) {
        String overallArrangement = request.getParameter("overallArrangement");
        String boCode = request.getParameter("boCode");
        this.businessObjectService.updateOverallArrangementByCode(boCode, overallArrangement);
        return CommonResponse.success();
    }

    @RequestMapping(value={"getOverallArrangement"})
    public CommonResponse<JSONObject> getOverallArrangement(@RequestParam String boCode) {
        String param = this.businessObjectService.getOverallArrangementByCode(boCode);
        JSONObject object = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)param)) {
            object = JSON.parseObject((String)param);
        }
        System.out.println(object);
        return CommonResponse.success((Object)object);
    }

    @RequestMapping(value={"getBoStruct"})
    public CommonResponse<JSONObject> getBoStruct(@RequestParam String key) {
        BusinessObjectEntity object = this.businessObjectService.getFilledByKey(key);
        return CommonResponse.success((Object)this.getBoStruct(object.getRelation()));
    }

    @RequestMapping(value={"remove"})
    public CommonResponse<String> remove(@RequestParam String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bo_key", (Object)id);
        List formdefList = this.businessFormdefService.list((Wrapper)queryWrapper);
        if (formdefList != null && formdefList.size() > 0) {
            throw new BusinessException("\u8868\u5355\u8fd8\u5728\u4f7f\u7528\u4e1a\u52a1\u5bf9\u8c61\uff0c \u5220\u9664\u4e1a\u52a1\u5bf9\u8c61\u5931\u8d25\uff01");
        }
        this.businessObjectService.removeById((Serializable)((Object)id));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    private JSONObject getBoStruct(BusinessTableRel rel) {
        JSONObject json = new JSONObject();
        rel.getTable().getColumns().forEach(column -> json.put(column.getUniqueKey(), column.initValue() == null ? "" : column.initValue()));
        rel.getChildren().forEach(r -> {
            if (BusTableRelType.ONE_TO_ONE.equalsWithKey(r.getType())) {
                json.put(r.getTableKey(), (Object)this.getBoStruct((BusinessTableRel)r));
            } else {
                JSONObject jo = this.getBoStruct((BusinessTableRel)r);
                JSONArray ja = new JSONArray();
                ja.add((Object)jo);
                json.put(r.getTableKey() + "List", (Object)ja);
            }
        });
        return json;
    }
}

