package com.ejianc.foundation.cust.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import cn.hutool.core.collection.CollectionUtil;

/**
 * <pre>
 * 业务表对象的关联对象
 * </pre>
 */
public class BusinessTableRel implements Serializable {

	private static final long serialVersionUID = -5058216649406165276L;
	/**
	 * 子级
	 */
	private List<BusinessTableRel> children;
	/**
	 * 业务表的key
	 */
	private String tableKey;
	/**
	 * 业务表的描述
	 */
	private String tableComment;
	/**
	 * 类型 枚举 BusTableRelType
	 */
	private String type;
	/**
	 * 外键设置
	 */
	private List<BusTableRelFk> fks;

	// 以下字段不入库
	/**
	 * 业务表
	 */
	private BusinessTableEntity table;
	/**
	 * 父对象
	 */
	private BusinessTableRel parent;
	/**
	 * 所属的bo
	 */
	private BusinessObjectEntity busObj;

	public List<BusinessTableRel> getChildren() {
		if (children == null) {
			return Collections.emptyList();
		}
		return children;
	}

	// 获取某类型的子表
	// oneToOne or oneToMany
	public List<BusinessTableRel> getChildren(String type) {
		List<BusinessTableRel> list = new ArrayList<>();
		if (CollectionUtil.isNotEmpty(children))
			for (BusinessTableRel rel : children) {
				if (type.equals(rel.getType())) {
					list.add(rel);
				}
			}
		return list;
	}

	public void setChildren(List<BusinessTableRel> children) {
		this.children = children;
	}

	public String getTableKey() {
		return tableKey;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	public String getTableComment() {
		return tableComment;
	}

	public void setTableComment(String tableComment) {
		this.tableComment = tableComment;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public List<BusTableRelFk> getFks() {
		return fks;
	}

	public void setFks(List<BusTableRelFk> fks) {
		this.fks = fks;
	}

	public BusinessTableRel find(String tableKey) {
		if (this.tableKey.equals(tableKey)) {
			return this;
		}
		if (this.children != null) {
			for (BusinessTableRel rel : this.children) {
				BusinessTableRel r = rel.find(tableKey);
				if (r != null) {
					return r;
				}
			}
		}
		return null;
	}

	public List<BusinessTableRel> list() {
		List<BusinessTableRel> rels = new ArrayList<>();
		rels.add(this);
		if (children != null) {
			for (BusinessTableRel rel : children) {
				rels.addAll(rel.list());
			}
		}
		return rels;
	}

	public BusinessTableEntity getTable() {
		return table;
	}

	public void setTable(BusinessTableEntity table) {
		this.table = table;
	}

	public BusinessTableRel getParent() {
		return parent;
	}

	public void setParent(BusinessTableRel parent) {
		this.parent = parent;
	}

	public BusinessObjectEntity getBusObj() {
		return busObj;
	}

	public void setBusObj(BusinessObjectEntity busObj) {
		this.busObj = busObj;
	}

}
