package com.ejianc.foundation.cust.freemark;

import java.io.StringWriter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.ejianc.framework.core.exception.BusinessException;

import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;

@Component
public class FreemarkerEngine implements IFreemarkerEngine {
	private Configuration formTemplateConfig;
	protected Logger LOG = LoggerFactory.getLogger(getClass());

	public Configuration getFormTemplateConfiguration() {
		try {
			if (formTemplateConfig == null) {
				formTemplateConfig = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
				formTemplateConfig.setDefaultEncoding("UTF-8");
				formTemplateConfig.setClassForTemplateLoading(FreemarkerEngine.class, "/templates");
			}
			return formTemplateConfig;
		} catch (Exception e) {
			throw new BusinessException(e);
		}

	}

	@Override
	public String genFormByTemplateName(String templateName, Object model) {
		try {
			Template template = getFormTemplateConfiguration().getTemplate(templateName);

			StringWriter writer = new StringWriter();
			template.process(model, writer);
			return writer.toString();
		} catch (Exception e) {
			throw new BusinessException(e);
		}

	}

	@Override
	public String parseByString(String templateSource, Object model) {
		try {
			Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
			StringTemplateLoader loader = new StringTemplateLoader();
			cfg.setTemplateLoader(loader);
			cfg.setClassicCompatible(true);
			loader.putTemplate("freemaker", templateSource);
			Template template = cfg.getTemplate("freemaker");
			StringWriter writer = new StringWriter();
			template.process(model, writer);
			return writer.toString();
		} catch (Exception e) {
			LOG.error(String.format("freemaker模板【%s】解析失败：%s", templateSource, e.getMessage()));
			throw new BusinessException(String.format("freemaker模板【%s】解析失败", templateSource), e);
		}
	}

}
