package com.ejianc.foundation.cust.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cust.bean.BusinessFormdefEntity;
import com.ejianc.foundation.cust.bean.BusinessObjectEntity;
import com.ejianc.foundation.cust.bean.BusinessTableRel;
import com.ejianc.foundation.cust.bean.FormTemplateEntity;
import com.ejianc.foundation.cust.bean.FormType;
import com.ejianc.foundation.cust.bean.model.FormGroup;
import com.ejianc.foundation.cust.bean.model.FormOverallArrangement;
import com.ejianc.foundation.cust.bean.model.FormTab;
import com.ejianc.foundation.cust.freemark.IFreemarkerEngine;
import com.ejianc.foundation.cust.generator.AbsFormElementGenerator;
import com.ejianc.foundation.cust.mapper.BusinessFormdefMapper;
import com.ejianc.foundation.cust.service.IBusinessFormdefService;
import com.ejianc.foundation.cust.service.IBusinessObjectService;
import com.ejianc.foundation.cust.service.IFormTemplateService;
import com.ejianc.foundation.cust.util.AppUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import cn.hutool.core.collection.CollectionUtil;

@Service
public class BusinessFormdefServiceImpl extends BaseServiceImpl<BusinessFormdefMapper, BusinessFormdefEntity> implements IBusinessFormdefService {

	@Autowired
	private BusinessFormdefMapper businessFormdefMapper;
	@Autowired
	private IBusinessObjectService businessObjectService;
	@Autowired
	private IFormTemplateService formTemplateService;
	@Autowired
    IFreemarkerEngine freemarkEngine;
	
	
	@Override
	public void removeBusinessFormdefById(String formdefId) {
		businessFormdefMapper.removeBusinessFormdefById(formdefId);
	}

	@Override
	public String generateFormHtml(String boKey, JSONArray templateConfig, String formType) {
		String boDesign = businessObjectService.getOverallArrangementByCode(boKey);
		// 配置了表单设计的统一使用表单设计来生成
		if(StringUtils.isNotBlank(boDesign)){
			if(FormType.PC_IVIEW.value().equals(formType)) {
				return generateIviewOverallArrangementFormHtml(boDesign,boKey,templateConfig);
			}else {
				return generateVueOverallArrangementFormHtml(boDesign,boKey,templateConfig);
			}
		}
		
		BusinessObjectEntity businessObject = businessObjectService.getFilledByKey(boKey);
		StringBuilder sb = new StringBuilder();
		for (Object object : templateConfig) {
			JSONObject jsonObject = (JSONObject) object;
			String templateKey = jsonObject.getString("templateKey");
			BusinessTableRel relation = businessObject.getRelation().find(jsonObject.getString("tableKey"));
			
			QueryWrapper<FormTemplateEntity> templateWrapper = new QueryWrapper<>();
			templateWrapper.eq("unique_key", templateKey);
			FormTemplateEntity template = formTemplateService.getOne(templateWrapper);
			if (template == null) {
				continue;
			}
			Map<String, Object> map = new HashMap<>();
			map.put("relation", relation);
			
			//将所有表单生成器的实现类注入到模板引擎中
			for(AbsFormElementGenerator generator : AppUtil.getImplInstanceArray(AbsFormElementGenerator.class)) {
				map.put(generator.getGeneratorName(), generator);
			}
			
			String html = freemarkEngine.parseByString(template.getHtml(), map);
			
			sb.append(html);
		}
		if(sb.length()>0){
			sb.insert(0,"<div class=\"ivu-form ivu-form-label-right\">");
			sb.append("</div>");
		}

		return sb.toString();
	}
	
	/**
	 * 业务对象布局后的表单
	 *  <Tabs type="card">
	        <TabPane label="标签一">标签一的内容</TabPane>
	        <TabPane label="标签二">标签二的内容</TabPane>
	        <TabPane label="标签三">标签三的内容</TabPane>
	    </Tabs>
	 * 
	 * @param boDesign
	 * @param templateConfig 
	 * @param boKey 
	 * @return
	 */
	private String generateIviewOverallArrangementFormHtml(String boDesign, String boKey, JSONArray templateConfig) {
		FormOverallArrangement formDesign = JSON.toJavaObject(JSON.parseObject(boDesign), FormOverallArrangement.class);
		BusinessObjectEntity businessObject = businessObjectService.getFilledByKey(boKey);

		
		StringBuffer html = new StringBuffer();
		if(CollectionUtil.isNotEmpty(formDesign.getTabList())) {
			html.append("<Tabs>");
			formDesign.getTabList().forEach(tab ->{
				html.append(" <tab-pane label=\"")
					.append(tab.getComment())
					.append("\">");
				
				html.append(generateGroupsHtml(tab.getGroupList(),businessObject,templateConfig));
				
				html.append("</tab-pane> ");
				
			});
			
			html.append("</Tabs>");
		}else {
			html.append(generateGroupsHtml(formDesign.getGroupList(),businessObject,templateConfig));
		}
		
		if(html.length()>0){
			html.insert(0,
					"<div class=\"ivu-form ivu-form-label-right\">"+
					"<script>\n" + 
					"    window.custFormComponentMixin ={\n" + 
					"        data: function () {\n" + 
					"            return {\"test\":\"helloWorld\"};\n" + 
					"        },\n" + 
					"        created:function(){\n" + 
					"            console.log(\"脚本将会混入自定义表单组件中...\");\n" + 
					"        },methods:{\n" + 
					"            testaaa:function(){alert(1)}\n" + 
					"        }\n" + 
					"    }\n" + 
					"</script>" );
			html.append("</div>");
		}
		
		return html.toString();
	}
	
	/**
	 * PC_VUE 业务对象布局后的表单
		<ul class="nav nav-tabs" role="tablist">
	    	<li class="active"><a href="#home" >Home</a></li>
	    	<li <a href="#profile">Profile</a></li>
	    	<li <a href="#settings">Settings</a></li>
	  	</ul>
	
	  <!-- Tab panes -->
	  <div class="tab-content">
	    <div class="tab-pane active" id="home">...</div>
	    <div class="tab-pane" id="profile">...</div>
	    <div class="tab-pane" id="settings">...</div>
	  </div>
	 * 
	 * @param boDesign
	 * @param templateConfig 
	 * @param boKey 
	 * @return
	 */
	private String generateVueOverallArrangementFormHtml(String boDesign, String boKey, JSONArray templateConfig) {
		FormOverallArrangement formDesign = JSON.toJavaObject(JSON.parseObject(boDesign), FormOverallArrangement.class);
		BusinessObjectEntity businessObject = businessObjectService.getFilledByKey(boKey);

		
		StringBuffer html = new StringBuffer();
		if(CollectionUtil.isNotEmpty(formDesign.getTabList())) {
			html.append("<ul class=\"nav nav-tabs\">");
			 boolean isFirst = true;
			for(FormTab tab : formDesign.getTabList()){
				html.append(
						String.format("<li %s ><a href=\"#%s\"  data-toggle=\"tab\" >%s</a></li>",
								(isFirst? "class=\"active\"":""),tab.getComment(),tab.getComment())
						);
				isFirst = false;
				
			};
			html.append("</ul> ");
			
			isFirst = true;
			html.append("<div class=\"tab-content\">");
			for(FormTab tab : formDesign.getTabList()){
				html.append("<div class=\"tab-pane ").append(isFirst?"active":"").append("\" id=\"").append(tab.getComment()).append("\">")
											.append(generateGroupsHtml(tab.getGroupList(),businessObject,templateConfig))
											.append("</div>");
				isFirst = false;
			}
			html.append("</div>");
		}else {
			html.append(generateGroupsHtml(formDesign.getGroupList(),businessObject,templateConfig));
		}
		
		if(html.length()>0){
			html.insert(0,
					"<div class=\"ivu-form ivu-form-label-right\">"+
					"<script>\n" + 
					"    window.custFormComponentMixin ={\n" + 
					"        data: function () {\n" + 
					"            return {\"test\":\"helloWorld\"};\n" + 
					"        },\n" + 
					"        created:function(){\n" + 
					"            console.log(\"脚本将会混入自定义表单组件中...\");\n" + 
					"        },methods:{\n" + 
					"            testaaa:function(){alert(1)}\n" + 
					"        }\n" + 
					"    }\n" + 
					"</script>" );
			
			html.append("</div>");
		}
		
		return html.toString();
	}
	
	private String generateGroupsHtml(List<FormGroup> groupList, BusinessObjectEntity businessObject, JSONArray templateConfig) {
		StringBuilder groupHtml = new StringBuilder();
		groupList.forEach(group -> {
			String tableKey = group.getKey();
			String templateKey = getTemplateKey(templateConfig,tableKey);
			BusinessTableRel relation = businessObject.getRelation().find(tableKey);
			
			QueryWrapper<FormTemplateEntity> templateWrapper = new QueryWrapper<>();
			templateWrapper.eq("unique_key", templateKey);
			FormTemplateEntity template = formTemplateService.getOne(templateWrapper);
			
			
			Map<String, Object> map = new HashMap<>();
			map.put("relation", relation);
			group.setTableRelation(relation);
			//根据分组对象来生成表单
			map.put("group", group);
			
			//将所有表单生成器的实现类注入到模板引擎中
			for(AbsFormElementGenerator generator : AppUtil.getImplInstanceArray(AbsFormElementGenerator.class)) {
				map.put(generator.getGeneratorName(), generator);
			}
			String html = freemarkEngine.parseByString(template.getHtml(), map);
			
			groupHtml.append(html);
		});
		
		return groupHtml.toString();
	}
	
	private String getTemplateKey(JSONArray templateConfig, String tableKey) {
		for (Object object : templateConfig) {
			JSONObject jsonObject = (JSONObject) object;
			if(jsonObject.getString("tableKey").equals(tableKey)) {
				return jsonObject.getString("templateKey");
			}
		}
		throw new BusinessException("tableKey :"+tableKey+"尚未选择模板，请选择模板后生成表单");
	}

	@Override
	public BusinessFormdefEntity getByKey(String uniqueKey) {
		QueryWrapper<BusinessFormdefEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("unique_key", uniqueKey);
		BusinessFormdefEntity resultBean = businessFormdefMapper.selectOne(queryWrapper);
		return resultBean;
	}
	
	private String generateKey() {
		SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
		return Utils.randString(3).toLowerCase()+format.format(new Date());
	}

	@Override
	public void saveFormDef(BusinessFormdefEntity businessFormdefEntity) {
		if(businessFormdefEntity.getId() != null && businessFormdefEntity.getId() > 0) {
			BusinessFormdefEntity uniqueBean = businessFormdefMapper.selectById(businessFormdefEntity.getId());
			uniqueBean.setType(businessFormdefEntity.getType());
			uniqueBean.setName(businessFormdefEntity.getName());
			uniqueBean.setDescription(businessFormdefEntity.getDescription());
			uniqueBean.setGroupId(businessFormdefEntity.getGroupId());
			uniqueBean.setGroupName(businessFormdefEntity.getGroupName());
			uniqueBean.setBoKey(businessFormdefEntity.getBoKey());
			uniqueBean.setBoName(businessFormdefEntity.getBoName());
			uniqueBean.setHtml(businessFormdefEntity.getHtml());
			businessFormdefMapper.updateById(uniqueBean);
		}else{
			businessFormdefEntity.setUniqueKey(generateKey());
			businessFormdefMapper.insert(businessFormdefEntity);
		}
	}

}
