package com.ejianc.foundation.cust.util;

import java.util.HashMap;
import java.util.Map;

import com.ejianc.foundation.cust.bean.BusinessTableEntity;
import com.ejianc.foundation.cust.cache.ICache;

/**
 * <pre>
 * 描述：BusinessTable的缓存工具类
 * 版权:summer
 * </pre>
 */
@SuppressWarnings("unchecked")
public class BusinessTableCacheUtil {
	private static String businessTableMap = "businessTableMap";

	private BusinessTableCacheUtil() {

	}

	public static void put(BusinessTableEntity businessTable) {
		Map<String, BusinessTableEntity> map = (Map<String, BusinessTableEntity>) AppUtil.getBean(ICache.class).getByKey(businessTableMap);
		if (map == null) {
			map = new HashMap<>();
		}
		map.put(businessTable.getUniqueKey(), businessTable);
		AppUtil.getBean(ICache.class).add(businessTableMap, map);
	}

	public static BusinessTableEntity get(String key) {
		Map<String, BusinessTableEntity> map = (Map<String, BusinessTableEntity>) AppUtil.getBean(ICache.class).getByKey(businessTableMap);
		if (map == null) {
			return null;
		}
		return map.get(key);
	}

	public static void clean() {
		Map<String, BusinessTableEntity> map = (Map<String, BusinessTableEntity>) AppUtil.getBean(ICache.class).getByKey(businessTableMap);
		if (map == null) {
			return;
		}
		map.clear();
	}
}
