package com.ejianc.foundation.cfs.controller.api;

import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

import java.io.IOException;
import java.util.*;

import com.ejianc.foundation.cfs.bean.CustomDataEntity;
import com.ejianc.foundation.cfs.service.*;
import com.ejianc.foundation.cfs.vo.ColumnVO;
import com.ejianc.foundation.cfs.vo.PageData;
import com.ejianc.foundation.front.api.IFrontApi;
import com.ejianc.foundation.front.vo.IdeModuleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.util.ParsePageMetaUtils;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;

@RestController
@RequestMapping(value = "/no_auth/api/customtable/")
public class CustomTableApi {
	private Logger logger = LoggerFactory.getLogger(getClass());
	
	public static final String SESSION_PREFIX = "ICOP_SESSION_USER:";
	private static final Gson gson = new Gson();
	
	@Autowired
	private RestHighLevelClient client;
	@Autowired
	private ICustomAppService customAppService;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private ICustomTableService customTableService;
	@Autowired
	private ICustomColumnService customColumnService;
	@Autowired
	private ICustomDataService iCustomDataService;
	@Autowired
	private IFrontApi iFrontApi;


	@PostMapping(value = "parse")
    public CommonResponse<String> parse(@RequestBody PageData pageData) throws IOException {
		logger.info(pageData.toString());
		String sid = SESSION_PREFIX + pageData.getUserId();
		String userContextStr = (String) sessionManager.getSessionCacheAttribute(sid, pageData.getToken());
		if(StringUtils.isBlank(userContextStr)) {
			return CommonResponse.error("用户上下文为空，请先登录！");
		}
		UserContext userContext =  gson.fromJson(userContextStr, UserContext.class);
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(pageData.getAppCode());
		if(app != null) {
			if("1".equals(app.getPublishState())) {
				return CommonResponse.error("该应用已发布，不能进行设计！");
			}
			JSONObject mobileList = getInitMobilePage(app,false);
			JSONObject mobileCard = getInitMobilePage(app,true);
			JSONArray cardCenter = getCardCenter(mobileCard);
			logger.info("cardCenter==null?"+(cardCenter==null)+cardCenter);
			List<JSONObject> mainCols = new ArrayList<>();
			mobileList.put("mainCols",mainCols);
			mobileCard.put("mainCols",mainCols);
			Map<String,List<JSONObject>> subCols = new HashMap<>();
			mobileCard.put("subCols",subCols);
			//解析pageMeta
			Map<String, List<JSONObject>> pageMetaMap = ParsePageMetaUtils.parse(pageData.getPageMeta());
			
			List<JSONObject> formWidgetList = pageMetaMap.get("FormWidget");
			List<JSONObject> editTableWidgetList = pageMetaMap.get("EditTableWidget");
			Long mainFormId = IdWorker.getId();
			//先删除table、column表和es库
			customTableService.clearCustomTable(app.getId());
			//插入table、column和新增es库
			if(ListUtil.isNotEmpty(formWidgetList)) {
				CustomTableEntity mainTable = new CustomTableEntity();
				String mainTableName = "formWidget_"+pageData.getAppCode();
				mainTableName = mainTableName.toLowerCase();
				mainTable.setId(mainFormId);
				mainTable.setAppId(app.getId());
				mainTable.setUiKey("mainUiKey");
				mainTable.setTableName(mainTableName);
				mainTable.setTenantId(userContext.getTenantid());
				mainTable.setCreateUserCode(userContext.getUserCode());
				mainTable.setCreateTime(new Date());
				customTableService.saveOrUpdate(mainTable);
				
				XContentBuilder	mapping = jsonBuilder().startObject().startObject("properties");
				mapping.startObject("id").field("type", "text").endObject();
				mapping.startObject("orgId").field("type", "text").endObject();
				mapping.startObject("orgName").field("type", "text").endObject();
				mapping.startObject("billState").field("type", "integer").endObject();
				mapping.startObject("createTime").field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
				mapping.startObject("createUser").field("type", "text").endObject();
				mapping.startObject("creatorName").field("type", "text").endObject();
				/**插入主表公共字段*/
				List<CustomColumnEntity> entities = getPublicCustomColumnEntity(mainFormId,1);
				entities.forEach(col-> {
					customColumnService.save(col);
					JSONObject jsonObjectCol = new JSONObject();
					jsonObjectCol.put("colType",col.getType());
					jsonObjectCol.put("property",col.getProperty());
					jsonObjectCol.put("val",col.getVal());
					jsonObjectCol.put("columnName",col.getColumnName());
					mainCols.add(jsonObjectCol);
				});
				/** 循环插入主表字段*/
				for(int i=0; i<formWidgetList.size(); i++) {
					JSONObject form = formWidgetList.get(i);
					JSONObject ejcPart = getInitItem(form.getString("uititle"),"EJCPart");
					ejcPart.put("partName",form.getString("uititle"));
					ejcPart.put("uikey","EJCPart"+(i+1));
					ejcPart.put("leftType","1");
					ejcPart.put("backgroundColor","#F5F5F5");
					ejcPart.put("color","#999999");
					cardCenter.add(ejcPart);
					JSONObject mForm = getInitItem(form.getString("uititle"),"EJCFormDev");
					mForm.put("uikey","EJCFormDev"+(i+1));
					mForm.put("dataType","object");
					mForm.put("visible",true);
					ejcPart.getJSONArray("children").add(mForm);
					JSONArray mFormChildren = mForm.getJSONArray("children");

					JSONArray mainChildren = form.getJSONArray("children");
					if(mainChildren!=null){
						for(int m=0; m<mainChildren.size(); m++) {
							JSONObject mainField = mainChildren.getJSONObject(m);

							CustomColumnEntity mainCol = new CustomColumnEntity();
							mainCol.setId(IdWorker.getId());
							mainCol.setCustomTableId(mainFormId);
							mainCol.setColumnName(mainField.getString("uititle"));
							mainCol.setProperty(mainField.getString("uikey"));
							String uitype = mainField.getString("uisubtype");
							switch(uitype) {
								case "date":
									mainCol.setType("date");
									mainCol.setVal(mainField.toJSONString());
									mapping.startObject(mainField.getString("uikey")).field("type", "date").field("format",StringUtils.isNotEmpty(mainField.getString("format"))?mainField.getString("format"):"yyyy-MM-dd").endObject();
									JSONObject date = getDate(mainField);
									mFormChildren.add(date);
									break;
								case "time":
									mapping.startObject(mainField.getString("uikey")).field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
									mainCol.setType("date");
									break;
								case "number":
									mainCol.setType("number");
									mainCol.setVal(mainField.toJSONString());
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									JSONObject number = getNumber(mainField);
									mFormChildren.add(number);
									break;
								case "inputrefer":
									mainCol.setType("refer");
									mainCol.setVal(mainField.toJSONString());
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									JSONObject refer = getRefer(mainField);
									mFormChildren.add(refer);
									break;
								case "enumselect":
									mainCol.setType("refer");
									mainCol.setVal(mainField.toJSONString());
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									JSONObject enumselect = getEnumselect(mainField);
									mFormChildren.add(enumselect);
									break;
								case "switch":
									mainCol.setType("integer");
									String name = "";
									JSONObject mItemY = getInitItem("是","EJCPickerItem");
									mItemY.put("value",1);
									JSONObject mItemN = getInitItem("否","EJCPickerItem");
									mItemN.put("uikey","EJCPickerItem2");
									mItemN.put("value",0);
									if(StringUtils.isNotEmpty(mainField.getString("checkedChildren"))){
										name = name + mainField.getString("checkedChildren") +",";
										mItemY.put("uititle",mainField.getString("checkedChildren"));
									}else {
										name = name + "是,";
									}
									if(StringUtils.isNotEmpty(mainField.getString("unCheckedChildren"))){
										name = name + mainField.getString("unCheckedChildren");
										mItemN.put("uititle",mainField.getString("unCheckedChildren"));
									}else {
										name = name + "否";
									}
									mainCol.setVal(name);
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									JSONObject switchSelect = getSwitchSelect(mainField,mItemY,mItemN);
									mFormChildren.add(switchSelect);
									break;
								case "currency":
									mainCol.setType("bigdecimal");
									mainCol.setVal(mainField.toJSONString());
									mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
									JSONObject currency = getCurrency(mainField);
									mFormChildren.add(currency);
									break;
								case "select":
									mainCol.setType("select");
									mainCol.setVal(mainField.toJSONString());
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									JSONObject select = getSelect(mainField);
									mFormChildren.add(select);
									break;
								case "refAutoGrid":
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									mainCol.setType("refer");
									mainCol.setVal(mainField.getString("refinfokey"));
									break;
								case "input":
									mainCol.setType("string");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									JSONObject input = getInput(mainField);
									mFormChildren.add(input);
									break;
								case "textarea":
									mainCol.setType("string");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									JSONObject textarea = getTextarea(mainField);
									mFormChildren.add(textarea);
									break;
								case "imageupload":
									mainCol.setType("string");
									mainCol.setVal("image");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									JSONObject imageupload = getImageupload(mainField,app);
									mFormChildren.add(imageupload);
									break;
								default:
									mainCol.setType("string");
									mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
							}
							if(mainField.get("unique")!=null){
								mainCol.setUniqued(mainField.getBoolean("unique"));
							}
							mainCol.setSequence(m+1);
							customColumnService.save(mainCol);
							JSONObject jsonObjectCol = new JSONObject();
							jsonObjectCol.put("colType",mainCol.getType());
							jsonObjectCol.put("property",mainCol.getProperty());
							jsonObjectCol.put("val",mainCol.getVal());
							jsonObjectCol.put("columnName",mainCol.getColumnName());
							mainCols.add(jsonObjectCol);
						}
					}
				}
				mapping.endObject().endObject();
				CreateIndexRequest createIndexRequest = new CreateIndexRequest(mainTableName);
				createIndexRequest.settings(Settings.builder()
												.put("index.number_of_shards", 5)
												.put("index.number_of_replicas", 1)
											);
				createIndexRequest.mapping(mapping);
				/** 设置索引别名*/
				createIndexRequest.alias(new Alias(app.getAppName()+"主表"));
				CreateIndexResponse createIndexResponse;
				boolean acknowledged;
				try {
					/** 创建es库 */
					createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
					acknowledged = createIndexResponse.isAcknowledged();
					if (!acknowledged) {
						createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
						acknowledged = createIndexResponse.isAcknowledged();
						if (!acknowledged) {
							logger.info("es库创建失败");
							return CommonResponse.error("es库创建失败，请重试");
						}
					}
				}catch (IOException e){
					/** 重试一次*/
					createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
					acknowledged = createIndexResponse.isAcknowledged();
					if (!acknowledged) {
						logger.info("es库创建失败");
						return CommonResponse.error("es库创建失败，请重试");
					}
				}
			}
			/** 处理子表 */
			if(ListUtil.isNotEmpty(editTableWidgetList)) {
				for(int i=0; i<editTableWidgetList.size(); i++) {
					JSONObject editTableWidget = editTableWidgetList.get(i);
					String childUiKey = editTableWidget.getString("uikey");
					JSONObject mSubTable = getInitItem(editTableWidget.getString("uititle"),"EJCCFSSubTable");
					mSubTable.put("uikey",childUiKey);
					mSubTable.put("showIndex",false);
					cardCenter.add(mSubTable);
					Long childPkId = IdWorker.getId();
					String subTableName = "editTableWidget_"+pageData.getAppCode()+"_"+childUiKey;
					subTableName = subTableName.toLowerCase();
					CustomTableEntity subTable = new CustomTableEntity();
					subTable.setId(childPkId);
					subTable.setParentId(mainFormId);
					subTable.setAppId(app.getId());
					subTable.setUiKey(childUiKey);
					subTable.setTableName(subTableName);
					subTable.setTenantId(userContext.getTenantid());
					subTable.setCreateUserCode(userContext.getUserCode());
					subTable.setCreateTime(new Date());
					customTableService.saveOrUpdate(subTable);

					JSONArray childrenArray = editTableWidgetList.get(i).getJSONArray("children");

					XContentBuilder	mapping = jsonBuilder().startObject().startObject("properties");
					mapping.startObject("id").field("type", "text").endObject();
					mapping.startObject("pid").field("type", "text").endObject();
					mapping.startObject("rowIndex").field("type", "integer").endObject();
					mapping.startObject("createTime").field("type", "date").field("format","yyyy-MM-dd HH:mm:ss").endObject();
					mapping.startObject("createUser").field("type", "text").endObject();
					mapping.startObject("creatorName").field("type", "text").endObject();

					/**插入子表公共字段*/
					List<CustomColumnEntity> entities = getPublicCustomColumnEntity(childPkId,0);
					entities.forEach(col->customColumnService.save(col));
					/** 循环插入子表字段*/
					if(childrenArray!=null){
						for(int m=0; m<childrenArray.size(); m++) {
							JSONObject childField = childrenArray.getJSONObject(m);

							CustomColumnEntity subCol = new CustomColumnEntity();
							subCol.setId(IdWorker.getId());
							subCol.setCustomTableId(childPkId);
							subCol.setColumnName(childField.getString("uititle"));
							subCol.setProperty(childField.getString("uikey"));
							subCol.setSequence(m);
							String uitype = childField.getString("uisubtype");
							switch(uitype) {
								case "date":
									subCol.setType("date");
									mapping.startObject(childField.getString("uikey")).field("type", "date").field("format",StringUtils.isNotEmpty(childField.getString("format"))?childField.getString("format"):"yyyy-MM-dd").endObject();
									break;
								case "number":
									subCol.setType("number");
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									break;
								case "inputrefer":
								case "enumselect":
									subCol.setType("refer");
									subCol.setVal(childField.getString("refinfokey"));
									mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
								case "switch":
									subCol.setType("integer");
									String name = "";
									if(StringUtils.isNotEmpty(childField.getString("checkedChildren"))){
										name = name + childField.getString("checkedChildren") +",";
									}else {
										name = name + "是,";
									}
									if(StringUtils.isNotEmpty(childField.getString("unCheckedChildren"))){
										name = name + childField.getString("unCheckedChildren");
									}else {
										name = name + "否";
									}
									subCol.setVal(name);
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									break;
								case "currency":
									subCol.setType("bigdecimal");
									mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
									break;
								case "refAutoGrid":
									subCol.setType("string");
									mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									subCol.setVal(childField.getString("refinfokey"));
									break;
								case "select":
									subCol.setType("select");
									mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
								default:
									subCol.setType("string");
									mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
									break;
							}
							subCol.setVal(childField.toJSONString());
							customColumnService.save(subCol);
						}
					}
					mapping.endObject().endObject();
					CreateIndexRequest createIndexRequest = new CreateIndexRequest(subTableName);
					createIndexRequest.settings(Settings.builder()
							.put("index.number_of_replicas", 1)
							.put("index.number_of_shards", 5)
					);
					/** 设置索引别名*/
					createIndexRequest.alias(new Alias(app.getAppName()+"子表"+(i+1)));
					createIndexRequest.mapping(mapping);
					CreateIndexResponse createIndexResponse;
					boolean acknowledged;
					try {
						/** 创建es库 */
						createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
						acknowledged = createIndexResponse.isAcknowledged();
						if (!acknowledged) {
							createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
							acknowledged = createIndexResponse.isAcknowledged();
							if (!acknowledged) {
								logger.info("es库创建失败");
								return CommonResponse.error("es库创建失败，请重试");
							}
						}
					}catch (IOException e){
						logger.error("es库创建失败:"+e.getMessage());
						createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
						acknowledged = createIndexResponse.isAcknowledged();
						if (!acknowledged) {
							logger.info("es库创建失败");
							return CommonResponse.error("es库创建失败，请重试");
						}
					}
				}
			}

			/** 处理附件 */
			JSONObject attachMgr = getAttachMgr(app);
			cardCenter.add(attachMgr);

			saveMobilePage(app,false,mobileList);
			saveMobilePage(app,true,mobileCard);
			return CommonResponse.success("保存成功");
		}
		return CommonResponse.error("应用编码查询失败。");
	}

	/** 处理移动字段 */
	private JSONObject getAttachMgr(CustomAppEntity app){
		JSONObject attachMgr = getInitItem("附件管理","EJCAttachFilePick");
		attachMgr.put("uikey","attachMgr");
		attachMgr.put("sourceType","attachMgr");
		attachMgr.put("partName", "附件管理");

		JSONObject billType = new JSONObject();
		billType.put("id",app.getId());
		billType.put("billCode",app.getAppCode());
		billType.put("billName",app.getAppName());
		billType.put("metadataName",app.getAppName());
		attachMgr.put("billType",billType);
		JSONObject source = new JSONObject();
		source.put("id",app.getId());
		source.put("code",app.getAppCode());
		source.put("name",app.getAppName());
		source.put("sourceType","attachMgr");
		source.put("billType",app.getAppCode());
		attachMgr.put("source",source);

		return  attachMgr;
	}
	private JSONObject getDate(JSONObject mainField){
		JSONObject date = getInitItem(mainField.getString("uititle"),"EJCDatePicker");
		date.put("uikey",mainField.getString("uikey"));
		date.put("field",mainField.getString("uikey"));
		date.put("label", mainField.getString("uititle"));
		date.put("mode","date");
		date.put("required",mainField.getBoolean("required") != null && mainField.getBoolean("required"));
		date.put("disabled", mainField.getBoolean("disabled") != null && !mainField.getBoolean("disabled"));
		date.put("extra","请选择"+mainField.getString("uititle"));
		date.put("arrow","horizontal");
		return  date;
	}
	private JSONObject getNumber(JSONObject mainField){
		JSONObject number = getInitItem(mainField.getString("uititle"),"EJCInput");
		number.put("uikey",mainField.getString("uikey"));
		number.put("field",mainField.getString("uikey"));
		number.put("type","number");
		number.put("placeholder","请输入"+mainField.getString("uititle"));
		number.put("labelNumber",7);
		number.put("decimal",2);
		number.put("comma",true);
		number.put("required",mainField.getBoolean("required") != null && mainField.getBoolean("required"));
		number.put("editable", mainField.getBoolean("disabled") == null || !mainField.getBoolean("disabled"));
		number.put("clear",true);
		number.put("visible",true);
		return  number;
	}
	private JSONObject getRefer(JSONObject mainField){
		JSONObject refer = getInitItem(mainField.getString("uititle"),"EJCRefer");
		refer.put("uikey",mainField.getString("uikey"));
		refer.put("referName",mainField.getString("uikey"));
		refer.put("treeDisplayField","name");
		refer.put("showField","name");
		refer.put("id","id");
		JSONObject referCode = new JSONObject();
		referCode.put("refCode",mainField.getString("refinfokey"));
		referCode.put("code",mainField.getString("refinfokey"));
		referCode.put("name",mainField.getString("refName"));
		referCode.put("id",mainField.getString("refId"));
		refer.put("referCode",referCode);
		refer.put("labelNumber",7);
		refer.put("required",mainField.getBoolean("required") != null && mainField.getBoolean("required"));
		refer.put("disabled", mainField.getBoolean("disabled") != null && !mainField.getBoolean("disabled"));
		refer.put("visible",true);
		return  refer;
	}
	private JSONObject getEnumselect(JSONObject mainField){
		JSONObject enumselect = getInitItem(mainField.getString("uititle"),"EJCPicker");
		enumselect.put("uikey",mainField.getString("uikey"));
		enumselect.put("field",mainField.getString("uikey"));
		enumselect.put("label",mainField.getString("uititle"));
		enumselect.put("extra","请选择"+mainField.getString("uititle"));
		enumselect.put("okText","确定");
		enumselect.put("dismissText","取消");
		enumselect.put("cols",1);
		enumselect.put("type","2");
		enumselect.put("subType","enumselect");
		enumselect.put("defDocType","2");
		enumselect.put("arrow","horizontal");
		enumselect.put("required",mainField.getBoolean("required") != null && mainField.getBoolean("required"));
		enumselect.put("disabled", mainField.getBoolean("disabled") != null && !mainField.getBoolean("disabled"));
		enumselect.put("visible",true);
		JSONObject defDocCode = new JSONObject();
		defDocCode.put("id",mainField.getString("refId"));
		defDocCode.put("code",mainField.getString("code"));
		defDocCode.put("name",mainField.getString("refName"));
		enumselect.put("defDocCode",defDocCode);
		enumselect.put("source",defDocCode);
		return  enumselect;
	}
	private JSONObject getSwitchSelect(JSONObject mainField,JSONObject mItemY,JSONObject mItemN){
		JSONObject switchSelect = getInitItem(mainField.getString("uititle"),"EJCPicker");
		switchSelect.put("uikey",mainField.getString("uikey"));
		switchSelect.put("field",mainField.getString("uikey"));
		switchSelect.put("label",mainField.getString("uititle"));
		switchSelect.put("extra","请选择"+mainField.getString("uititle"));
		switchSelect.put("okText","确定");
		switchSelect.put("dismissText","取消");
		switchSelect.put("cols",1);
		switchSelect.put("type","1");
		switchSelect.put("subType","switch");
		switchSelect.put("defDocType","2");
		switchSelect.put("arrow","horizontal");
		switchSelect.put("required",mainField.getBoolean("required") != null && mainField.getBoolean("required"));
		switchSelect.put("disabled", mainField.getBoolean("disabled") != null && !mainField.getBoolean("disabled"));
		switchSelect.put("visible",true);
		JSONArray switchSelectChildren = new JSONArray();
		switchSelectChildren.add(mItemY);
		switchSelectChildren.add(mItemN);
		switchSelect.put("children",switchSelectChildren);
		return  switchSelect;
	}
	private JSONObject getCurrency(JSONObject mainField){
		JSONObject currency = getInitItem(mainField.getString("uititle"),"EJCInput");
		currency.put("uikey",mainField.getString("uikey"));
		currency.put("field",mainField.getString("uikey"));
		currency.put("type","money");
		currency.put("placeholder","请输入"+mainField.getString("uititle"));
		currency.put("labelNumber",7);
		currency.put("decimal",mainField.getInteger("decimal"));
		currency.put("required",mainField.getBoolean("required") != null && mainField.getBoolean("required"));
		currency.put("comma",mainField.getBoolean("commaVisible") == null || mainField.getBoolean("commaVisible"));
		currency.put("editable", mainField.getBoolean("disabled") == null || !mainField.getBoolean("disabled"));
		currency.put("clear",true);
		currency.put("visible",true);
		return  currency;
	}
	private JSONObject getSelect(JSONObject mainField){
		JSONObject select = getInitItem(mainField.getString("uititle"),"EJCPicker");
		select.put("uikey",mainField.getString("uikey"));
		select.put("field",mainField.getString("uikey"));
		select.put("label",mainField.getString("uititle"));
		select.put("extra","请选择"+mainField.getString("uititle"));
		select.put("okText","确定");
		select.put("dismissText","取消");
		select.put("cols",1);
		select.put("type","1");
		select.put("subType","select");
		select.put("defDocType","2");
		select.put("arrow","horizontal");
		select.put("required",mainField.getBoolean("required") != null && mainField.getBoolean("required"));
		select.put("disabled", mainField.getBoolean("disabled") != null && !mainField.getBoolean("disabled"));
		select.put("visible",true);
		JSONArray selectChildren = new JSONArray();
		JSONArray pcSelectChildren = mainField.getJSONArray("children");
		if(pcSelectChildren!=null && pcSelectChildren.size()>0){
			for (int j = 0; j < pcSelectChildren.size(); j++) {
				JSONObject pcItem = pcSelectChildren.getJSONObject(j);
				JSONObject mItem = getInitItem(pcItem.getString("uititle"),"EJCPickerItem");
				mItem.put("uikey",pcItem.getString("value"));
				mItem.put("value",pcItem.getString("value"));
				selectChildren.add(mItem);
			}
		}
		select.put("children",selectChildren);
		return  select;
	}
	private JSONObject getInput(JSONObject mainField){
		JSONObject input = getInitItem(mainField.getString("uititle"),"EJCInput");
		input.put("uikey",mainField.getString("uikey"));
		input.put("field",mainField.getString("uikey"));
		input.put("type","text");
		input.put("placeholder","请输入"+mainField.getString("uititle"));
		input.put("labelNumber",7);
		input.put("decimal",2);
		input.put("comma",true);
		input.put("required",mainField.getBoolean("required") != null && mainField.getBoolean("required"));
		input.put("editable", mainField.getBoolean("disabled") == null || !mainField.getBoolean("disabled"));
		input.put("clear",true);
		input.put("visible",true);
		return  input;
	}
	private JSONObject getTextarea(JSONObject mainField){
		JSONObject textarea = getInitItem(mainField.getString("uititle"),"EJCTextareaItem");
		textarea.put("uikey",mainField.getString("uikey"));
		textarea.put("field",mainField.getString("uikey"));
		textarea.put("label",mainField.getString("uititle"));
		textarea.put("direction","inside");
		textarea.put("rows",5);
		textarea.put("count",200);
		textarea.put("placeholder","请输入"+mainField.getString("uititle"));
		textarea.put("labelNumber",7);
		textarea.put("required",mainField.getBoolean("required") != null && mainField.getBoolean("required"));
		textarea.put("disabled", mainField.getBoolean("disabled") != null && mainField.getBoolean("disabled"));
		textarea.put("clear",true);
		textarea.put("visible",true);
		return  textarea;
	}
	private JSONObject getImageupload(JSONObject mainField,CustomAppEntity app){
		JSONObject imageupload = getInitItem(mainField.getString("uititle"),"EJCImagePicker");
		imageupload.put("uikey",mainField.getString("uikey"));
		imageupload.put("sourceType",mainField.getString("uikey"));
		imageupload.put("label",mainField.getString("uititle"));
		imageupload.put("maxSize",mainField.getInteger("maxCount"));
		imageupload.put("required",mainField.getBoolean("required") != null && mainField.getBoolean("required"));
		imageupload.put("disabled", mainField.getBoolean("disabled") != null && mainField.getBoolean("disabled"));
		imageupload.put("clear",true);
		imageupload.put("visible",true);
		JSONObject billType = new JSONObject();
		billType.put("id",app.getId());
		billType.put("code",app.getAppCode());
		billType.put("name",app.getAppName());
		imageupload.put("billType",billType);
		JSONObject source = new JSONObject();
		source.put("id",app.getId());
		source.put("code",app.getAppCode());
		source.put("name",app.getAppName());
		source.put("sourceType",mainField.getString("uikey"));
		source.put("billType",app.getAppCode());
		imageupload.put("source",source);
		return  imageupload;
	}

	private JSONArray getCardCenter(JSONObject card){
		JSONArray cardCenter = card.getJSONArray("children").getJSONObject(0).//上中下布局
				getJSONArray("children").getJSONObject(1).//中部
				getJSONArray("children");
		return cardCenter;
	}
	private JSONObject getInitMobilePage(CustomAppEntity app,boolean card){
		JSONObject page = new JSONObject();
		page.put("uikey",app.getAppCode()+"list");
		page.put("uititle",app.getAppName());
		page.put("uitype","EJCPage");
		page.put("cfsAppInfo",app);
		page.put("nid","nid_"+IdWorker.getId());
		JSONArray pageChildren = new JSONArray();
		if(card){
			page.put("uikey",app.getAppCode()+"card");
			page.put("uititle",app.getAppName()+"详情");
			page.put("children",pageChildren);
			JSONObject layout = getInitItem("上中下布局","EJCLayout");
			pageChildren.add(layout);
			JSONArray layoutChildren = layout.getJSONArray("children");
			JSONObject head = getInitItem("头部","EJCLayoutPanel");
			head.put("visible",false);
			head.put("position","top");
			head.put("height","0px");
			JSONObject center = getInitItem("中部","EJCLayoutPanel");
			center.put("uikey","EJCLayoutPanel2");
			center.put("position","center");
			center.put("visible",true);
			center.put("height","calc(100% - 45px)");
			JSONObject bottom = getInitItem("底部","EJCLayoutPanel");
			bottom.put("uikey","EJCLayoutPanel3");
			bottom.put("position","bottom");
			bottom.put("visible",true);
			bottom.put("height","45px");
			layoutChildren.add(head);
			layoutChildren.add(center);
			layoutChildren.add(bottom);
			JSONArray bottomChildren = bottom.getJSONArray("children");
			JSONObject bottomBar = getInitItem("底部按钮组","EJCButtonBar");
			bottomChildren.add(bottomBar);
			JSONArray bottomBarChildren = bottomBar.getJSONArray("children");
			JSONObject del = getInitItem("删除","EJCButton");
			del.put("uikey","removeBtn");
			del.put("size","large");
			del.put("radius",false);
			del.put("visible",false);
			del.put("type","warning");
			JSONObject saveBtn = getInitItem("保存","EJCButton");
			saveBtn.put("uikey","saveBtn");
			saveBtn.put("size","large");
			saveBtn.put("radius",false);
			saveBtn.put("visible",false);
			saveBtn.put("type","ghost");
			JSONObject callBackBtn = getInitItem("收回","EJCButton");
			callBackBtn.put("uikey","callBackBtn");
			callBackBtn.put("size","large");
			callBackBtn.put("radius",false);
			callBackBtn.put("visible",false);
			JSONObject EJCApproveSubmitBtn = getInitItem("提交","EJCApproveSubmitBtn");
			EJCApproveSubmitBtn.put("uikey","EJCApproveSubmitBtn");
			EJCApproveSubmitBtn.put("size","large");
			EJCApproveSubmitBtn.put("radius",false);
			EJCApproveSubmitBtn.put("visible",false);
			EJCApproveSubmitBtn.put("orgField","orgId");
			EJCApproveSubmitBtn.put("type","primary");
			JSONObject billTypeId = new JSONObject();
			billTypeId.put("billCode",app.getAppCode());
			billTypeId.put("billName",app.getAppName());
			billTypeId.put("metadataName",app.getAppName());
			billTypeId.put("code",app.getAppCode());
			billTypeId.put("name",app.getAppName());
			EJCApproveSubmitBtn.put("billTypeId",billTypeId);
			JSONObject EJCApproveRejectBtn = getInitItem("驳回","EJCApproveRejectBtn");
			EJCApproveRejectBtn.put("uikey","EJCApproveRejectBtn");
			EJCApproveRejectBtn.put("size","large");
			EJCApproveRejectBtn.put("radius",false);
			EJCApproveRejectBtn.put("visible",false);
			EJCApproveRejectBtn.put("type","warning");
			EJCApproveSubmitBtn.put("billTypeId",billTypeId);
			JSONObject EJCApproveAgreeBtn = getInitItem("同意","EJCApproveAgreeBtn");
			EJCApproveAgreeBtn.put("uikey","EJCApproveAgreeBtn");
			EJCApproveAgreeBtn.put("size","large");
			EJCApproveAgreeBtn.put("radius",false);
			EJCApproveAgreeBtn.put("visible",false);
			EJCApproveAgreeBtn.put("type","primary");
			JSONObject EJCApproveHistoryBtn = getInitItem("审批历史","EJCApproveHistoryBtn");
			EJCApproveHistoryBtn.put("uikey","EJCApproveHistoryBtn");
			EJCApproveHistoryBtn.put("size","large");
			EJCApproveHistoryBtn.put("radius",false);
			EJCApproveHistoryBtn.put("visible",false);
			EJCApproveHistoryBtn.put("type","primary");
			JSONObject saveApproveEditBtn = getInitItem("确认修改","EJCButton");
			saveApproveEditBtn.put("uikey","saveApproveEditBtn");
			saveApproveEditBtn.put("size","large");
			saveApproveEditBtn.put("radius",false);
			saveApproveEditBtn.put("visible",false);
			saveApproveEditBtn.put("type","primary");
			bottomBarChildren.add(del);
			bottomBarChildren.add(saveBtn);
			bottomBarChildren.add(callBackBtn);
			bottomBarChildren.add(EJCApproveSubmitBtn);
			bottomBarChildren.add(EJCApproveRejectBtn);
			bottomBarChildren.add(EJCApproveAgreeBtn);
			bottomBarChildren.add(EJCApproveHistoryBtn);
			bottomBarChildren.add(saveApproveEditBtn);
		}else {
			page.put("children",pageChildren);
			JSONObject layout = getInitItem("上中下布局","EJCLayout");
			JSONArray layoutChildren = layout.getJSONArray("children");
			JSONObject head = getInitItem("头部","EJCLayoutPanel");
			head.put("position","top");
			head.put("visible",true);
			head.put("height","45px");
			JSONArray headChildren = head.getJSONArray("children");
			JSONObject searchBar = getInitItem("搜索栏","EJCCFSSearchBar");
			searchBar.put("placeholder","请输入关键字搜索");
			headChildren.add(searchBar);

			JSONObject center = getInitItem("中部","EJCLayoutPanel");
			center.put("uikey","EJCLayoutPanel2");
			center.put("position","center");
			center.put("visible",true);
			center.put("height","calc(100% - 45px)");
			JSONArray centerChildren = center.getJSONArray("children");
			JSONObject cardList = getInitItem("卡片列表","EJCCardList");
			centerChildren.add(cardList);
			cardList.put("titleName","title");
			cardList.put("thumbName","thumb");
			cardList.put("IconSize","md");
			cardList.put("firstButtonText","取消");
			cardList.put("secondButtonText","删除");
			cardList.put("header","列表头部");
			cardList.put("footerBefore","正在加载");
			cardList.put("footerAfter","加载完成");
			cardList.put("cutheight","0px");
			cardList.put("initialListSize",100);
			cardList.put("onEndReachedThreshold",100);
			cardList.put("pageSize",30);
			cardList.put("showBottom",true);
			cardList.put("showFooter",true);
			cardList.put("disabledFirst",true);
			cardList.put("disabledSecond",true);
			JSONArray cardListChildren = cardList.getJSONArray("children");
			JSONObject cardListHead = getInitItem("头部","EJCCardListTitle");
			JSONObject cardListCenter = getInitItem("中部","EJCCardListContent");
			cardListCenter.put("lineNumber",2);
			JSONObject cardListBottom = getInitItem("底部","EJCCardListBottom");
			cardListBottom.put("approveBtn",true);
			JSONObject createTime = getInitItem("创建时间","EJCCardListItem");
			createTime.put("uikey","createTime");
			createTime.put("itemkey","createTime");
			createTime.put("itemType","date");
			createTime.put("location","left");
			createTime.put("fontSize","12px");
			createTime.put("dateType","ymdhms");
			cardListBottom.getJSONArray("children").add(createTime);
			cardListChildren.add(cardListHead);
			cardListChildren.add(cardListCenter);
			cardListChildren.add(cardListBottom);
			JSONObject bottom = getInitItem("底部","EJCLayoutPanel");
			bottom.put("uikey","EJCLayoutPanel3");
			bottom.put("position","bottom");
			bottom.put("visible",false);
			bottom.put("height","0");
			layoutChildren.add(head);
			layoutChildren.add(center);
			layoutChildren.add(bottom);
			JSONObject addBtn = getInitItem("新增按钮","EJCAddButton");
			addBtn.put("type","1");
			addBtn.put("leaderPage","0");
			pageChildren.add(layout);
			pageChildren.add(addBtn);
		}

		return page;
	}
	private JSONObject getInitItem(String title,String uitype){
		JSONObject item = new JSONObject();
		item.put("uititle",title);
		item.put("uitype",uitype);
		item.put("uikey",uitype+"1");
		item.put("children",new JSONArray());
		item.put("nid","nid_"+IdWorker.getId());
		return item;
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/12/29 保存移动端页面
	 * @Description saveMobilePage
	 * @Param [entity, card, data]
	 * @Return void
	 */
	private void saveMobilePage(CustomAppEntity entity,boolean card,JSONObject data){
		IdeModuleVO moduleVO = new IdeModuleVO();
		moduleVO.setId(IdWorker.getId());
		if(card){
			moduleVO.setCode(entity.getAppCode()+"card");
			logger.info("即将生成移动端卡片数据。。。。");
		}else {
			logger.info("即将生成移动端列表数据。。。。");
			moduleVO.setCode(entity.getAppCode()+"list");
		}
		moduleVO.setAppId(entity.getId());
		moduleVO.setAppCode(entity.getAppCode());
		moduleVO.setCreateDate(new Date());
		moduleVO.setName(entity.getAppName());
		moduleVO.setClientType("mobile");
		moduleVO.setCreateId(InvocationInfoProxy.getUserid());
		moduleVO.setData(data.toJSONString());
		CommonResponse response = iFrontApi.insertNewCfsPage(moduleVO);
		if(card){
			logger.info("生成移动端卡片数据"+JSONObject.toJSONString(moduleVO)+"  结果："+response.isSuccess());
		}else {
			logger.info("生成移动端列表数据"+JSONObject.toJSONString(moduleVO)+"  结果："+response.isSuccess());
		}
		if(!response.isSuccess()){
			iFrontApi.insertNewCfsPage(moduleVO);
		}
	}

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/12/9
	 * @Description getPublicCustomColumnEntity
	 * @Param [mainFormId,
	 *        type  1主表字段  0子表字段
	 * @Return java.util.List<com.ejianc.foundation.cfs.bean.CustomColumnEntity>
	 */
	private List<CustomColumnEntity> getPublicCustomColumnEntity(Long mainFormId,int type){
		List<CustomColumnEntity> list = new ArrayList<>();
		CustomColumnEntity col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setColumnName("id");
		col.setProperty("id");
		col.setType("string");
		col.setSequence(-1);
		list.add(col);
		col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setType("date");
		col.setColumnName("创建时间");
		col.setProperty("createTime");
		col.setSequence(0);
		list.add(col);
		col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setType("string");
		col.setColumnName("创建人id");
		col.setProperty("createUser");
		col.setSequence(0);
		list.add(col);
		col = new CustomColumnEntity();
		col.setId(IdWorker.getId());
		col.setCustomTableId(mainFormId);
		col.setType("string");
		col.setColumnName("创建人名称");
		col.setProperty("creatorName");
		col.setSequence(0);
		list.add(col);
		if(type == 1){
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("integer");
			col.setColumnName("单据状态");
			col.setProperty("billState");
			col.setSequence(0);
			list.add(col);
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("string");
			col.setColumnName("组织id");
			col.setProperty("orgId");
			col.setSequence(0);
			list.add(col);
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("string");
			col.setColumnName("组织名称");
			col.setProperty("orgName");
			col.setSequence(0);
			list.add(col);
		}else {
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("string");
			col.setColumnName("主表id");
			col.setProperty("pid");
			col.setSequence(0);
			list.add(col);
			col = new CustomColumnEntity();
			col.setId(IdWorker.getId());
			col.setCustomTableId(mainFormId);
			col.setType("integer");
			col.setColumnName("rowIndex");
			col.setProperty("rowIndex");
			col.setSequence(0);
			list.add(col);
		}
		return list;
	}

	/**
	 * 根据appCode查询其下所有属性值
	 * 
	 * @param appCode:应用code
	 * @param range: 为children时查询主子，否则查询主表字段
	 * @return
	 */
	@RequestMapping(value = "queryColumnList", method= RequestMethod.GET)
	public CommonResponse<List<ColumnVO>> queryColumnList(@RequestParam(value="appCode", required=true) String appCode,
			@RequestParam(value="range", required=true) String range){
		List<ColumnVO> resultList = new ArrayList<>();
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(appCode);
		if(app!=null){
			//1、根据appCode查询主表；
			//3、查询子表
			QueryWrapper<CustomTableEntity> childWrapper = new QueryWrapper<>();
			childWrapper.eq("app_id", app.getId());
			childWrapper.eq("dr", 0);
			List<CustomTableEntity> childCustomTableEntities = customTableService.list(childWrapper);
			Long mainId = null;
			List<CustomTableEntity> childrenCustomTables = new ArrayList<>();
			if(childCustomTableEntities!=null&&childCustomTableEntities.size()>0){
				for(CustomTableEntity entity : childCustomTableEntities){
					if(entity.getParentId()!=null){
						childrenCustomTables.add(entity);
					}else{
						mainId = entity.getId();
					}
				}
				if(mainId!=null){
					QueryWrapper<CustomColumnEntity> mainWrapper = new QueryWrapper<>();
					mainWrapper.eq("custom_table_id", mainId);
					mainWrapper.eq("dr", 0);
					//2、根据主表查询主表字段
					List<CustomColumnEntity> mainColumnList = customColumnService.list(mainWrapper);
					for(CustomColumnEntity entity : mainColumnList){
						ColumnVO vo = new ColumnVO();
						vo.setId(entity.getId());
						vo.setName(entity.getColumnName()+"("+entity.getProperty()+")");
						vo.setCode(entity.getProperty());
						vo.setDataType(entity.getType());
						vo.setDisplayName(entity.getColumnName());
						resultList.add(vo);
					}
					if("children".equals(range)){
						if(childrenCustomTables!=null&&childrenCustomTables.size()>0){
							//4、查询子表字段
							for(CustomTableEntity entity : childrenCustomTables){
								QueryWrapper<CustomColumnEntity> childrenWrapper = new QueryWrapper<>();
								childrenWrapper.eq("custom_table_id", entity.getId());
								childrenWrapper.eq("dr", 0);

								ColumnVO cvo = new ColumnVO();
								cvo.setId(entity.getId());
								cvo.setName(entity.getTableName());
								cvo.setCode(entity.getUiKey());
								cvo.setMainAttributeField(entity.getUiKey());
								cvo.setDisplayName(entity.getTableName());
								resultList.add(cvo);
								
								//2、根据主表查询主表字段
								List<CustomColumnEntity> childrenColumnList = customColumnService.list(childrenWrapper);
								if(childrenColumnList!=null&&childrenColumnList.size()>0){
									for(CustomColumnEntity columnentity : childrenColumnList){
										ColumnVO vo = new ColumnVO();
										vo.setId(columnentity.getId());
										vo.setName(columnentity.getColumnName()+"("+columnentity.getProperty()+")");
										vo.setCode(columnentity.getProperty());
										vo.setDisplayName(columnentity.getColumnName());
										vo.setDataType(columnentity.getType());
										vo.setParentId(entity.getId());
										vo.setMainAttributeField(entity.getUiKey());
										resultList.add(vo);
									}
								}
							}
						}
					}
				}
			}
		}
		return CommonResponse.success(resultList);
		
	}

	@RequestMapping(value = "updateBillState", method= RequestMethod.GET)
	public CommonResponse<Boolean> updateBillState(@RequestParam(value="appCode", required=true) String appCode,
												   @RequestParam(value="id", required=true) Long id,
												   @RequestParam(value="billState", required=true) Integer billState) throws IOException {
		CommonResponse<JSONObject> response = customTableService.queryDetail(appCode,id);
		if(response.isSuccess()){
			//根据应用编号查询应用
			CustomAppEntity app = customAppService.queryCustomAppByCode(appCode);
			//根据appid查询主表信息
			CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());
			JSONObject entity = response.getData();
			entity.put("billState",billState);
			UpdateRequest updateRequest = new UpdateRequest(mainTableEntity.getTableName(), id.toString());
			updateRequest.doc(entity, XContentType.JSON);
			UpdateResponse update = client.update(updateRequest, RequestOptions.DEFAULT);
			if(update.status().getStatus() != RestStatus.OK.getStatus()){
				logger.error(response.toString());
				return CommonResponse.error("更新失败");
			}
			QueryParam dataParam = new QueryParam();
			dataParam.getParams().put("mainId",new Parameter(QueryParam.EQ,id));
			List<CustomDataEntity> dataEntityList = iCustomDataService.queryList(dataParam,false);
			CustomDataEntity customDataEntity;
			if(ListUtil.isNotEmpty(dataEntityList)){
				customDataEntity = dataEntityList.get(0);
				JSONObject saveData = JSONObject.parseObject(customDataEntity.getData());
				saveData.put("billState",billState);
				customDataEntity.setData(saveData.toJSONString());
				iCustomDataService.saveOrUpdate(customDataEntity,false);
			}
			return CommonResponse.success("更新成功！",true);
		}
		return CommonResponse.error("更新失败");
	}


	@RequestMapping(value = "queryDetail", method= RequestMethod.GET)
	public CommonResponse<JSONObject> queryDetail(@RequestParam(value="appCode", required=true) String appCode,
												  @RequestParam(value="id", required=true) Long id) throws IOException {
		return customTableService.queryDetail(appCode,id);
	}


	@RequestMapping(value = "queryPrintDetail", method= RequestMethod.GET)
	public CommonResponse<JSONObject> queryPrintDetail(@RequestParam(value="appCode", required=true) String appCode,
												  @RequestParam(value="id", required=true) Long id) throws IOException {
		return customTableService.queryPrintDetail(appCode,id);
	}
}
