package com.ejianc.foundation.cfs.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class ParsePageMetaUtils {
	
	private final static Set<String> COMPONENT_TYPE = new HashSet<>();
	
	static {
		COMPONENT_TYPE.add("FormWidget");
		COMPONENT_TYPE.add("EditTableWidget");
	}
	
	public static Map<String, List<JSONObject>> parse(String pageMeta) {
		Map<String, List<JSONObject>> resultMap = new HashMap<String, List<JSONObject>>(); 
		
		JSONObject pageMetaJson = JSON.parseObject(pageMeta);
		String uitype = pageMetaJson.getString("uitype");
		if(COMPONENT_TYPE.contains(uitype)) {
			if(resultMap.containsKey(uitype)) {
				resultMap.get(uitype).add(pageMetaJson);
			}else{
				List<JSONObject> resultList = new ArrayList<>();
				resultList.add(pageMetaJson);
				resultMap.put(uitype, resultList);
			}
		}
		
		JSONArray childrenJson = pageMetaJson.getJSONArray("children");
		if(childrenJson != null && !childrenJson.isEmpty()) {
			loopParse(childrenJson, resultMap);
		}
		
		return resultMap;
	}

	private static void loopParse(JSONArray children, Map<String, List<JSONObject>> resultMap) {
		for(int i=0;i<children.size();i++) {
			JSONObject jsonObject = children.getJSONObject(i);
			String uitype = jsonObject.getString("uitype");
			if(COMPONENT_TYPE.contains(uitype)) {
				if(resultMap.containsKey(uitype)) {
					resultMap.get(uitype).add(jsonObject);
				}else{
					List<JSONObject> resultList = new ArrayList<>();
					resultList.add(jsonObject);
					resultMap.put(uitype, resultList);
				}
			}
			JSONArray childrenJson = null;
			try{
				childrenJson = jsonObject.getJSONArray("children");
			}catch(Exception e) {}
			if(childrenJson != null && !childrenJson.isEmpty()) {
				loopParse(childrenJson, resultMap);
			}
		}
	}
	
	
	public static void main(String[] args) {
		String text = "{\"uikey\":\"cardPage\",\"uititle\":\"收料入库卡片\",\"uitype\":\"EJCPage\",\"themeClassName\":\"GEJC\",\"dataprops\":{\"project\":{\"id\":\"322683907509321758\",\"displayName\":\"物资管理\",\"projectName\":\"ejc-material-web\"},\"entity\":{\"id\":\"326041962640834592\",\"displayName\":\"收料入库\",\"entityFullName\":\"com.ejianc.business.material.bean.InstoreEntity\"}},\"billName\":\"收料入库\",\"billType\":\"BT200611000000015\",\"children\":[{\"uititle\":\"面包屑5\",\"uitype\":\"EJCBreadcrumb\",\"nid\":\"nid_1592217698094_4189\",\"children\":[{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"收料入库\",\"key\":1592217702754,\"uikey\":\"1592217702754\",\"children\":\"收料入库\",\"nid\":\"nid_1592217702755_4194\",\"href\":\"instore\"},{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"详情\",\"key\":1592217707722,\"uikey\":\"1592217707722\",\"children\":\"详情\",\"nid\":\"nid_1592217707722_4195\"}]},{\"uititle\":\"工具栏1\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1591868482300_6416\",\"children\":[{\"uititle\":\"保存\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1589191191111_126\",\"children\":\"保存\",\"uikey\":\"saveBtn\",\"type\":\"primary\",\"icon\":\"book\",\"ghost\":true}]},{\"uititle\":\"基本信息\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1591868495757_6444\",\"children\":[{\"uititle\":\"表单1\",\"uitype\":\"FormWidget\",\"nid\":\"nid_1591868498519_6447\",\"colnumber\":3,\"dataprops\":{\"system\":{\"id\":\"322683907509321758\",\"systemCnName\":\"物资管理\",\"systemName\":\"ejc-material-web\"},\"entity\":{\"id\":\"326041962640834592\",\"entityCnName\":\"收料入库\",\"entityFullName\":\"326041962640834592\"}},\"children\":[{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"供应商\",\"uititle\":\"供应商\",\"uikey\":\"supplierId\",\"nid\":\"nid_1591868579892_6520\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"refinfokey\":\"supplier_tree_grid\",\"refName\":\"供方\",\"refId\":\"321290255763505209\",\"required\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"合同\",\"uititle\":\"合同\",\"uikey\":\"contractId\",\"nid\":\"nid_1591868579892_6521\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"required\":true,\"refinfokey\":\"material_contract\",\"refName\":\"物资合同列表参照\",\"refId\":\"327395662865104986\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"select\",\"label\":\"是否属于项目\",\"uititle\":\"是否属于项目\",\"uikey\":\"projectFlag\",\"nid\":\"nid_1591869128536_8244\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"required\":true,\"children\":[{\"uitype\":\"EJCOption\",\"uititle\":\"是\",\"children\":\"是\",\"uikey\":\"1\",\"value\":\"1\",\"key\":\"1\",\"nid\":\"nid_1591964153569_11777\",\"text\":\"是\"},{\"uitype\":\"EJCOption\",\"uititle\":\"否\",\"children\":\"否\",\"uikey\":\"0\",\"value\":\"0\",\"key\":\"0\",\"nid\":\"nid_1591964154538_11803\",\"text\":\"否\"}],\"defaultValue\":\"1\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"所属项目\",\"uititle\":\"所属项目\",\"uikey\":\"projectId\",\"nid\":\"nid_1591869128536_8243\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"refinfokey\":\"market-project-refer-list\",\"refName\":\"项目登记参照\",\"refId\":\"320519315475660894\",\"required\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"所属组织\",\"uititle\":\"所属组织\",\"uikey\":\"orgId\",\"nid\":\"nid_1591868579892_6518\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"refinfokey\":\"idm_org_tree\",\"refName\":\"组织\",\"refId\":\"310428626500755491\",\"required\":true,\"disabled\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"仓库\",\"uititle\":\"仓库\",\"uikey\":\"storeId\",\"nid\":\"nid_1591868579892_6519\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"refinfokey\":\"material-warehouse-grid\",\"refName\":\"仓库\",\"refId\":\"326011743083167815\",\"required\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"date\",\"label\":\"入库日期\",\"uititle\":\"入库日期\",\"uikey\":\"instoreDate\",\"nid\":\"nid_1591868579892_6517\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"required\":true,\"format\":\"yyyy-MM-dd\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"textarea\",\"label\":\"备注\",\"uititle\":\"备注\",\"nid\":\"nid_1591964395978_11981\",\"uikey\":\"note\",\"labelCol\":{\"span\":2},\"wrapperCol\":{\"span\":21},\"newline\":true,\"maxLength\":\"500\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"入库单号\",\"uititle\":\"入库单号\",\"uikey\":\"billCode\",\"nid\":\"nid_1591868579892_6522\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"所属组织名称\",\"uititle\":\"所属组织名称\",\"uikey\":\"orgName\",\"nid\":\"nid_1591868579892_6523\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"仓库名称\",\"uititle\":\"仓库名称\",\"uikey\":\"storeName\",\"nid\":\"nid_1591868579892_6524\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"供应商名称\",\"uititle\":\"供应商名称\",\"uikey\":\"supplierName\",\"nid\":\"nid_1591868579892_6525\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"合同名称\",\"uititle\":\"合同名称\",\"uikey\":\"contractName\",\"nid\":\"nid_1591868579892_6526\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"主键ID\",\"uititle\":\"主键ID\",\"uikey\":\"id\",\"nid\":\"nid_1591868579892_6527\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"所属项目名称\",\"uititle\":\"所属项目名称\",\"uikey\":\"projectName\",\"nid\":\"nid_1591869128536_8242\",\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"refAutoGrid\",\"label\":\"jj\",\"uititle\":\"jj\",\"nid\":\"nid_1592193054829_4\",\"uikey\":\"test\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"valueType\":\"object\",\"maxSize\":\"20\",\"propKey\":[],\"refinfokey\":\"material-warehouse-grid\",\"refName\":\"仓库\",\"refId\":\"326011743083167815\",\"visible\":false},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"是否有合同入库\",\"uititle\":\"是否有合同入库\",\"nid\":\"nid_1592226325602_3668\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"uikey\":\"contractType\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"visible\":false},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"入库类型\",\"uititle\":\"入库类型\",\"nid\":\"nid_1592278189469_2825\",\"uikey\":\"instoreType\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"visible\":false},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"所属项目编码\",\"uititle\":\"所属项目编码\",\"nid\":\"nid_1603281495991_19\",\"uikey\":\"projectCode\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"visible\":false}],\"uikey\":\"baseForm\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}}],\"uikey\":\"\",\"title\":\"基本信息\",\"expandText\":\"收起\",\"collapseText\":\"展开\"},{\"uititle\":\"物资明细\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1591868525762_6454\",\"children\":[{\"uititle\":\"工具栏2\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1591876014551_4857\",\"children\":[{\"uititle\":\"新增\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1591876157798_5112\",\"children\":\"新增\",\"uikey\":\"addBtn\",\"ghost\":true,\"type\":\"primary\",\"icon\":\"plus\",\"visible\":false},{\"uititle\":\"参照合同\",\"uitype\":\"EJCReferButton\",\"nid\":\"nid_1591876020589_4861\",\"buttonText\":\"参照合同\",\"uikey\":\"contractMaterialBtn\",\"type\":\"primary\",\"ghost\":true,\"multiselect\":true,\"refinfokey\":\"material_contract_material_list\",\"refName\":\"合同物资明细参照\",\"refId\":\"327400432677945347\"}]},{\"uititle\":\"编辑表格1\",\"uitype\":\"EditTableWidget\",\"nid\":\"nid_1591868529057_6457\",\"dataprops\":{\"system\":{\"id\":\"322683907509321758\",\"systemCnName\":\"物资管理\",\"systemName\":\"ejc-material-web\"},\"entity\":{\"id\":\"326077713621450848\",\"entityCnName\":\"收料入库-物资\",\"entityFullName\":\"326077713621450848\"}},\"uikey\":\"instoreMaterialList\",\"rowKey\":\"id\",\"dataSource\":[],\"children\":[{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资分类\",\"title\":\"物资分类\",\"uikey\":\"materialCategoryName\",\"key\":\"materialCategoryName\",\"dataIndex\":\"materialCategoryName\",\"nid\":\"nid_1591874317373_6\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资名称\",\"title\":\"物资名称\",\"uikey\":\"materialName\",\"key\":\"materialName\",\"dataIndex\":\"materialName\",\"nid\":\"nid_1591874317373_5\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"规格型号\",\"title\":\"规格型号\",\"uikey\":\"materialSpec\",\"key\":\"materialSpec\",\"dataIndex\":\"materialSpec\",\"nid\":\"nid_1591874317373_4\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"计量单位\",\"title\":\"计量单位\",\"uikey\":\"materialUnit\",\"key\":\"materialUnit\",\"dataIndex\":\"materialUnit\",\"nid\":\"nid_1591874317373_3\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"入库数量\",\"title\":\"入库数量\",\"uikey\":\"instoreNumber\",\"key\":\"instoreNumber\",\"dataIndex\":\"instoreNumber\",\"nid\":\"nid_1591874317373_8\",\"align\":\"left\",\"required\":true,\"dataprops\":{},\"commaVisible\":true,\"decimal\":4,\"symbol\":\" \",\"max\":\"100000000000\",\"showDecimal\":2},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"单价（元）\",\"title\":\"单价（元）\",\"uikey\":\"unitPrice\",\"key\":\"unitPrice\",\"dataIndex\":\"unitPrice\",\"nid\":\"nid_1591874317373_12\",\"align\":\"left\",\"required\":true,\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"symbol\":\" \",\"max\":\"100000000000\",\"showDecimal\":2},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"金额（元）\",\"title\":\"金额（元）\",\"uikey\":\"amount\",\"key\":\"amount\",\"dataIndex\":\"amount\",\"nid\":\"nid_1591874317373_11\",\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"symbol\":\" \",\"editable\":false,\"showDecimal\":2,\"max\":\"1000000000000000\"},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"备注\",\"title\":\"备注\",\"uikey\":\"remark\",\"key\":\"remark\",\"dataIndex\":\"remark\",\"nid\":\"nid_1591874317373_13\",\"dataprops\":{},\"maxLength\":\"100\"},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"主表id\",\"title\":\"主表id\",\"uikey\":\"instoreId\",\"key\":\"instoreId\",\"dataIndex\":\"instoreId\",\"nid\":\"nid_1591874317373_7\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资id\",\"title\":\"物资id\",\"uikey\":\"materialId\",\"key\":\"materialId\",\"dataIndex\":\"materialId\",\"nid\":\"nid_1591874317373_9\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资分类id\",\"title\":\"物资分类id\",\"uikey\":\"materialCategoryId\",\"key\":\"materialCategoryId\",\"dataIndex\":\"materialCategoryId\",\"nid\":\"nid_1591874317373_10\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"来源\",\"title\":\"来源\",\"uikey\":\"sourceType\",\"key\":\"sourceType\",\"dataIndex\":\"sourceType\",\"nid\":\"nid_1591874317373_14\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"date\",\"uititle\":\"入库日期\",\"title\":\"入库日期\",\"uikey\":\"instoreDate\",\"key\":\"instoreDate\",\"dataIndex\":\"instoreDate\",\"nid\":\"nid_1592194593570_2122\",\"isShow\":false,\"dataprops\":{}},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"仓库id\",\"title\":\"仓库id\",\"uikey\":\"storeId\",\"key\":\"storeId\",\"dataIndex\":\"storeId\",\"nid\":\"nid_1592194595425_2124\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"入库库物资库存状态\",\"title\":\"入库库物资库存状态\",\"uikey\":\"storeState\",\"key\":\"storeState\",\"dataIndex\":\"storeState\",\"nid\":\"nid_1592195097419_3517\",\"dataprops\":{},\"isShow\":false}],\"showRowNum\":true}],\"uikey\":\"\",\"title\":\"物资明细\",\"expandText\":\"收起\",\"collapseText\":\"展开\"},{\"uititle\":\"单据审计\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1592309888000_2\",\"children\":[{\"uititle\":\"单据审计1\",\"uitype\":\"CPAuditInfo\",\"nid\":\"nid_1592309903280_5\",\"uikey\":\"auditInfo\",\"primaryKey\":\"id\",\"billName\":\"收料入库\",\"billType\":\"BT200611000000015\"}],\"uikey\":\"\",\"title\":\"单据审计\",\"expand\":false,\"expandText\":\"收起\",\"collapseText\":\"展开\"}],\"nid\":\"nid_1591868670748_7019\"}";
		Map<String, List<JSONObject>> resultMap = parse(text);
		System.out.println(resultMap);
	}

}
