package com.ejianc.foundation.cust.bean;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;

import org.apache.commons.lang.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.foundation.cust.util.AppUtil;
import com.ejianc.foundation.cust.util.ColumnType;
import com.ejianc.foundation.cust.util.IGroovyScriptEngine;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseEntity;

import cn.hutool.core.date.DateUtil;

@TableName("ejc_cfs_custform_busicolumn")
public class BusinessColumnEntity extends BaseEntity {

	private static final long serialVersionUID = 8140630206523368902L;

	@TableField(value = "table_id")
	private Long tableId;

	@TableField(value = "unique_key")
	private String uniqueKey;

	@TableField(value = "name")
	private String name;

	@TableField(value = "type")
	private String type;

	@TableField(value = "col_length")
	private Integer colLength;

	@TableField(value = "col_decimal")
	private Integer colDecimal;

	@TableField(value = "required")
	private Integer required;

	@TableField(value = "primary")
	private Integer primary; //是否主键

	@TableField(value = "default_value")
	private String defaultValue;

	@TableField(value = "comment")
	private String comment;

	@TableField(exist = false)
	private BusinessTableEntity table;
	@TableField(exist = false)
	private BusinessColumnCtrlEntity ctrl;

	public Long getTableId() {
		return tableId;
	}

	public void setTableId(Long tableId) {
		this.tableId = tableId;
	}

	public String getUniqueKey() {
		return uniqueKey;
	}

	public void setUniqueKey(String uniqueKey) {
		this.uniqueKey = uniqueKey;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getColLength() {
		return colLength;
	}

	public void setColLength(Integer colLength) {
		this.colLength = colLength;
	}

	public Integer getColDecimal() {
		return colDecimal;
	}

	public void setColDecimal(Integer colDecimal) {
		this.colDecimal = colDecimal;
	}

	public Integer getRequired() {
		return required;
	}

	public void setRequired(Integer required) {
		this.required = required;
	}

	public Integer getPrimary() {
		return primary;
	}

	public void setPrimary(Integer primary) {
		this.primary = primary;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public BusinessTableEntity getTable() {
		return table;
	}

	public void setTable(BusinessTableEntity table) {
		this.table = table;
	}

	public BusinessColumnCtrlEntity getCtrl() {
		return ctrl;
	}

	public void setCtrl(BusinessColumnCtrlEntity ctrl) {
		this.ctrl = ctrl;
	}
	
	public Object initValue() {
		return value(defaultValue);
	}

	public Object value(String str) {
		if (StringUtils.isEmpty(str)) {
			return null;
		}
		if (str.startsWith("{") && str.endsWith("}")) {// 以{}包围的是脚本
			IGroovyScriptEngine engine = AppUtil.getBean(IGroovyScriptEngine.class);
			String script = str.substring(1, str.length() - 1);
			return engine.executeObject(script, new HashMap<>());
		}

		Object value = null;
		try {
			if (ColumnType.VARCHAR.equalsWithKey(type) || ColumnType.CLOB.equalsWithKey(type)) {
				value = str;
			} else if (ColumnType.NUMBER.equalsWithKey(type)) {
				BigDecimal bigDecimal = new BigDecimal(str);
				// 保留精度小数，且四舍五入
				value = bigDecimal.setScale(this.getColDecimal(), RoundingMode.HALF_UP);
			} else if (ColumnType.DATE.equalsWithKey(type)) {
				JSONObject config = JSON.parseObject(this.getCtrl().getConfig());
				try {
					value = DateUtil.parse(str, config.getString("format"));
				} catch (Exception e) {// 解析失败，默认超匹配模式
					value = DateUtil.parse(str);
				}
			}
		} catch (Exception e) {
			ColumnType columnType = ColumnType.getByKey(this.type);
			throw new BusinessException("字段值解析失败，无法把字符串[" + str + "]转化成" + columnType.getDesc() + "[" + columnType.getKey() + "]");
		}
		return value;
	}

}
