package com.ejianc.foundation.cust.bean;

public enum FormType {
    MOBILE("mobile"),
    PC_IVIEW("pc_iview");

    private final String value;

    FormType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static FormType fromValue(String v) {
        for (FormType c : FormType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
