package com.ejianc.foundation.cust.controller;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.cust.bean.FormTemplateEntity;
import com.ejianc.foundation.cust.service.IFormTemplateService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;

@RestController
@RequestMapping("/form/formTemplate/")
public class FormTemplateController {
	
	@Autowired
	private IFormTemplateService formTemplateService;
	
	private String generateKey() {
		SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
		return "cust"+Utils.randString(3).toLowerCase()+format.format(new Date());
	}
	
	/**
	 * formTemplateEdit.html的save后端
	 * 
	 * @param formTemplateEntity
	 * @return
	 */
	@RequestMapping("save")
	public CommonResponse<FormTemplateEntity> save(@RequestBody FormTemplateEntity formTemplateEntity) {
		if(formTemplateEntity.getId() != null && formTemplateEntity.getId() > 0) {
			formTemplateService.updateById(formTemplateEntity);
			return CommonResponse.success("修改成功");
		}else{
			formTemplateEntity.setEditable(1);
			formTemplateEntity.setUniqueKey(generateKey());
			formTemplateService.save(formTemplateEntity);
			return CommonResponse.success("保存成功");
		}
	}
	
	
	/**
	 * 获取formTemplate的后端
     * 目前支持根据id 获取formTemplate
     * 
	 * @param request
	 * @return
	 */
	@RequestMapping("getObject")
	public CommonResponse<FormTemplateEntity> getObject(HttpServletRequest request) {
		String id = request.getParameter("id");
		String key = request.getParameter("key");
		FormTemplateEntity formTemplate = null;
		if(StringUtils.isNotBlank(id)) {
			formTemplate = formTemplateService.getById(id);
		}else if(StringUtils.isNotBlank(key)) {
			QueryWrapper<FormTemplateEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("unique_key", key);
			formTemplate = formTemplateService.getOne(queryWrapper);
		}
		return CommonResponse.success(formTemplate);
	}
	
	/**
	 * list页的后端
	 * 
	 * @return
	 */
	@RequestMapping("listJson")
	public CommonResponse<IPage<FormTemplateEntity>> listJson(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		IPage<FormTemplateEntity> pageData = formTemplateService.queryPage(queryParam, false);
		return CommonResponse.success(pageData);
	}
	
	/**
	 * 批量删除
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping("remove")
	public CommonResponse<String> remove(HttpServletRequest request) {
		String ids = request.getParameter("id");
		String[] arrIds = ids.split(",");
		for(String id:arrIds) {
			formTemplateService.removeById(id);
		}
		return CommonResponse.success("删除表单模板成功");
	}
	
	/**
	 * 初始化模板
	 * 
	 * @return
	 */
	@RequestMapping("initTemplate")
	public CommonResponse<String> initTemplate() {
		formTemplateService.init();
		return CommonResponse.success("初始化成功");
	}
	
}
