/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomAppGroupEntity;
import com.ejianc.foundation.cfs.service.ICustomAppGroupService;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.vo.CustomAppVO;
import com.ejianc.foundation.front.api.IFrontApi;
import com.ejianc.foundation.front.vo.IdeModuleVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"custom/app"})
public class CustomAppController
implements Serializable {
    private static final long serialVersionUID = -2549939173725536626L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CURRENTUSER_ROLE_KEY = "currentuser_role_key:";
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private ICustomListService customListService;
    @Autowired
    private IFrontApi iFrontApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private ICustomAppGroupService appGroupService;

    @RequestMapping(value={"/queryAppList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CustomAppVO>> queryAppList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.customAppService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomAppVO.class));
        if (ListUtil.isNotEmpty((List)pageData.getRecords())) {
            for (CustomAppVO record : pageData.getRecords()) {
                record.setChildren(null);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/pageRefer"})
    @ResponseBody
    public CommonResponse<IPage<CustomAppVO>> pageRefer(@RequestParam(value="pageNumber", required=false, defaultValue="1") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="relyCondition", required=false) String relyCondition, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("appState", new Parameter("eq", (Object)1));
        param.getParams().put("publishState", new Parameter("eq", (Object)1));
        param.getFuzzyFields().add("appCode");
        param.getFuzzyFields().add("appName");
        param.setSearchText(searchText);
        param.getOrderMap().put("sequence", "asc");
        IPage page = this.customAppService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomAppVO.class));
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/saveOrUpdateApp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CustomAppEntity> saveOrUpdateApp(@RequestBody CustomAppVO customAppVO) {
        if (customAppVO.getId() != null && customAppVO.getId() > 0L) {
            CustomAppEntity uniqueBean = (CustomAppEntity)((Object)this.customAppService.selectById(customAppVO.getId()));
            uniqueBean.setAppGroupId(customAppVO.getAppGroupId());
            if (!Objects.equals(customAppVO.getAppCode(), uniqueBean.getAppCode())) {
                return CommonResponse.error((String)"\u5e94\u7528\u7f16\u7801\u4e0d\u53ef\u4fee\u6539\uff01");
            }
            if (!Objects.equals(customAppVO.getAppName(), uniqueBean.getAppName())) {
                return CommonResponse.error((String)"\u5e94\u7528\u540d\u79f0\u4e0d\u53ef\u4fee\u6539\uff01");
            }
            if ((uniqueBean.getPublishState() == 0 || uniqueBean.getPublishState() == null) && customAppVO.getPublishState() == 1) {
                QueryParam param = new QueryParam();
                param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                param.getParams().put("appId", new Parameter("eq", (Object)uniqueBean.getId()));
                List list = this.customListService.queryList(param, false);
                if (ListUtil.isEmpty((List)list)) {
                    return CommonResponse.error((String)"\u5c1a\u672a\u914d\u7f6e\u5217\u8868\u9879\uff0c\u8bf7\u5148\u914d\u7f6e\u5217\u8868\u9879\uff01");
                }
            }
            uniqueBean.setAppIcon(customAppVO.getAppIcon());
            uniqueBean.setAuthFlag(customAppVO.getAuthFlag());
            uniqueBean.setQueryRange(customAppVO.getQueryRange());
            uniqueBean.setAppState(customAppVO.getAppState());
            uniqueBean.setPublishState(customAppVO.getPublishState());
            uniqueBean.setQueryAllRangeUserIds(customAppVO.getQueryAllRangeUserIds());
            uniqueBean.setSequence(customAppVO.getSequence());
            uniqueBean.setType(customAppVO.getType());
            this.customAppService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)((Object)uniqueBean));
        }
        CustomAppEntity entity = (CustomAppEntity)((Object)BeanMapper.map((Object)customAppVO, CustomAppEntity.class));
        entity.setId(IdWorker.getId());
        entity.setAppCode("CFS" + System.currentTimeMillis());
        IdeModuleVO moduleVO = new IdeModuleVO();
        moduleVO.setId(entity.getId());
        moduleVO.setCode(entity.getAppCode());
        moduleVO.setAppId(entity.getId());
        moduleVO.setAppCode(entity.getAppCode());
        moduleVO.setCreateDate(new Date());
        moduleVO.setName(entity.getAppName());
        moduleVO.setCreateId(InvocationInfoProxy.getUserid());
        moduleVO.setData(this.customAppService.getPageInitData(entity.getAppName(), entity.getAppCode()));
        CommonResponse response = this.iFrontApi.insertNewCfsPage(moduleVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        this.customAppService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)((Object)entity));
    }

    @RequestMapping(value={"/deleteApp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteApp(@RequestBody List<CustomAppVO> vos) {
        this.customAppService.deleteApp(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"list"})
    public CommonResponse<List<CustomAppVO>> queryList(@RequestParam(required=false, value="mobile") Integer mobile, @RequestParam(required=false, value="searchText") String searchText) {
        List<CustomAppVO> noAuthCustomApps;
        ArrayList<CustomAppVO> appList = new ArrayList<CustomAppVO>();
        ArrayList<CustomAppVO> result = new ArrayList<CustomAppVO>();
        HashMap<Long, CustomAppVO> customAppMap = new HashMap<Long, CustomAppVO>();
        Long userId = InvocationInfoProxy.getUserid();
        List<Long> roleIds = this.getUserRoleCache(userId);
        this.logger.info("\u67e5\u8be2\u9996\u9875\u83dc\u5355\uff0c\u5f53\u524d\u7528\u6237\u89d2\u8272\u7f13\u5b58\u4e2d\u7684\u6570\u636e\uff1auserId={}\uff0c\u79df\u6237id={},\u89d2\u8272ids={}", new Object[]{userId, InvocationInfoProxy.getTenantid(), JSONObject.toJSONString(roleIds)});
        if (roleIds != null && roleIds.size() > 0) {
            Object customAppVos;
            String roleIdStr = "";
            for (Long l : roleIds) {
                roleIdStr = roleIdStr + l + ",";
            }
            if (StringUtils.isNotBlank((CharSequence)roleIdStr) && (customAppVos = this.customAppService.queryUserCustomAppList(roleIdStr.substring(0, roleIdStr.length() - 1), searchText)) != null && customAppVos.size() > 0) {
                Iterator iterator = customAppVos.iterator();
                while (iterator.hasNext()) {
                    CustomAppVO customAppVo = (CustomAppVO)iterator.next();
                    if (mobile != null && mobile == 2) {
                        if (!StringUtils.isNotBlank((CharSequence)customAppVo.getType()) || !customAppVo.getType().contains("2") || customAppVo.getAppState() != 1) continue;
                        customAppVo.setMobileUrl("/ejc-cfs-mobile/#/cfsDefine/" + customAppVo.getAppCode() + "/" + customAppVo.getAppCode() + "list");
                        if (customAppMap.get(customAppVo.getId()) != null) continue;
                        if (StringUtils.isEmpty((CharSequence)customAppVo.getAppIcon())) {
                            customAppVo.setAppIcon(this.baseHost + "portal/themes/default/images/default-appicon.png");
                        }
                        appList.add(customAppVo);
                        customAppMap.put(customAppVo.getId(), customAppVo);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)customAppVo.getType()) || !customAppVo.getType().contains("1") || customAppVo.getAppState() != 1) continue;
                    customAppVo.setPcUrl("/ejc-cfs-frontend/#/cfsDefine/" + customAppVo.getAppCode() + "/" + customAppVo.getAppCode());
                    if (customAppMap.get(customAppVo.getId()) != null) continue;
                    if (StringUtils.isEmpty((CharSequence)customAppVo.getAppIcon())) {
                        customAppVo.setAppIcon(this.baseHost + "portal/themes/default/images/default-appicon.png");
                    }
                    appList.add(customAppVo);
                    customAppMap.put(customAppVo.getId(), customAppVo);
                }
            }
        }
        if ((noAuthCustomApps = this.customAppService.queryAllNoAuthCustomApps(searchText)) != null && noAuthCustomApps.size() > 0) {
            for (CustomAppVO customAppVO : noAuthCustomApps) {
                if (mobile != null && mobile == 2 && !customAppMap.containsKey(customAppVO.getId()) && StringUtils.isNotBlank((CharSequence)customAppVO.getType()) && customAppVO.getType().contains("2") && customAppVO.getAppState() == 1) {
                    customAppVO.setMobileUrl("/ejc-cfs-mobile/#/cfsDefine/" + customAppVO.getAppCode() + "/" + customAppVO.getAppCode() + "list");
                    if (customAppMap.get(customAppVO.getId()) == null) {
                        if (StringUtils.isEmpty((CharSequence)customAppVO.getAppIcon())) {
                            customAppVO.setAppIcon(this.baseHost + "portal/themes/default/images/default-appicon.png");
                        }
                        appList.add(customAppVO);
                        customAppMap.put(customAppVO.getId(), customAppVO);
                    }
                }
                if (customAppMap.containsKey(customAppVO.getId()) || !StringUtils.isNotBlank((CharSequence)customAppVO.getType()) || !customAppVO.getType().contains("1") || customAppVO.getAppState() != 1) continue;
                customAppVO.setPcUrl("/ejc-cfs-frontend/#/cfsDefine/" + customAppVO.getAppCode() + "/" + customAppVO.getAppCode());
                if (customAppMap.get(customAppVO.getId()) != null) continue;
                if (StringUtils.isEmpty((CharSequence)customAppVO.getAppIcon())) {
                    customAppVO.setAppIcon(this.baseHost + "portal/themes/default/images/default-appicon.png");
                }
                appList.add(customAppVO);
                customAppMap.put(customAppVO.getId(), customAppVO);
            }
        }
        if (ListUtil.isNotEmpty(appList)) {
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("in", appList.stream().map(CustomAppVO::getAppGroupId).collect(Collectors.toList())));
            List list = this.appGroupService.queryList(param);
            for (CustomAppGroupEntity entity : list) {
                CustomAppVO menu = new CustomAppVO();
                menu.setId(entity.getId());
                menu.setName(entity.getName());
                result.add(menu);
                for (CustomAppVO appVO : appList) {
                    if (!Objects.equals(appVO.getAppGroupId(), entity.getId())) continue;
                    appVO.setAppPath(appVO.getPcUrl());
                    appVO.setIcon(appVO.getAppIcon());
                    appVO.setName(appVO.getAppName());
                    appVO.setOpenMode("_self");
                    appVO.setAppId(appVO.getId());
                    menu.getChildren().add(appVO);
                }
            }
        }
        return CommonResponse.success(result);
    }

    private List<Long> getUserRoleCache(Long userId) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        String key = CURRENTUSER_ROLE_KEY + userId + "-" + InvocationInfoProxy.getTenantid();
        Set roleIds = (Set)this.cacheManager.execute(jedis -> jedis.smembers(key));
        if (roleIds != null && !roleIds.isEmpty()) {
            for (String roleId : roleIds) {
                resultList.add(Long.parseLong(roleId));
            }
        }
        return resultList;
    }
}

