/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.cust.bean.BusinessFormdefEntity;
import com.ejianc.foundation.cust.service.IBusinessFormdefService;
import com.ejianc.foundation.cust.service.IBusinessObjectService;
import com.ejianc.foundation.cust.service.IFormTemplateService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/formDef/"})
public class BusinessFormDefController {
    @Autowired
    private IBusinessFormdefService businessFormdefService;
    @Autowired
    private IBusinessObjectService businessObjectService;
    @Autowired
    private IFormTemplateService formTemplateService;

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BusinessFormdefEntity>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap order = queryParam.getOrderMap();
        order.put("createTime", "desc");
        IPage pageData = this.businessFormdefService.queryPage(queryParam, false);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"save"})
    public CommonResponse<String> save(@RequestBody BusinessFormdefEntity businessFormdefEntity) {
        if (StringUtils.isBlank((CharSequence)businessFormdefEntity.getUniqueKey()) && this.businessFormdefService.getByKey(businessFormdefEntity.getUniqueKey()) != null) {
            throw new BusinessException("\u8868\u5355 KEY \u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8868\u5355 KEY \u7684\u503c");
        }
        this.businessFormdefService.saveFormDef(businessFormdefEntity);
        return CommonResponse.success();
    }

    @RequestMapping(value={"getObject"})
    public CommonResponse<JSONObject> getObject(HttpServletRequest request) {
        String id = request.getParameter("id");
        String key = request.getParameter("key");
        BusinessFormdefEntity formDef = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            formDef = (BusinessFormdefEntity)((Object)this.businessFormdefService.getById((Serializable)((Object)id)));
        } else if (StringUtils.isNotBlank((CharSequence)key)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"unique_key", (Object)key);
            formDef = (BusinessFormdefEntity)((Object)this.businessFormdefService.getOne((Wrapper)queryWrapper));
        }
        JSONObject json = formDef == null ? new JSONObject() : (JSONObject)JSON.toJSON((Object)((Object)formDef));
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"boTreeData"})
    public List<JSONObject> boTreeData(@RequestParam String boKey) {
        return this.businessObjectService.boTreeData(boKey);
    }

    @RequestMapping(value={"templateData"})
    public CommonResponse<JSONArray> templateData(@RequestParam String boKey, @RequestParam String type) {
        JSONArray array = this.formTemplateService.templateData(boKey, type);
        return CommonResponse.success((Object)array);
    }

    @RequestMapping(value={"createHtml"})
    public CommonResponse<String> createHtml(HttpServletRequest request, @RequestBody JSONArray jsonArray) {
        String boKey = request.getParameter("boKey");
        String formType = request.getParameter("formType");
        String html = this.businessFormdefService.generateFormHtml(boKey, jsonArray, formType);
        return CommonResponse.success((String)html);
    }

    @RequestMapping(value={"remove"})
    public CommonResponse<String> remove(@RequestParam String id) {
        this.businessFormdefService.removeBusinessFormdefById(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }
}

