/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.mapper.CustomTableMapper;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.util.BillStateEnum;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomTableServiceImpl
extends BaseServiceImpl<CustomTableMapper, CustomTableEntity>
implements ICustomTableService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ID = "id";
    private static final String DEL = "del";
    private static final String PID = "pid";
    private static final String ORG_ID = "orgId";
    private static final String CREATE_USER = "createUser";
    private static final String CREATE_TIME = "createTime";
    private static final String BILL_STATE = "billState";
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private CustomTableMapper customTableMapper;
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ICustomListService customListService;
    @Autowired
    private MongodbCrudTemplate mongoTemplate;
    @Autowired
    private ICustomTableService customTableService;

    @Override
    public void deleteCustomTable(Long mainFormId) {
        this.customTableMapper.deleteCustomTable(mainFormId);
    }

    @Override
    public CustomTableEntity queryMainTableByAppId(Long appId) {
        CustomTableEntity customTableEntity = this.customTableMapper.queryMainTableByAppId(appId);
        return customTableEntity;
    }

    @Override
    public List<CustomTableEntity> queryChildTablesByMainTableId(Long mainTableId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"parent_id", (Object)mainTableId);
        List childTableEntities = this.customTableMapper.selectList((Wrapper)queryWrapper);
        return childTableEntities;
    }

    @Override
    public CommonResponse<JSONObject> queryDetail(String pageCode, Long id) throws IOException {
        this.logger.info("\u67e5\u8be2\u5ba1\u6279\u8be6\u60c5\uff1apageCode-{},  id-{}", (Object)pageCode, (Object)id);
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.queryMainTableByAppId(app.getId());
        List<CustomColumnEntity> mainCols = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        JSONObject mainDetail = this.mongoTemplate.selectById(id.toString(), mainTableEntity.getTableName());
        if (mainDetail == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25:\u6570\u636e\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728\uff01");
        }
        for (CustomColumnEntity col : mainCols) {
            String[] stringArray;
            if ("refer".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)mainDetail.getString(col.getProperty())).getString("name"));
            }
            if ("select".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)mainDetail.getString(col.getProperty())).getString("text"));
            }
            if (!"integer".equals(col.getType()) || BILL_STATE.equals(col.getProperty())) continue;
            if (StringUtils.isNotEmpty((CharSequence)col.getVal())) {
                stringArray = col.getVal().split(",");
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "\u662f";
                stringArray = stringArray2;
                stringArray2[1] = "\u5426";
            }
            String[] names = stringArray;
            if ("1".equals(mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)names[0]);
                continue;
            }
            mainDetail.put(col.getProperty(), (Object)names[1]);
        }
        return CommonResponse.success((Object)mainDetail);
    }

    @Override
    public CommonResponse<JSONObject> queryPrintDetail(String pageCode, Long id) {
        this.logger.info("\u67e5\u8be2\u6253\u5370\u8be6\u60c5\uff1apageCode-{},  id-{}", (Object)pageCode, (Object)id);
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.queryMainTableByAppId(app.getId());
        List<CustomColumnEntity> mainCols = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        JSONObject mainDetail = this.mongoTemplate.selectById(id.toString(), mainTableEntity.getTableName());
        if (mainDetail == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25:\u6570\u636e\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728\uff01");
        }
        for (Object col : mainCols) {
            String[] stringArray;
            if ("refer".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)mainDetail.getString(col.getProperty())).getString("name"));
            }
            if ("select".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)mainDetail.getString(col.getProperty())).getString("text"));
            }
            if (BILL_STATE.equals(col.getProperty()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)BillStateEnum.getEnumByStateCode(mainDetail.getInteger(col.getProperty())).getDescription());
            }
            if (!"integer".equals(col.getType()) || BILL_STATE.equals(col.getProperty())) continue;
            if (StringUtils.isNotEmpty((CharSequence)col.getVal())) {
                stringArray = col.getVal().split(",");
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "\u662f";
                stringArray = stringArray2;
                stringArray2[1] = "\u5426";
            }
            String[] names = stringArray;
            if ("1".equals(mainDetail.getString(col.getProperty()))) {
                mainDetail.put(col.getProperty(), (Object)names[0]);
                continue;
            }
            mainDetail.put(col.getProperty(), (Object)names[1]);
        }
        List<CustomTableEntity> childTableEntities = this.customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
        if (ListUtil.isNotEmpty(childTableEntities)) {
            for (CustomTableEntity childTableEntity : childTableEntities) {
                List<CustomColumnEntity> childrenCols = this.customColumnService.queryColumnsByTableId(childTableEntity.getId());
                JSONArray array = mainDetail.getJSONArray(childTableEntity.getUiKey());
                if (array == null) continue;
                for (Object o : array) {
                    JSONObject rowData = (JSONObject)o;
                    for (CustomColumnEntity col : childrenCols) {
                        if (!StringUtils.isNotEmpty((CharSequence)col.getVal())) continue;
                        JSONObject childField = JSONObject.parseObject((String)col.getVal());
                        String uitype = childField.getString("uisubtype");
                        String value = rowData.getString(childField.getString("uikey"));
                        if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                        switch (uitype) {
                            case "date": 
                            case "number": 
                            case "currency": 
                            case "textarea": 
                            case "attachupload": {
                                break;
                            }
                            case "inputrefer": 
                            case "enumselect": {
                                value = JSONObject.parseObject((String)value).getString("name");
                                break;
                            }
                            case "switch": {
                                if ("1".equals(value) || "true".equals(value)) {
                                    value = "\u5f00";
                                    break;
                                }
                                value = "\u5173";
                                break;
                            }
                            case "select": {
                                value = JSONObject.parseObject((String)value).getString("text");
                                break;
                            }
                        }
                        rowData.put(childField.getString("uikey"), (Object)value);
                    }
                }
            }
        }
        CommonResponse approveList = this.bpmApi.queryHistoryById(id);
        mainDetail.put("ApproveInfo", approveList.getData());
        return CommonResponse.success((Object)mainDetail);
    }

    @Override
    @Transactional
    public void clearCustomTable(Long appId) {
        QueryWrapper childWrapper = new QueryWrapper();
        childWrapper.eq((Object)"app_id", (Object)appId);
        List childCustomTableEntities = this.list((Wrapper)childWrapper);
        if (childCustomTableEntities != null && childCustomTableEntities.size() > 0) {
            for (int i = 0; i < childCustomTableEntities.size(); ++i) {
                CustomTableEntity childCustomTableEntity = (CustomTableEntity)((Object)childCustomTableEntities.get(i));
                this.deleteCustomTable(childCustomTableEntity.getId());
                this.customColumnService.deleteCustomColumnByTableId(childCustomTableEntity.getId());
                try {
                    GetIndexRequest request = new GetIndexRequest(new String[]{childCustomTableEntity.getTableName()});
                    boolean exists = this.client.indices().exists(request, RequestOptions.DEFAULT);
                    if (!exists) continue;
                    DeleteIndexRequest childDeleteIndexRequest = new DeleteIndexRequest(childCustomTableEntity.getTableName());
                    try {
                        this.client.indices().delete(childDeleteIndexRequest, RequestOptions.DEFAULT);
                    }
                    catch (IOException ee) {
                        this.client.indices().delete(childDeleteIndexRequest, RequestOptions.DEFAULT);
                        this.logger.error("\u5220\u9664es\u5e93\u51fa\u9519\uff01" + ee.getMessage());
                    }
                    continue;
                }
                catch (IOException e) {
                    this.logger.error("\u5220\u9664es\u5e93\u51fa\u9519\uff01-- " + e.getMessage());
                }
            }
        }
        QueryWrapper lw = new QueryWrapper();
        lw.eq((Object)"app_id", (Object)appId);
        List listEntities = this.customListService.list((Wrapper)lw);
        if (ListUtil.isNotEmpty((List)listEntities)) {
            this.customListService.removeByIds(listEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
    }
}

