/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cust.bean.BusinessObjectEntity;
import com.ejianc.foundation.cust.bean.BusinessTableRel;
import com.ejianc.foundation.cust.bean.FormTemplateEntity;
import com.ejianc.foundation.cust.bean.FormType;
import com.ejianc.foundation.cust.constant.FormTemplateType;
import com.ejianc.foundation.cust.mapper.FormTemplateMapper;
import com.ejianc.foundation.cust.service.IBusinessObjectService;
import com.ejianc.foundation.cust.service.IFormTemplateService;
import com.ejianc.foundation.cust.util.BusTableRelType;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class FormTemplateServiceImpl
extends BaseServiceImpl<FormTemplateMapper, FormTemplateEntity>
implements IFormTemplateService {
    @Autowired
    private FormTemplateMapper formTemplateMapper;
    @Autowired
    private IBusinessObjectService businessObjectService;

    @Override
    public void init() {
        QueryWrapper queryWrapper = new QueryWrapper();
        List resultList = this.formTemplateMapper.selectList((Wrapper)queryWrapper);
        if (resultList.isEmpty()) {
            this.initTemplate();
        }
    }

    private void initTemplate() {
        try {
            String templatePath = "template/formDef/";
            ClassPathResource resource = new ClassPathResource(templatePath + "templates.xml");
            String xml = IOUtils.toString((InputStream)resource.getInputStream(), (String)"UTF-8");
            Document document = DocumentHelper.parseText((String)xml);
            Element root = document.getRootElement();
            List list = root.elements();
            for (Element element : list) {
                String key = element.attributeValue("key");
                String name = element.attributeValue("name");
                String type = element.attributeValue("type");
                String desc = element.attributeValue("desc");
                String dir = element.attributeValue("dir");
                String fileName = templatePath + dir + "/" + key + ".ftl";
                System.out.println(fileName);
                ClassPathResource fileResouce = new ClassPathResource(fileName);
                String html = IOUtils.toString((InputStream)fileResouce.getInputStream(), (String)"UTF-8");
                FormTemplateEntity formTemplate = new FormTemplateEntity();
                formTemplate.setId(IdWorker.getId());
                formTemplate.setHtml(html);
                formTemplate.setName(name);
                formTemplate.setUniqueKey(key);
                formTemplate.setEditable(0);
                formTemplate.setType(type);
                formTemplate.setFormType(dir);
                formTemplate.setDescription(desc);
                this.formTemplateMapper.insert((Object)formTemplate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<FormTemplateEntity> getByType(String type, String formType, Boolean hasDesignForm) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"type", (Object)type);
        queryWrapper.eq((Object)"form_type", (Object)formType);
        if (hasDesignForm.booleanValue()) {
            queryWrapper.eq((Object)"type", (Object)type.concat("FormOverallArrangement"));
        }
        List resultList = this.formTemplateMapper.selectList((Wrapper)queryWrapper);
        return resultList;
    }

    @Override
    public JSONArray templateData(String boKey, String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"unique_key", (Object)boKey);
        BusinessObjectEntity bo = (BusinessObjectEntity)((Object)this.businessObjectService.getOne((Wrapper)queryWrapper));
        if (bo == null) {
            throw new BusinessException(String.format("\u4e1a\u52a1\u5bf9\u8c61\u4e22\u5931\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5bf9\u8c61\uff1a%s", boKey));
        }
        boolean hasDesignForm = false;
        if (StringUtils.isNotEmpty((String)this.businessObjectService.getOverallArrangementByCode(boKey)) && !FormType.MOBILE.value().equals(type)) {
            hasDesignForm = true;
        }
        List<BusinessTableRel> rels = bo.getRelation().list();
        List<FormTemplateEntity> mainTemplates = this.getByType(FormTemplateType.MAIN.getKey(), type, hasDesignForm);
        List<FormTemplateEntity> subTableTemplates = this.getByType(FormTemplateType.SUB_TABLE.getKey(), type, hasDesignForm);
        for (FormTemplateEntity template : mainTemplates) {
            template.setHtml(null);
        }
        for (FormTemplateEntity template : subTableTemplates) {
            template.setHtml(null);
        }
        JSONArray jsonArray = new JSONArray();
        for (BusinessTableRel rel : rels) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tableKey", (Object)rel.getTableKey());
            jsonObject.put("tableComment", (Object)rel.getTableComment());
            jsonObject.put("typeDesc", (Object)BusTableRelType.getByKey(rel.getType()).getDesc());
            if (BusTableRelType.MAIN.equalsWithKey(rel.getType())) {
                jsonObject.put("templates", JSON.toJSON(mainTemplates));
            } else {
                jsonObject.put("templates", JSON.toJSON(subTableTemplates));
            }
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }
}

