package com.ejianc.business.chargingstationmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.chargingstationmanagement.bean.ChargingdetailsEntity;
/**
 * 充电站管理
 * 
 * @author generator
 * 
 */
 @TableName("ejc_chargingmanagement_chargingstation")
public class ChargingstationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="name")
    private String name; // 充电站名称
    @TableField(value="location")
    private BigDecimal location; // 位置
    @TableField(value="charging_total")
    private Double chargingTotal; // 充电总量
    @TableField(value="charging_duration")
    private Double chargingDuration; // 充电总时长
    @TableField(value="charging_time")
    private Integer chargingTime; // 充电累计次数
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="chargingdetailsService")//此处有pid="xxx"，默认值pid="pid"
    private List<ChargingdetailsEntity> chargingdetailsList = new ArrayList<>(); // 充电站明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public BigDecimal getLocation() {
        return location;
    }

    public void setLocation(BigDecimal location) {
        this.location = location;
    }
    public Double getChargingTotal() {
        return chargingTotal;
    }

    public void setChargingTotal(Double chargingTotal) {
        this.chargingTotal = chargingTotal;
    }
    public Double getChargingDuration() {
        return chargingDuration;
    }

    public void setChargingDuration(Double chargingDuration) {
        this.chargingDuration = chargingDuration;
    }
    public Integer getChargingTime() {
        return chargingTime;
    }

    public void setChargingTime(Integer chargingTime) {
        this.chargingTime = chargingTime;
    }
    
    public List<ChargingdetailsEntity> getChargingdetailsList() {
        return chargingdetailsList;
    }

    public void setChargingdetailsList(List<ChargingdetailsEntity> chargingdetailsList) {
        this.chargingdetailsList = chargingdetailsList;
    }
}
