package com.ejianc.business.chargingstationmanagement.controller.api;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.charging.vo.ChargingdetailVO;
import com.ejianc.business.charging.vo.ChargingstationVO;
import com.ejianc.business.chargingstationmanagement.bean.ChargingdetailsEntity;
import com.ejianc.business.chargingstationmanagement.bean.CharginginfoEntity;
import com.ejianc.business.chargingstationmanagement.bean.ChargingstationEntity;
import com.ejianc.business.chargingstationmanagement.service.IChargingdetailsService;
import com.ejianc.business.chargingstationmanagement.service.ICharginginfoService;
import com.ejianc.business.chargingstationmanagement.service.IChargingstationService;
import com.ejianc.business.chargingstationmanagement.utils.AESUtils;
import com.ejianc.business.chargingstationmanagement.utils.HttpRequestUtils;
import com.ejianc.business.chargingstationmanagement.utils.MyUtils;
import com.ejianc.business.chargingstationmanagement.vo.ChargingdetailsVO;
import com.ejianc.business.chargingstationmanagement.vo.CharginginfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

//import com.alibaba.fastjson.JSONObject;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/8/5
 * @description:充电桩管理相关查询接口
 */
@Controller
@RequestMapping("/no_auth/api/base/chargingstationApi")
public class ChargingstationApi {

    @Autowired
    private IChargingstationService service;
    @Autowired
    private ICharginginfoService inservice;
    @Autowired
    private IChargingdetailsService chargingdetailsService;

    @Autowired
    private ICharginginfoService charginginfoService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 查询所有充电桩信息
     *
     * @return
     */
    @GetMapping(value = "/querychargingstation")
    @ResponseBody
    public CommonResponse<List<ChargingstationVO>> queryList() {
        List<ChargingstationEntity> list = service.list();
        List<ChargingstationVO> chargingstationVOS = BeanMapper.mapList(list, ChargingstationVO.class);
        return CommonResponse.success("查询充电成功", chargingstationVOS);
    }

    /**
     * 查询主表id下的所有充电桩信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/querychargingdetail")
    @ResponseBody
    public CommonResponse<List<ChargingdetailVO>> queryListDetail(Long id) {
        QueryWrapper<ChargingdetailsEntity> query = new QueryWrapper<>();
        query.eq("mid", id);
        List<ChargingdetailsEntity> list = chargingdetailsService.list(query);
        List<ChargingdetailVO> chargingdetailsVOS = BeanMapper.mapList(list, ChargingdetailVO.class);
        return CommonResponse.success("查询充电桩信息成功", chargingdetailsVOS);
    }

    /**
     * 查询所有订单信息推送
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/notifyChargeOrder", method = RequestMethod.POST)
    public CommonResponse notifyChargeOrder(HttpServletRequest request) throws Exception {
        //request调用解析
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject(MyUtils.getRequestPostStr(request));
        logger.info("------>"+jsonObject);
        JSON json1 = JSONUtil.parse(jsonObject);
        String data = json1.getByPath("data").toString();
        String responseData = AESUtils.Decrypt(data);
        if(!responseData.equals("null")){
                JSONObject jsonObject1 = new JSONObject(responseData);

            Map<String, Object> map1 = (Map<String, Object>) jsonObject1;
            System.out.println("map1 = " + map1);
            CharginginfoVO charginginfoVO = new CharginginfoVO();
            charginginfoVO.setPileNo(map1.get("pileNo").toString());
            charginginfoVO.setPileName(map1.get("pileName").toString());
            charginginfoVO.setStationNo(map1.get("stationNo").toString());
            charginginfoVO.setStationName(map1.get("stationName").toString());
            charginginfoVO.setOrderNo(map1.get("orderNo").toString());
            charginginfoVO.setChargeCardNo(map1.get("chargeCardNo").toString());
            charginginfoVO.setChargeUserName(map1.get("chargeUserName").toString());
            charginginfoVO.setPileState(Integer.valueOf(map1.get("pileState").toString()));
            charginginfoVO.setPayStatus(Integer.valueOf(map1.get("payStatus").toString()));
            charginginfoVO.setPlateNo(map1.get("plateNo").toString());
            charginginfoVO.setElecMeterBegin(new BigDecimal(map1.get("elecMeterBegin").toString()));
            charginginfoVO.setElecMeterEnd(new BigDecimal(map1.get("elecMeterEnd").toString()));
            charginginfoVO.setChargeStartTime(map1.get("chargeStartTime").toString());
            charginginfoVO.setChargeEndTime(map1.get("chargeEndTime").toString());
            charginginfoVO.setSharpChargeStandard(new BigDecimal(map1.get("sharpChargeStandard").toString()));
            charginginfoVO.setPeakChargeStandard(new BigDecimal(map1.get("peakChargeStandard").toString()));
            charginginfoVO.setFlatChargeStandard(new BigDecimal(map1.get("flatChargeStandard").toString()));
            charginginfoVO.setValleyChargeStandard(new BigDecimal(map1.get("valleyChargeStandard").toString()));
            charginginfoVO.setSharpServiceStandard(new BigDecimal(map1.get("sharpServiceStandard").toString()));
            charginginfoVO.setPeakServiceStandard(new BigDecimal(map1.get("peakServiceStandard").toString()));
            charginginfoVO.setFlatServiceStandard(new BigDecimal(map1.get("flatServiceStandard").toString()));
            charginginfoVO.setValleyServiceStandard(new BigDecimal(map1.get("valleyServiceStandard").toString()));
            charginginfoVO.setChargePower(new BigDecimal(map1.get("chargePower").toString()));
            charginginfoVO.setSharpChargePower(new BigDecimal(map1.get("sharpChargePower").toString()));
            charginginfoVO.setPeakChargePower(new BigDecimal(map1.get("peakChargePower").toString()));
            charginginfoVO.setFlatChargePower(new BigDecimal(map1.get("flatChargePower").toString()));
            charginginfoVO.setValleyPower(new BigDecimal(map1.get("valleyPower").toString()));
            charginginfoVO.setChargeFee(new BigDecimal(map1.get("chargeFee").toString()));
            charginginfoVO.setServiceFee(new BigDecimal(map1.get("serviceFee").toString()));
            charginginfoVO.setTotalFee(new BigDecimal(map1.get("totalFee").toString()));
            charginginfoVO.setChargeDuration(Integer.valueOf(map1.get("chargeDuration").toString()));
            charginginfoVO.setPaymentTime(map1.get("paymentTime").toString());
            charginginfoVO.setChargeStopReason(map1.get("chargeStopReason").toString());
            CharginginfoEntity entity = BeanMapper.map(charginginfoVO, CharginginfoEntity.class);
            if (entity.getId() == null || entity.getId() == 0) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), charginginfoVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            inservice.save(entity);

        }
        logger.info("拦截器-> " + responseData);
        return CommonResponse.success("保存充电桩订单信息成功！");
    }
//
//    /**
//     * 查询充电桩状态推送
//     *
//     * @Return state
//     */
//    @PostMapping(value = "/notifyPileStatus")
//    @ResponseBody
//    public CommonResponse<String> notifyPileStatus(@RequestBody ChargingdetailVO chargingdetailsVO
//    ) {
//        QueryWrapper<ChargingdetailsEntity> queryWrapper = new QueryWrapper<ChargingdetailsEntity>();
//
//        queryWrapper.eq("pile_no", chargingdetailsVO.getPileNo());
//        ChargingdetailsEntity clist = chargingdetailsService.getOne(queryWrapper);
//        if (clist != null) {
//            clist.setPileStatus(chargingdetailsVO.getPileStatus());
//            clist.setSamplingTime(chargingdetailsVO.getSamplingTime());
//            chargingdetailsService.updateById(clist);
//        } else {
//            return CommonResponse.success("当前充电桩没有信息!");
//        }
//        return CommonResponse.success("修改成功!");
//    }

    /**
     * 查询充电桩状态信息
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/notifyPileStatus", method = RequestMethod.POST)
    public CommonResponse notifyPileStatus(HttpServletRequest request) throws Exception {
        //request调用解析
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject(MyUtils.getRequestPostStr(request));
        logger.info("------>"+jsonObject);
        JSON json1 = JSONUtil.parse(jsonObject);
        String data = json1.getByPath("data").toString();
        String responseData = AESUtils.Decrypt(data);
        if(!responseData.equals("null")){
            JSONObject jsonObject1 = new JSONObject(responseData);

            Map<String, Object> map1 = (Map<String, Object>) jsonObject1;
            System.out.println("map1 = " + map1);
            ChargingdetailsVO chargingdetailsVO = new ChargingdetailsVO();
            chargingdetailsVO.setPileNo(map1.get("pileNo").toString());
            chargingdetailsVO.setPileStatus(Integer.valueOf(map1.get("pileStatus").toString()));
            chargingdetailsVO.setSamplingTime(map1.get("samplingTime").toString());
            ChargingdetailsEntity entity = BeanMapper.map(chargingdetailsVO, ChargingdetailsEntity.class);
            if (entity.getId() == null || entity.getId() == 0) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), chargingdetailsVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            chargingdetailsService.save(entity);

        }
        logger.info("拦截器-> " + responseData);
        return CommonResponse.success("保存充电桩订单信息成功！");
    }
    /**
     * 查询所有充电站信息
     * 同步数据
     */
    @GetMapping(value = "/queryStationInfo")
    public CommonResponse<String> queryStationInfo() {
        List<ChargingstationVO> chargingstationVOS = new ArrayList<>();
        String url = "https://jqcs.pjnes.com/cloud/datashare/api/queryStationInfo";
        //String url="https://jqcs.pjnes.com/cloud/datashare/api/queryPileInfo";
        JSON json2 = new JSONObject();
        json2.putByPath("pageNo", "1");
        json2.putByPath("pageSize", "10");
        String responseData = HttpRequestUtils.postRequest(url,json2);
        if (!responseData.equals("null")) {
            JSONObject jsonObject = new JSONObject(responseData);
            JSONArray jsonArray = new JSONArray(jsonObject.get("stationInfoArray"));
            for (Object object : jsonArray) {
                Map<String, Object> map1 = (Map<String, Object>) object;
                System.out.println("map1 = " + map1);
                QueryWrapper<ChargingstationEntity> queryWrapper = new QueryWrapper<ChargingstationEntity>();
                queryWrapper.eq("station_no", map1.get("stationNo").toString());
                ChargingstationEntity stationNot = service.getOne(queryWrapper);
                if (stationNot == null) {
                    ChargingstationVO chargingstationVO = new ChargingstationVO();
                    chargingstationVO.setStationNo(map1.get("stationNo").toString());
                    chargingstationVO.setStationName(map1.get("stationName").toString());
                    chargingstationVO.setStationType(Integer.valueOf(map1.get("stationType").toString()));
                    chargingstationVO.setStationLong(new BigDecimal(map1.get("stationLong").toString()));
                    chargingstationVO.setStationLat(new BigDecimal(map1.get("stationLat").toString()));
                    chargingstationVO.setAddress(map1.get("address").toString());
                    chargingstationVO.setIndustry(map1.get("industry").toString());
                    chargingstationVO.setBusiState(Integer.valueOf(map1.get("busiState").toString()));
                    if (!map1.get("ratedPower").toString().equals("null")) {
                        chargingstationVO.setRatedPower(new BigDecimal(map1.get("ratedPower").toString()));
                    }
                    chargingstationVO.setFastChargecount(Integer.valueOf(map1.get("fastChargeCount").toString()));
                    chargingstationVO.setSlowChargecount(Integer.valueOf(map1.get("slowChargeCount").toString()));
                    chargingstationVO.setServerTel(map1.get("serverTel").toString());
                    ChargingstationEntity entity = BeanMapper.map(chargingstationVO, ChargingstationEntity.class);
                    if (entity.getId() == null || entity.getId() == 0) {
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), chargingstationVO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if (billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                        } else {
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                    }
                    service.save(entity);
                } else {
                    ChargingstationVO chargingstationVO = new ChargingstationVO();

                    chargingstationVO.setStationNo(map1.get("stationNo").toString());
                    chargingstationVO.setStationName(map1.get("stationName").toString());
                    chargingstationVO.setStationType(Integer.valueOf(map1.get("stationType").toString()));

                    chargingstationVO.setStationLong(new BigDecimal(map1.get("stationLong").toString()));
//                    BigDecimal bigDecimal = new BigDecimal("0.00");
//                    Double result = bigDecimal.doubleValue();
                    chargingstationVO.setStationLat(new BigDecimal(map1.get("stationLat").toString()));
                    chargingstationVO.setAddress(map1.get("address").toString());
                    chargingstationVO.setIndustry(map1.get("industry").toString());
                    chargingstationVO.setBusiState(Integer.valueOf(map1.get("busiState").toString()));
                    if (!map1.get("ratedPower").toString().equals("null")) {
                        chargingstationVO.setRatedPower(new BigDecimal(map1.get("ratedPower").toString()));
                    }
                    chargingstationVO.setFastChargecount(Integer.valueOf(map1.get("fastChargeCount").toString()));
                    chargingstationVO.setSlowChargecount(Integer.valueOf(map1.get("slowChargeCount").toString()));
                    chargingstationVO.setServerTel(map1.get("serverTel").toString());
                    ChargingstationEntity entity = BeanMapper.map(chargingstationVO, ChargingstationEntity.class);
                    service.updateById(entity);
                }
            }
        }
        return CommonResponse.success("同步成功");
    }

    /**
     * 查询充电桩信息
     * @return
     * @throws Exception
     */
    @GetMapping(value = "/queryPileInfo")
    public CommonResponse<String> queryPileInfo(){
//        List<ChargingdetailsVO> chargingdetailsVOS = new ArrayList<>();
        String url = "https://jqcs.pjnes.com/cloud/datashare/api/queryPileInfo";
        JSON json2 = new JSONObject();
        json2.putByPath("pageNo", "1");
        json2.putByPath("pageSize", "10");
        String responseData = HttpRequestUtils.postRequest(url,json2);
        if (!responseData.equals("null")) {
            JSONObject jsonObject = new JSONObject(responseData);
            JSONArray jsonArray = new JSONArray(jsonObject.get("pileInfoArray"));
            for (Object object : jsonArray) {
                Map<String, Object> map1 = (Map<String, Object>) object;
                System.out.println("map1 = " + map1);
                QueryWrapper<ChargingdetailsEntity> queryWrapper1 = new QueryWrapper<>();
                queryWrapper1.eq("pile_no", map1.get("pileNo").toString());
                ChargingdetailsEntity pileNolist = chargingdetailsService.getOne(queryWrapper1);
                if (pileNolist == null) {
                    ChargingdetailsVO chargingdetailsVO = new ChargingdetailsVO();
                    chargingdetailsVO.setPileNo(map1.get("pileNo").toString());
                    chargingdetailsVO.setPileName(map1.get("pileName").toString());
                    chargingdetailsVO.setStationNo(map1.get("stationNo").toString());
                    chargingdetailsVO.setStationName(map1.get("stationName").toString());
                    chargingdetailsVO.setPileModel(map1.get("pileModel").toString());
                    chargingdetailsVO.setPilePower(map1.get("pilePower").toString());
                    chargingdetailsVO.setChargeMode(Integer.valueOf(map1.get("chargeMode").toString()));
                    chargingdetailsVO.setChargeType(Integer.valueOf(map1.get("chargeType").toString()));
                    ChargingdetailsEntity entity = BeanMapper.map(chargingdetailsVO, ChargingdetailsEntity.class);
                    if (entity.getId() == null || entity.getId() == 0) {
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), chargingdetailsVO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if (billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                        } else {
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                    }
                    chargingdetailsService.save(entity);
                } else {
                    ChargingdetailsVO chargingdetailsVO = new ChargingdetailsVO();
                    chargingdetailsVO.setPileNo(map1.get("pileNo").toString());
                    chargingdetailsVO.setPileName(map1.get("pileName").toString());
                    chargingdetailsVO.setStationNo(map1.get("stationNo").toString());
                    chargingdetailsVO.setStationName(map1.get("stationName").toString());
                    chargingdetailsVO.setPileModel(map1.get("pileModel").toString());
                    chargingdetailsVO.setPilePower(map1.get("pilePower").toString());
                    chargingdetailsVO.setChargeMode(Integer.valueOf(map1.get("chargeMode").toString()));
                    chargingdetailsVO.setChargeType(Integer.valueOf(map1.get("chargeType").toString()));
                    ChargingdetailsEntity entity = BeanMapper.map(chargingdetailsVO, ChargingdetailsEntity.class);
                    chargingdetailsService.updateById(entity);
                }
            }
        }
        return CommonResponse.success("同步成功");
    }
}