package com.ejianc.business.chargingstationmanagement.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;

import java.util.Date;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/8/1
 * @description:
 */
public class HttpRequestUtils {
    private static String baseUrl="https://jqcs.pjnes.com/cloud/datashare/api";

    /**
     * 充电桩接口请求通用方法
     * @param url 接口请求路径
     * @param json 接口请求Json参数
     * @return 响应结果数据data
     */
    public static String postRequest(String url, JSON json){
        //加密请求参数
        String encrypt = null;
        try {
            encrypt = AESUtils.Encrypt(json.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        //组合请求需要传的Json参数
        JSON bodyJson = new JSONObject();
        bodyJson.putByPath("operatorId","zhongdong");
        bodyJson.putByPath("requestTime",System.currentTimeMillis());
        bodyJson.putByPath("data",encrypt);
        //获取发送请求的响应结果
        String requestJsonStr = HttpRequest.post(url).disableCookie().body(bodyJson).execute().body().toString();
        JSON parse = JSONUtil.parse(requestJsonStr);
        String data = parse.getByPath("data").toString();
        String responseData = null;
        try {
            responseData = AESUtils.Decrypt(data);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return responseData;
    }
}
