package com.ejianc.business.chargingstationmanagement.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 充电站明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_chargingmanagement_chargingdetails")
public class ChargingdetailsEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="mid")
    private Long mid; // 主表id
    @TableField(value="pile_no")
    private String pileNo; // 充电桩编号

    public String getPileName() {
        return pileName;
    }

    public void setPileName(String pileName) {
        this.pileName = pileName;
    }

    @TableField(value="pile_name")
    private String pileName; // 充电桩名称
    @TableField(value="station_no")
    private String stationNo; // 所属充电站编号
    @TableField(value="station_name")
    private String stationName; // 所属充电站名称
    @TableField(value="pile_model")
    private String pileModel; // 充电桩型号
    @TableField(value="charge_mode")
    private Integer chargeMode; // 充电模式（1：自动；2：手动）
    @TableField(value="pile_power")
    private String pilePower; // 实际功率

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    @TableField(value="charge_type")
    private Integer chargeType; // 充电方式（1：直流；2：交流）
    @TableField(value="pile_status")
    private Integer pileStatus; // 充电桩状态（0：离线；1：故障；2：空闲；3：充电中；4：已插枪；5：忙碌）
    @TableField(value="sampling_time")
    private String samplingTime; //  采样时间（yyyyMMddHHmmss 格式）
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }
    public String getPileNo() {
        return pileNo;
    }

    public void setPileNo(String pileNo) {
        this.pileNo = pileNo;
    }

    public String getStationNo() {
        return stationNo;
    }

    public void setStationNo(String stationNo) {
        this.stationNo = stationNo;
    }
    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }
    public String getPileModel() {
        return pileModel;
    }

    public void setPileModel(String pileModel) {
        this.pileModel = pileModel;
    }
    public Integer getChargeMode() {
        return chargeMode;
    }

    public void setChargeMode(Integer chargeMode) {
        this.chargeMode = chargeMode;
    }
    public String getPilePower() {
        return pilePower;
    }

    public void setPilePower(String pilePower) {
        this.pilePower = pilePower;
    }

    public Integer getPileStatus() {
        return pileStatus;
    }

    public void setPileStatus(Integer pileStatus) {
        this.pileStatus = pileStatus;
    }
    public String getSamplingTime() {
        return samplingTime;
    }

    public void setSamplingTime(String samplingTime) {
        this.samplingTime = samplingTime;
    }
    
}
