package com.ejianc.business.chargingstationmanagement.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 充电详细信息
 * 
 * @author generator
 * 
 */
public class CharginginfoVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String pileNo; // 充电桩编号
    private String pileName; // 充电桩名称
    private String stationNo; // 所属充电站编号
    private String stationName; // 所属充电站名称
    private String orderNo; // 订单编号
    private Integer pileState; // 桩体使用状态（1：已启动；2：充电中；3：已完成）
    private String chargeUserName; // 充电用户名称
    private String chargeCardNo; // 充电卡号
    private Integer payStatus; // 支付状态（0：未支付；1：已支付）
    private String plateNo; // 车牌号

    private BigDecimal elecMeterBegin; // 电表起始示数
    private BigDecimal elecMeterEnd; // 电表结束示数
    private String chargeStartTime; // 充电开始时间（yyyyMMddHHmmss 格式)
    private String chargeEndTime; // 充电结束时间（yyyyMMddHHmmss 格式）
    private BigDecimal sharpChargeStandard; // 尖电费标准（元)
    private BigDecimal peakChargeStandard; // 峰电费标准（元）
    private BigDecimal flatChargeStandard; // 平电费标准（元）
    private BigDecimal valleyChargeStandard; // 谷电费标准（元）
    private BigDecimal sharpServiceStandard; // 尖服务费标准（元）
    private BigDecimal peakServiceStandard; // 峰服务费标准（元）
    private BigDecimal flatServiceStandard; //  平服务费标准（元）
    private BigDecimal valleyServiceStandard; //  谷服务费标准（元）
    private BigDecimal chargePower; // 充电电量（度）
    private BigDecimal sharpChargePower; // 尖电量（度）
    private BigDecimal peakChargePower; // 峰电量（度）
    private BigDecimal flatChargePower; // 平电量（度）
    private BigDecimal valleyPower; // 谷电量（度）
    private BigDecimal chargeFee; // 充电电费(元)
    private BigDecimal serviceFee; // 充电服务费(元)
    private BigDecimal totalFee; // 充电总费用(元)
    private Integer chargeDuration; // 充电时长（分钟）
    private String paymentTime; // 支付时间（yyyyMMddHHmmss 格式）
    private String chargeStopReason; // 结束充电原因

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getPileNo() {
        return pileNo;
    }

    public void setPileNo(String pileNo) {
        this.pileNo = pileNo;
    }

    public String getPileName() {
        return pileName;
    }

    public void setPileName(String pileName) {
        this.pileName = pileName;
    }

    public String getStationNo() {
        return stationNo;
    }

    public void setStationNo(String stationNo) {
        this.stationNo = stationNo;
    }

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Integer getPileState() {
        return pileState;
    }

    public void setPileState(Integer pileState) {
        this.pileState = pileState;
    }

    public String getChargeUserName() {
        return chargeUserName;
    }

    public void setChargeUserName(String chargeUserName) {
        this.chargeUserName = chargeUserName;
    }

    public String getChargeCardNo() {
        return chargeCardNo;
    }

    public void setChargeCardNo(String chargeCardNo) {
        this.chargeCardNo = chargeCardNo;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public String getPlateNo() {
        return plateNo;
    }

    public void setPlateNo(String plateNo) {
        this.plateNo = plateNo;
    }

    public BigDecimal getElecMeterBegin() {
        return elecMeterBegin;
    }

    public void setElecMeterBegin(BigDecimal elecMeterBegin) {
        this.elecMeterBegin = elecMeterBegin;
    }

    public BigDecimal getElecMeterEnd() {
        return elecMeterEnd;
    }

    public void setElecMeterEnd(BigDecimal elecMeterEnd) {
        this.elecMeterEnd = elecMeterEnd;
    }

    public String getChargeStartTime() {
        return chargeStartTime;
    }

    public void setChargeStartTime(String chargeStartTime) {
        this.chargeStartTime = chargeStartTime;
    }

    public String getChargeEndTime() {
        return chargeEndTime;
    }

    public void setChargeEndTime(String chargeEndTime) {
        this.chargeEndTime = chargeEndTime;
    }

    public BigDecimal getSharpChargeStandard() {
        return sharpChargeStandard;
    }

    public void setSharpChargeStandard(BigDecimal sharpChargeStandard) {
        this.sharpChargeStandard = sharpChargeStandard;
    }

    public BigDecimal getPeakChargeStandard() {
        return peakChargeStandard;
    }

    public void setPeakChargeStandard(BigDecimal peakChargeStandard) {
        this.peakChargeStandard = peakChargeStandard;
    }

    public BigDecimal getFlatChargeStandard() {
        return flatChargeStandard;
    }

    public void setFlatChargeStandard(BigDecimal flatChargeStandard) {
        this.flatChargeStandard = flatChargeStandard;
    }

    public BigDecimal getValleyChargeStandard() {
        return valleyChargeStandard;
    }

    public void setValleyChargeStandard(BigDecimal valleyChargeStandard) {
        this.valleyChargeStandard = valleyChargeStandard;
    }

    public BigDecimal getSharpServiceStandard() {
        return sharpServiceStandard;
    }

    public void setSharpServiceStandard(BigDecimal sharpServiceStandard) {
        this.sharpServiceStandard = sharpServiceStandard;
    }

    public BigDecimal getPeakServiceStandard() {
        return peakServiceStandard;
    }

    public void setPeakServiceStandard(BigDecimal peakServiceStandard) {
        this.peakServiceStandard = peakServiceStandard;
    }

    public BigDecimal getFlatServiceStandard() {
        return flatServiceStandard;
    }

    public void setFlatServiceStandard(BigDecimal flatServiceStandard) {
        this.flatServiceStandard = flatServiceStandard;
    }

    public BigDecimal getValleyServiceStandard() {
        return valleyServiceStandard;
    }

    public void setValleyServiceStandard(BigDecimal valleyServiceStandard) {
        this.valleyServiceStandard = valleyServiceStandard;
    }

    public BigDecimal getChargePower() {
        return chargePower;
    }

    public void setChargePower(BigDecimal chargePower) {
        this.chargePower = chargePower;
    }

    public BigDecimal getSharpChargePower() {
        return sharpChargePower;
    }

    public void setSharpChargePower(BigDecimal sharpChargePower) {
        this.sharpChargePower = sharpChargePower;
    }

    public BigDecimal getPeakChargePower() {
        return peakChargePower;
    }

    public void setPeakChargePower(BigDecimal peakChargePower) {
        this.peakChargePower = peakChargePower;
    }

    public BigDecimal getFlatChargePower() {
        return flatChargePower;
    }

    public void setFlatChargePower(BigDecimal flatChargePower) {
        this.flatChargePower = flatChargePower;
    }

    public BigDecimal getValleyPower() {
        return valleyPower;
    }

    public void setValleyPower(BigDecimal valleyPower) {
        this.valleyPower = valleyPower;
    }

    public BigDecimal getChargeFee() {
        return chargeFee;
    }

    public void setChargeFee(BigDecimal chargeFee) {
        this.chargeFee = chargeFee;
    }

    public BigDecimal getServiceFee() {
        return serviceFee;
    }

    public void setServiceFee(BigDecimal serviceFee) {
        this.serviceFee = serviceFee;
    }

    public BigDecimal getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(BigDecimal totalFee) {
        this.totalFee = totalFee;
    }

    public Integer getChargeDuration() {
        return chargeDuration;
    }

    public void setChargeDuration(Integer chargeDuration) {
        this.chargeDuration = chargeDuration;
    }

    public String getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(String paymentTime) {
        this.paymentTime = paymentTime;
    }

    public String getChargeStopReason() {
        return chargeStopReason;
    }

    public void setChargeStopReason(String chargeStopReason) {
        this.chargeStopReason = chargeStopReason;
    }
}
