package com.ejianc.business.chargingstationmanagement.vo;

import com.ejianc.business.charging.vo.ChargingdetailVO;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 充电站管理
 * 
 * @author generator
 * 
 */
public class ChargingstationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String name; // 充电站名称
    private String stationNo; // 充电站编号

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    private String stationName; // 充电站编号
    private BigDecimal stationLong; // 充电站坐标位置经度（GCJ-02 坐标系）
    private BigDecimal stationLat; // 充电站坐标位置纬度（GCJ-02 坐标系）
    private String address; // 详细地址
    private Integer busiState; // 运营状态（1：初始；2：待运营；3：运营中；4：暂停营业；5：关闭；6：未运营）
    private Integer fastChargecount; // 快充桩数量
    private Integer slowChargecount; // 慢充桩数量
    private String serverTel; // 服务电话

    public void setRatedPower(BigDecimal ratedPower) {
        this.ratedPower = ratedPower;
    }

    private BigDecimal ratedPower;
    private Integer stationType;
    private String industry;


    public Integer getStationType() {
        return stationType;
    }

    public void setStationType(Integer stationType) {
        this.stationType = stationType;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    private List<ChargingdetailVO> chargingdetailsEntities = new ArrayList<>(); // 充电站明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getStationNo() {
        return stationNo;
    }

    public void setStationNo(String stationNo) {
        this.stationNo = stationNo;
    }
    public BigDecimal getStationLong() {
        return stationLong;
    }

    public void setStationLong(BigDecimal stationLong) {
        this.stationLong = stationLong;
    }
    public BigDecimal getStationLat() {
        return stationLat;
    }

    public void setStationLat(BigDecimal stationLat) {
        this.stationLat = stationLat;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Integer getBusiState() {
        return busiState;
    }

    public void setBusiState(Integer busiState) {
        this.busiState = busiState;
    }
    public Integer getFastChargecount() {
        return fastChargecount;
    }

    public void setFastChargecount(Integer fastChargecount) {
        this.fastChargecount = fastChargecount;
    }
    public Integer getSlowChargecount() {
        return slowChargecount;
    }

    public void setSlowChargecount(Integer slowChargecount) {
        this.slowChargecount = slowChargecount;
    }
    public String getServerTel() {
        return serverTel;
    }

    public void setServerTel(String serverTel) {
        this.serverTel = serverTel;
    }

    public List<ChargingdetailVO> getChargingdetailsEntities() {
        return chargingdetailsEntities;
    }

    public void setChargingdetailsEntities(List<ChargingdetailVO> chargingdetailsEntities) {
        this.chargingdetailsEntities = chargingdetailsEntities;
    }
}
