/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.api;

import com.ejianc.business.contractbase.hystrix.TemplateHystrix;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.business.contractbase.vo.TemplateVersionVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="ejc-contractbase-web", url="${common.env.feign-client-url}", path="ejc-contractbase-web", fallback=TemplateHystrix.class)
public interface ITemplateApi {
    @GetMapping(value={"/api/template/queryDetailById"})
    public CommonResponse<TemplateVO> queryDetailById(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/api/template/getByCategoryId"})
    public CommonResponse<TemplateVO> getByCategoryId(@RequestParam(value="categoryId") Long var1);

    @GetMapping(value={"/api/template/getHisListByTemplateId"})
    public CommonResponse<List<TemplateVersionVO>> getHisListByTemplateId(@RequestParam String var1, @RequestParam int var2, @RequestParam int var3);

    @GetMapping(value={"/api/template/getTemplateVersionInfo"})
    public CommonResponse<TemplateVersionVO> getTemplateVersionInfo(@RequestParam(value="templateId") Long var1, @RequestParam(value="version", required=false) Long var2);

    @PostMapping(value={"/api/template/createNewTmplVersion"})
    public CommonResponse<TemplateVersionVO> createNewTmplVersion(@RequestBody TemplateVersionVO var1);
}

