package com.ejianc.business.contractbase.filing.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum FilingStatusEnum {
    未归档(0,"未归档"),
    已归档(1,"已归档"),
    归档中 (2,"归档中");

    FilingStatusEnum(Integer typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    private Integer typeCode;
    private String typeName;
    private static Map<Integer, FilingStatusEnum> enumMap = new HashMap<>();

    public Integer getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(Integer typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    static {
        enumMap = EnumSet.allOf(FilingStatusEnum.class).stream().collect(Collectors.toMap(FilingStatusEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    public static FilingStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
