package com.ejianc.business.contractbase.pool.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2022/3/29 10:31
 */
public enum UpdateLevelEnum {

    全量覆盖更新("OVERRIDE_ALL", "全量覆盖更新"),
    更新非NULL字段("NOT_NULL", "更新非NULL字段"),
    更新非空字段("NOT_EMPTY", "更新非空字段");

    UpdateLevelEnum(String levelCode, String levelName) {
        this.levelCode = levelCode;
        this.levelName = levelName;
    }

    private String levelCode;
    private String levelName;
    private static Map<String, UpdateLevelEnum> enumMap = new HashMap<>();

    public String getLevelCode() {
        return levelCode;
    }

    public void setLevelCode(String levelCode) {
        this.levelCode = levelCode;
    }

    public String getLevelName() {
        return levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    static {
        enumMap = EnumSet.allOf(UpdateLevelEnum.class).stream().collect(Collectors.toMap(UpdateLevelEnum::getLevelCode, Function.identity(), (k1, k2) -> k2));
    }

    public static UpdateLevelEnum getByCode(String levelCode) {
        return enumMap.get(levelCode);
    }
}
