package com.ejianc.business.contractbase.api;


import com.ejianc.business.contractbase.hystrix.ParamCheckHystrix;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

@FeignClient(name = "ejc-contractbase-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-contractbase-web", fallback = ParamCheckHystrix.class)
public interface IParamCheckApi {

//    @GetMapping("/api/paramCheck/contratCheck")
//    CommonResponse<ParamsCheckVO> paramsCheck(
//            @RequestParam("projectId") Long projectId,
//            @RequestParam(value = "contractId",required = false)Long contractId,
//            @RequestParam("contractTaxMny") BigDecimal contractTaxMny
//    );

    @GetMapping("/api/paramCheck/contratCheck")
    CommonResponse<List<ParamsCheckVO>> paramsCheck(
            @RequestParam("projectId") Long projectId,
            @RequestParam(value = "contractId",required = false)Long contractId,
            @RequestParam("contractTaxMny") BigDecimal contractTaxMny,
            @RequestParam("orgId") Long orgId
    );

}
