package com.ejianc.business.contractbase.vo.tempDetail;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModelProperty;

/**
 * 子表导出设置
 *
 * @author CJ
 * @Description: 子表导出设置
 * @date 2022/11/8 10:04
 */
public class TemplDetailExportSettingVO extends BaseVO {
    private static final long serialVersionUID = -542481150868467363L;

    @ApiModelProperty("分类Id")
    private Long categoryId;
    @ApiModelProperty("合同模板Id")
    private Long templateId;
    @ApiModelProperty("对应单据的单据类型编码")
    private String billTypeCode;
    @ApiModelProperty("所属实体Id")
    private Long belongEntityId;
    @ApiModelProperty("所属实体对应主实体Id")
    private Long mainEntityId;
    @ApiModelProperty(value = "所属工程Id")
    private Long belongProjectId;
    @ApiModelProperty("表名")
    private String tableName;
    @ApiModelProperty("子实体在主实体中的属性名称")
    private String mainAttrName;

    @ApiModelProperty("清单名称")
    private String detailName;
    @ApiModelProperty("停启用状态: 0-停用，1-启用")
    private Boolean detailStatus;
    @ApiModelProperty("排序")
    private Integer detailSequence;

    @ApiModelProperty("所属组织Id")
    private Long belongOrgId;
    @ApiModelProperty("所属组织名称")
    private String belongOrgName;
    @ApiModelProperty("所属组织编码")
    private String belongOrgCode;

    @ApiModelProperty("系统模板文件Id")
    private Long sysFileId;
    @ApiModelProperty("自定义模板文件Id")
    private Long customFileId;

    @ApiModelProperty("数据为空时是否导出: 0-不导出，1-导出")
    private Boolean emptyExportFlag;

    public Boolean getEmptyExportFlag() {
        return emptyExportFlag;
    }

    public void setEmptyExportFlag(Boolean emptyExportFlag) {
        this.emptyExportFlag = emptyExportFlag;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getMainAttrName() {
        return mainAttrName;
    }

    public void setMainAttrName(String mainAttrName) {
        this.mainAttrName = mainAttrName;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    public Long getBelongEntityId() {
        return belongEntityId;
    }

    public void setBelongEntityId(Long belongEntityId) {
        this.belongEntityId = belongEntityId;
    }

    public Long getMainEntityId() {
        return mainEntityId;
    }

    public void setMainEntityId(Long mainEntityId) {
        this.mainEntityId = mainEntityId;
    }

    public Long getBelongProjectId() {
        return belongProjectId;
    }

    public void setBelongProjectId(Long belongProjectId) {
        this.belongProjectId = belongProjectId;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public Boolean getDetailStatus() {
        return detailStatus;
    }

    public void setDetailStatus(Boolean detailStatus) {
        this.detailStatus = detailStatus;
    }

    public Integer getDetailSequence() {
        return detailSequence;
    }

    public void setDetailSequence(Integer detailSequence) {
        this.detailSequence = detailSequence;
    }

    public Long getBelongOrgId() {
        return belongOrgId;
    }

    public void setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
    }

    public String getBelongOrgName() {
        return belongOrgName;
    }

    public void setBelongOrgName(String belongOrgName) {
        this.belongOrgName = belongOrgName;
    }

    public String getBelongOrgCode() {
        return belongOrgCode;
    }

    public void setBelongOrgCode(String belongOrgCode) {
        this.belongOrgCode = belongOrgCode;
    }

    public Long getSysFileId() {
        return sysFileId;
    }

    public void setSysFileId(Long sysFileId) {
        this.sysFileId = sysFileId;
    }

    public Long getCustomFileId() {
        return customFileId;
    }

    public void setCustomFileId(Long customFileId) {
        this.customFileId = customFileId;
    }
}
