package com.ejianc.business.contractbase.pool.settlepool.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.settlepool.hystrix.SettlePoolHystrix;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 结算池管理API
 */
@FeignClient(name = "ejc-contractbase-web", url = "${common.env.feign-client-url}", path = "ejc-contractbase-web", fallback = SettlePoolHystrix.class)
public interface ISettlePoolApi {

    /**
     * 新增  &&  编辑
     *
     * @param settlePoolVO
     * @return
     */
    @PostMapping(value = "/api/settlePool/saveOrUpdateSettle")
    public CommonResponse<SettlePoolVO> saveOrUpdateSettle(@RequestBody SettlePoolVO settlePoolVO);

    /**
     * 删除
     *
     * @param settlePoolVO
     * @return
     */
    @PostMapping(value = "/api/settlePool/deleteSettle")
    public CommonResponse<SettlePoolVO> deleteSettle(@RequestBody SettlePoolVO settlePoolVO);

    /**
     * 批量新增&更新
     *
     * @param saveOrUpdateVOs
     * @return
     */
    @PostMapping(value = "/api/settlePool/saveOrUpdateBatch")
    public CommonResponse<List<SettlePoolVO>> saveOrUpdateBatch(@RequestBody List<SettlePoolVO> saveOrUpdateVOs);

    /**
     * 批量新增&更新---分布式事务版
     *
     * @param saveOrUpdateVOs
     * @return
     */
    @PostMapping(value = "/api/settlePool/saveOrUpdateBatchGlobal")
    public CommonResponse<List<SettlePoolVO>> saveOrUpdateBatchGlobal(@RequestBody List<SettlePoolVO> saveOrUpdateVOs);

    /**
     * 根据sourceId查询匹配的结算单
     *
     * @param sourceId
     * @return
     */
    @GetMapping(value = "/api/settlePool/getBySourceId")
    public CommonResponse<SettlePoolVO> getBySourceId(@RequestParam(value = "sourceId") Long sourceId);

    /**
     * 根据sourceIds查询匹配的结算单列表
     *
     * @param sourceIds
     * @return
     */
    @PostMapping(value = "/api/settlePool/getBySourceIds")
    public CommonResponse<List<SettlePoolVO>> getBySourceIds(@RequestBody List<Long> sourceIds);

    /**
     * 根据条件查询结算池列表
     *
     * @param QueryParam
     * @return
     */
    @PostMapping(value = "/api/settlePool/queryList")
    public CommonResponse<List<SettlePoolVO>> queryList(@RequestBody QueryParam QueryParam);

    /**
     *  获取当前 合同下的累计结算金额++1
     * @param settlePoolVO
     * @return
     */
    @RequestMapping(value = "/api/settlePool/queryTotalMny", method = RequestMethod.POST)
    public CommonResponse<SettlePoolVO> queryTotalMny(@RequestBody SettlePoolVO settlePoolVO);

    /**
     *  获取当前 合同下的累计结算金额++1
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/api/settlePool/queryContractsTotalSettleMny", method = RequestMethod.POST)
    public CommonResponse<Map<String, BigDecimal>> queryContractsTotalSettleMny(@RequestBody QueryParam queryParam);

    /**
     *  获取当前 无合同下的累计结算金额
     *  根据 项目 收款单位 是否有合同 结算类型 无合同下的累计结算金额
     * @param settlePoolVO
     * @return
     */
    @RequestMapping(value = "/api/settlePool/queryNoContractTotalMny", method = RequestMethod.POST)
    public CommonResponse<JSONObject> queryNoContractTotalMny(@RequestBody SettlePoolVO settlePoolVO);

    /**
     * 根据项目id查询结算池中结算类型为产值报量的累计产值金额
     *
     * @param projectId 项目id
     *
     * @return 累计产值金额 = “本期结算金额(含税)”之和
     */
    @GetMapping(value = "/api/settlePool/fetchTotalProductValueTaxMny")
    CommonResponse<BigDecimal> fetchTotalProductValueTaxMny(@RequestParam(value = "projectId") Long projectId);

    /**
     * 根据合同id查询该合同的所有【结算池】数据，汇总“本期结算金额”之和
     *
     * @param contractIds 合同id集合
     *
     * @return 累计结算金额, Map< String, Object>
     */
    @PostMapping(value = "/api/settlePool/fetchTotalSettleTaxMny")
    CommonResponse<Map<String, Object>> fetchTotalSettleTaxMny(@RequestBody Collection<Long> contractIds);

}
