package com.ejianc.business.contractbase.home.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.api.IAnnualOperatingIndicatorsApi;
import com.ejianc.business.contractbase.home.consts.BusinessStatusEnum;
import com.ejianc.business.contractbase.home.consts.DevTypeEnum;
import com.ejianc.business.contractbase.home.consts.ProjectStatusEnum;
import com.ejianc.business.contractbase.home.consts.ProjectSurveyEnum;
import com.ejianc.business.contractbase.home.mapper.HomePortalMapper;
import com.ejianc.business.contractbase.home.service.IHomePortalService;
import com.ejianc.business.contractbase.home.util.EJCDateUtil;
import com.ejianc.business.contractbase.home.util.ListCallable;
import com.ejianc.business.contractbase.home.util.PageUtil;
import com.ejianc.business.contractbase.home.vo.*;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.utils.TreeNodeBUtil;
import com.ejianc.business.outputvalcount.api.IOutputValueApi;
import com.ejianc.business.outputvalcount.vo.OutputValDTO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * <p>
 * 门户首页 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2022-04-28
 */
@Service("ContractService")
public class HomePortalServiceImpl extends BaseServiceImpl<HomePortalMapper, ContractPoolEntity> implements IHomePortalService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IProjectPoolApi projectSetApi;

    @Autowired
    private IAnnualOperatingIndicatorsApi indicatorsApi;

    @Autowired
    private IContractPoolService contractService;

    @Autowired
    private ISettlePoolService settleService;

    @Autowired
    private HomePortalMapper mapper;

    @Autowired
    private IShareSubjectOrgApi subjectOrgApi;

    @Autowired
    private IOutputValueApi outputValueApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    private String PROJECT_SETTLE_RANGE_PARAM = "P-zF77230174";

    @Override
    public CommonResponse<Map<String, BigDecimal>> capitalCount(String range, String dateIn, Long orgId) {
        String projectStatus = null;
        String year = null;
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)){ // 在建
            projectStatus = "1";
        }
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)){ // 今年
            year = EJCDateUtil.getYear() + "";
        }

        List<Long> projectIds = new ArrayList<>();
        List<ProjectPoolSetVO> projectList = this.queryProjectPoolList(projectStatus, year, orgId);
        projectIds = projectList.stream().map(ProjectPoolSetVO:: getId).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(projectIds)){
            return CommonResponse.success("项目为空！", new HashMap<>());
        }

        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        // 项目已经组织过滤
//        if (orgId == null) {
//            orgId = InvocationInfoProxy.getOrgId();
//        }
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        ExecutorService threadPool = Executors.newFixedThreadPool(10);

        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        param1.getParams().put("sourceType", new Parameter(QueryParam.EQ, ContractTypeEnum.施工合同.getTypeCode()));
        QueryParam param2 = Utils.deepCopy(param);// 深拷贝
        param2.getParams().put("sourceType", new Parameter(QueryParam.EQ, SettleSourceTypeEnum.产值报量.getCode()));
        QueryParam param3 = Utils.deepCopy(param);// 深拷贝
        param3.getParams().put("sourceType", new Parameter(QueryParam.EQ, SettleSourceTypeEnum.对甲报量.getCode()));
        QueryParam param4 = Utils.deepCopy(param);// 深拷贝
        param4.getParams().put("contractProperty", new Parameter(QueryParam.EQ, ContractPropertyEnum.支出合同.getPropertyCode()));
        QueryParam param5 = Utils.deepCopy(param);// 深拷贝
        param5.getParams().put("settleProperty", new Parameter(QueryParam.EQ, "0"));// 支出
        param5.getParams().put("sourceType", new Parameter(QueryParam.NE, SettleSourceTypeEnum.诉讼费结算.getCode()));

        QueryParam webParam = Utils.deepCopy(param);// 深拷贝
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效

        QueryParam param6 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param7 = Utils.deepCopy(webParam);// 深拷贝
//        QueryParam param8 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param9 = Utils.deepCopy(webParam);// 深拷贝
        param9.getParams().put("enableState", new Parameter(QueryParam.EQ, 1));// 生效
        param9.getParams().put("latestFlag", new Parameter(QueryParam.EQ, 1));// 最新版
        QueryParam param10 = Utils.deepCopy(webParam);// 深拷贝
        param10.getParams().remove("billState");
        param10.getParams().put("proportionFlag", new Parameter(QueryParam.EQ, 1));// 已分摊/已归集
        QueryParam param11 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param12 = Utils.deepCopy(webParam);// 深拷贝

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, contractService);// 施工合同
        Future<JSONArray> future2 = ListCallable.excute(threadPool, param2, settleService);// 产值报量
        Future<JSONArray> future3 = ListCallable.excute(threadPool, param3, settleService);// 对甲报量
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param4, contractService);// 支出合同
        Future<JSONArray> future5 = ListCallable.excute(threadPool, param5, settleService);// 累计结算
        Future<JSONArray> future6 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/paymentRegister/queryList", param6);// 付款登记
        Future<JSONArray> future7 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/receiptRegister/queryList", param7);// 收款登记
//        Future<JSONArray> future8 = ListCallable.excute(threadPool, BASE_HOST + "ejc-proincome-web/claim/queryList", param8);// 签证洽商索赔
        Future<JSONArray> future9 = ListCallable.excute(threadPool, BASE_HOST + "ejc-targetcost-web/duty/queryList", param9);// 目标责任成本
        Future<JSONArray> future10 = ListCallable.excute(threadPool, BASE_HOST + "ejc-procost-web/costDetail/queryList", param10);// 实际成本
        Future<JSONArray> future11 = ListCallable.excute(threadPool, BASE_HOST + "ejc-proincome-web/costAdjust/queryList", param11);// 工程造价调整申请
        Future<JSONArray> future12 = ListCallable.excute(threadPool, BASE_HOST + "ejc-proincome-web/budget/queryList", param12);// 收入预算

        List<ContractPoolEntity> contractList = new ArrayList<>();// 施工合同
        List<SettlePoolEntity> productionList = new ArrayList<>();// 产值报量
        List<SettlePoolEntity> quoteList = new ArrayList<>();// 对甲报量
        List<ContractPoolEntity> outContractList = new ArrayList<>();// 支出合同
        List<SettlePoolEntity> settleList = new ArrayList<>();// 累计结算
        JSONArray paymentList = new JSONArray();// 付款登记
        JSONArray receiptList = new JSONArray();// 收款登记
//        JSONArray claimList = new JSONArray();// 签证洽商索赔
        JSONArray targetList = new JSONArray();// 目标责任成本
        JSONArray costList = new JSONArray();// 实际成本
        JSONArray adjustList = new JSONArray();// 工程造价调整申请
        JSONArray budgetList = new JSONArray();// 收入预算
        try {
            contractList = JSONObject.parseArray(future1.get().toJSONString(), ContractPoolEntity.class);
            productionList = JSONObject.parseArray(future2.get().toJSONString(), SettlePoolEntity.class);
            quoteList = JSONObject.parseArray(future3.get().toJSONString(), SettlePoolEntity.class);
            outContractList = JSONObject.parseArray(future4.get().toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray(future5.get().toJSONString(), SettlePoolEntity.class);
            paymentList = future6.get();
            receiptList = future7.get();
//            claimList = future8.get();
            targetList = future9.get();
            costList = future10.get();
            adjustList = future11.get();
            budgetList = future12.get();
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        BigDecimal incomeMny = contractList.stream().filter(x -> x.getContractTaxMny() != null)
                .map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 收入合同金额
        BigDecimal productionMoney = productionList.stream().filter(x -> x.getCurTaxMny() != null)
                .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 产值统计
        BigDecimal totalQuoteMoney = quoteList.stream().filter(x -> x.getCurTaxMny() != null)
                .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 批复金额
        // 收款登记 本次收款 之和
        BigDecimal totalReceiveMoney = receiptList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("sumReceivedMny") != null)
                .map(x -> x.getBigDecimal("sumReceivedMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计收款
        BigDecimal shouldRecNotRec = ComputeUtil.safeSub(totalReceiveMoney, totalQuoteMoney);// 应收未收金额
        // TODO 无发票池
        BigDecimal openInvoiceMoney = BigDecimal.ZERO;// 开票金额
        BigDecimal outContractMoney = outContractList.stream().filter(x -> x.getContractTaxMny() != null)
                .map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 支出合同金额
        // 查询累计履约金额
        BigDecimal performanceMoney = this.getPerformanceMny(projectIds);// 累计履约金额
        BigDecimal totalSettleMoney = settleList.stream().filter(x -> x.getCurTaxMny() != null)
                .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计结算金额
        // TODO 无发票池
        BigDecimal receiveInvoiceMoney = BigDecimal.ZERO;// 收票金额
        // 付款登记 本次付款 之和
        BigDecimal totalOutMoney = paymentList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("payMny") != null)
                .map(x -> x.getBigDecimal("payMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计付款
        BigDecimal shouldPayNotPay = ComputeUtil.safeSub(totalSettleMoney, totalOutMoney);// 应付未付金额
//        // 签证洽商索赔 洽商签证索赔金额 之和
//        BigDecimal totalClaimMoney = claimList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("claimTaxMny") != null)
//                .map(x -> x.getBigDecimal("claimTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 二次经营申请金额
//        // 签证洽商索赔 甲方批复金额 之和
//        BigDecimal totalReplyMoney = claimList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("replyTaxMny") != null)
//                .map(x -> x.getBigDecimal("replyTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 二次经营批复金额
        // 改为查询【合同池】“合同大类”为“施工合同”的合同数据，取“二次经营申请金额(含税)”/ “二次经营批复金额(含税)”之和
        // 签证洽商索赔 洽商签证索赔金额 之和
        BigDecimal totalClaimMoney = contractList.stream().filter(x -> x.getTotalClaimTaxMny() != null)
                .map(ContractPoolEntity::getTotalClaimTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 二次经营申请金额
        // 项目预算书 金额 之和
        BigDecimal budgetMoney = budgetList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("budgetTaxMny") != null)
                .map(x -> x.getBigDecimal("budgetTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 收入预算
        // 签证洽商索赔 甲方批复金额 之和
        BigDecimal totalReplyMoney = contractList.stream().filter(x -> x.getTotalTeplyTaxMny() != null)
                .map(ContractPoolEntity::getTotalTeplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 二次经营批复金额
        // 目标责任成本 最新版 生效 金额 之和
        BigDecimal totalTargetMoney = targetList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("mny") != null)
                .map(x -> x.getBigDecimal("mny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 目标责任成本
        // 实际成本 已归集 无税发生金额 之和
        BigDecimal totalCostMoney = costList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("happenMny") != null)
                .map(x -> x.getBigDecimal("happenMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 实际成本

        // 工程造价累计调整金额 变更申请金额 之和
        BigDecimal adjustMny = adjustList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("applyChangeTaxMny") != null)
                .map(x -> x.getBigDecimal("applyChangeTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 工程造价累计调整金额

        // 收入合同签订金额（合同变更后，合同池施工合同合同含税金额，不含签证洽商索赔）+ 二次经营批复金额
        BigDecimal inContractMoney = ComputeUtil.safeAdd(incomeMny, totalReplyMoney);
        // 收入合同签订金额（合同变更后，合同池施工合同合同含税金额，不含签证洽商索赔）+ 工程造价累计调整金额
        BigDecimal totalAdjustMoney = ComputeUtil.safeAdd(incomeMny, adjustMny);
        // 合同收款比例：累计收款/收入合同金额
        BigDecimal receiveRate = ComputeUtil.bigDecimalPercent(totalReceiveMoney, inContractMoney, 2);
        // 结算支付比例：累计付款/累计结算金额
        BigDecimal settleOutRate = ComputeUtil.bigDecimalPercent(totalOutMoney, totalSettleMoney, 2);

        // 本年新增，从一建信息中心做的数据取数
        BigDecimal newContracatTarget = BigDecimal.ZERO;// 产值经营指标
        if(ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)){
            // 一建信息中心提供
            CommonResponse<BigDecimal> detailByOrgId = indicatorsApi.getDetailByOrgId(orgId, EJCDateUtil.getYear());
            if(!detailByOrgId.isSuccess()){
                logger.error("产值经营指标-{}", detailByOrgId.getMsg());
            } else {
                newContracatTarget = ComputeUtil.safeMultiply(detailByOrgId.getData(), new BigDecimal("10000"));// 产值经营指标
            }
        }
        BigDecimal productionRate = ComputeUtil.safeDiv(productionMoney, newContracatTarget);// 产值完成率

        Map<String, BigDecimal> map = new HashMap<>();
        map.put("inContractMoney", inContractMoney);// 收入合同金额
        map.put("productionMoney", productionMoney);// 产值统计
        map.put("totalQuoteMoney", totalQuoteMoney);// 批复金额
        map.put("totalReceiveMoney", totalReceiveMoney);// 累计收款
        map.put("shouldRecNotRec", shouldRecNotRec);// 应收未收金额
        map.put("openInvoiceMoney", openInvoiceMoney);// 开票金额
        map.put("outContractMoney", outContractMoney);// 支出合同金额
        map.put("performanceMoney", performanceMoney);// 累计履约金额
        map.put("totalSettleMoney", totalSettleMoney);// 累计结算金额
        map.put("receiveInvoiceMoney", receiveInvoiceMoney);// 收票金额
        map.put("totalOutMoney", totalOutMoney);// 累计付款
        map.put("shouldPayNotPay", shouldPayNotPay);// 应付未付金额
        map.put("newContracatTarget", newContracatTarget);// 产值经营指标
        map.put("productionRate", productionRate);// 产值完成率
        map.put("totalClaimMoney", totalClaimMoney);// 二次经营申请金额
        map.put("totalReplyMoney", totalReplyMoney);// 二次经营批复金额
        map.put("totalAdjustMoney", totalAdjustMoney);// 工程造价调整后总金额
        map.put("totalTargetMoney", totalTargetMoney);// 目标成本
        map.put("totalCostMoney", totalCostMoney);// 实际成本
        map.put("budgetMoney", budgetMoney);// 收入预算
        map.put("receiveRate", receiveRate);// 合同收款比例
        map.put("settleOutRate", settleOutRate);// 结算支付比例
        return CommonResponse.success("查询数据成功！", map);
    }

    @Override
    public CommonResponse<Map<String, BigDecimal>> capitalCountLeader(String range, String dateIn, Long orgId) {
        String projectStatus = null;
        String year = null;
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)){ // 在建
            projectStatus = "1";
        }
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)){ // 今年
            year = EJCDateUtil.getYear() + "";
        }

        List<Long> projectIds = new ArrayList<>();
        List<ProjectPoolSetVO> projectList = this.queryProjectPoolList(projectStatus, year, orgId);
        projectIds = projectList.stream().map(ProjectPoolSetVO:: getId).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(projectIds)){
            return CommonResponse.success("项目为空！", new HashMap<>());
        }

        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));

        ExecutorService threadPool = Executors.newFixedThreadPool(10);

        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        param1.getParams().put("sourceType", new Parameter(QueryParam.EQ, ContractTypeEnum.施工合同.getTypeCode()));
        QueryParam param2 = Utils.deepCopy(param);// 深拷贝
        param2.getParams().put("sourceType", new Parameter(QueryParam.EQ, SettleSourceTypeEnum.产值报量.getCode()));
        QueryParam param4 = Utils.deepCopy(param);// 深拷贝
        param4.getParams().put("contractProperty", new Parameter(QueryParam.EQ, ContractPropertyEnum.支出合同.getPropertyCode()));
        QueryParam param5 = Utils.deepCopy(param);// 深拷贝
        param5.getParams().put("settleProperty", new Parameter(QueryParam.EQ, "0"));// 支出

        CommonResponse<ParamRegisterSetVO> paramResponse = paramConfigApi.getByCode(PROJECT_SETTLE_RANGE_PARAM);
        if (!paramResponse.isSuccess() || paramResponse.getData() == null) {
            throw new BusinessException("获取项目结算查询结算单范围系统参数请求失败，失败原因：" + paramResponse.getMsg());
        }
        String valueData = paramResponse.getData().getValueData();
        Assert.hasText(valueData, "获取的项目结算查询结算单范围不能为空!");
        param5.getParams().put("sourceType", new Parameter(QueryParam.IN, valueData));

//        param5.getParams().put("sourceType", new Parameter(QueryParam.NOT_IN, Arrays.asList(SettleSourceTypeEnum.诉讼费结算.getCode(),
//                SettleSourceTypeEnum.专业分包月度结算.getCode(), SettleSourceTypeEnum.劳务分包月度结算.getCode())));

        QueryParam webParam = Utils.deepCopy(param);// 深拷贝
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效

        QueryParam param6 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param7 = Utils.deepCopy(webParam);// 深拷贝

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, contractService);// 施工合同
        Future<JSONArray> future2 = ListCallable.excute(threadPool, param2, settleService);// 产值报量
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param4, contractService);// 支出合同
        Future<JSONArray> future5 = ListCallable.excute(threadPool, param5, settleService);// 累计结算
        Future<JSONArray> future6 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/paymentRegister/queryList", param6);// 付款登记
        Future<JSONArray> future7 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/receiptRegister/queryList", param7);// 收款登记

        List<ContractPoolEntity> contractList = new ArrayList<>();// 施工合同
        List<SettlePoolEntity> productionList = new ArrayList<>();// 产值报量
        List<ContractPoolEntity> outContractList = new ArrayList<>();// 支出合同
        List<SettlePoolEntity> settleList = new ArrayList<>();// 累计结算
        JSONArray paymentList = new JSONArray();// 付款登记
        JSONArray receiptList = new JSONArray();// 收款登记
        try {
            contractList = JSONObject.parseArray(future1.get().toJSONString(), ContractPoolEntity.class);
            productionList = JSONObject.parseArray(future2.get().toJSONString(), SettlePoolEntity.class);
            outContractList = JSONObject.parseArray(future4.get().toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray(future5.get().toJSONString(), SettlePoolEntity.class);
            paymentList = future6.get();
            receiptList = future7.get();
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        BigDecimal incomeMny = contractList.stream().filter(x -> x.getContractTaxMny() != null)
                .map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 收入合同金额
        // 工程造价调整申请 申请变动金额 之和(合同池工程造价调整金额合计)
        BigDecimal baseMny = contractList.stream().filter(x -> x.getBaseTaxMny() != null)
                .map(ContractPoolEntity::getBaseTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 合同签订初始金额
        BigDecimal adjustMny = contractList.stream().filter(x -> x.getTotalCostAdjustTaxMny() != null)
                .map(ContractPoolEntity::getTotalCostAdjustTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 工程造价调整金额
        // 内部工程造价合计 = 合同池 合同签订(合同初始)金额（含税） + 工程造价调整金额合计
        BigDecimal costAdjustMoney = ComputeUtil.safeAdd(baseMny, adjustMny);
        BigDecimal productionMoney = productionList.stream().filter(x -> x.getCurTaxMny() != null)
                .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 产值统计
        // 收款登记 本次收款 之和
        BigDecimal totalReceiveMoney = receiptList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("sumReceivedMny") != null)
                .map(x -> x.getBigDecimal("sumReceivedMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计收款
        BigDecimal outContractMoney = outContractList.stream().filter(x -> x.getContractTaxMny() != null)
                .map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 支出合同金额
        // 查询累计履约金额
        BigDecimal performanceMoney = this.getPerformanceMny(projectIds);// 累计履约金额
        BigDecimal totalSettleMoney = settleList.stream().filter(x -> x.getCurTaxMny() != null)
                .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计结算金额
        // 付款登记 本次付款 之和
        BigDecimal totalOutMoney = paymentList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("payMny") != null)
                .map(x -> x.getBigDecimal("payMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计付款
        // 签证洽商索赔 甲方批复金额 之和
        BigDecimal totalReplyMoney = contractList.stream().filter(x -> x.getTotalTeplyTaxMny() != null)
                .map(ContractPoolEntity::getTotalTeplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 二次经营批复金额
        // 收入合同签订金额（合同变更后，合同池施工合同合同含税金额，不含签证洽商索赔）+ 二次经营批复金额
        BigDecimal inContractMoney = ComputeUtil.safeAdd(incomeMny, totalReplyMoney);
        // 合同收款比例：累计收款/收入合同金额
        BigDecimal receiveRate = ComputeUtil.bigDecimalPercent(totalReceiveMoney, inContractMoney, 2);
        // 结算支付比例：累计付款/累计结算金额
        BigDecimal settleOutRate = ComputeUtil.bigDecimalPercent(totalOutMoney, totalSettleMoney, 2);

        Map<String, BigDecimal> map = new HashMap<>();
        map.put("inContractMoney", inContractMoney);// 收入合同金额
        map.put("productionMoney", productionMoney);// 产值统计
        map.put("costAdjustMoney", costAdjustMoney);// 内部工程造价合计
        map.put("totalReceiveMoney", totalReceiveMoney);// 累计收款
        map.put("receiveRate", receiveRate);// 合同收款比例
        map.put("outContractMoney", outContractMoney);// 支出合同金额
        map.put("performanceMoney", performanceMoney);// 累计履约金额
        map.put("totalSettleMoney", totalSettleMoney);// 累计结算金额
        map.put("totalOutMoney", totalOutMoney);// 累计付款
        map.put("settleOutRate", settleOutRate);// 结算支付比例
        return CommonResponse.success("查询数据成功！", map);
    }

    @Override
    public IPage<FinanceCountVO> capitalCountOrgLeader(QueryParam param) {
        logger.info("分子单位查询开始！");
        IPage<FinanceCountVO> page = new Page<>();
        Integer pageNumber = Integer.valueOf(String.valueOf(param.getPageIndex()));
        Integer pageSize = Integer.valueOf(String.valueOf(param.getPageSize()));
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        Long orgId = null;
        if(param.getParams().containsKey("orgId")){
            orgId = Long.valueOf(String.valueOf(param.getParams().get("orgId").getValue()));
        }else {
            orgId = InvocationInfoProxy.getOrgId();
        }
        Boolean flag = false;
        if(param.getParams().containsKey("excel")){
            flag = true;
            param.getParams().remove("excel");
        }
        // 分子公司、经理部
        List<OrgVO> allOrgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        List<OrgVO> orgVOList = allOrgVOList.stream().filter(e -> e.getOrgType() == 2 || e.getOrgType() == 3).collect(Collectors.toList());
        //List<Long> ordIdsList = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        //Map<String, OrgVO> innerCodeMap = orgVOList.stream().collect(Collectors.toMap(OrgVO::getInnerCode, Function.identity(), (k1, k2) -> k2));
        Map<Long, OrgVO> orgIdMap = allOrgVOList.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity(), (k1, k2) -> k2));
        List<Long> projectIds;
//        QueryParam param0 = Utils.deepCopy(param);// 深拷贝
//        param0.setPageIndex(0);
//        param0.setPageSize(-1);
//        param0.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        //param0.getParams().put("projectStatus", new Parameter(QueryParam.EQ, "1"));
//        CommonResponse<Page<ProjectPoolSetVO>> projectPage = projectSetApi.queryProjectIPage(param0);
//        if(!projectPage.isSuccess()) {
//            throw new BusinessException("查询失败，获取项目信息失败！");
//        }
        List<ProjectPoolSetVO> result = new ArrayList<>();
        if(param.getParams().containsKey("orgName")){
            List<Long> pOrgId = allOrgVOList.stream().filter(e -> e.getName().equals(param.getParams().get("orgName").getValue())).map(e->{ return e.getId(); }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(pOrgId)){
                result = this.queryProjectPoolList(null,null,pOrgId.get(0));
            }
            param.getParams().remove("orgName");
        }else {
            result = this.queryProjectPoolList(null,null,orgId);
        }
        List<ProjectPoolSetVO> projectList = new ArrayList<>();
        projectList = result;
        projectIds = projectList.stream().map(BaseVO::getId).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(projectIds)){
            logger.info("查询分子单位-{}，项目为空！", orgVOList);
            return new Page<>();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam param1 = Utils.deepCopy(queryParam);// 深拷贝
        param1.getParams().put("sourceType", new Parameter(QueryParam.EQ, ContractTypeEnum.施工合同.getTypeCode()));
        QueryParam param2 = Utils.deepCopy(queryParam);// 深拷贝
        param2.getParams().put("sourceType", new Parameter(QueryParam.EQ, SettleSourceTypeEnum.产值报量.getCode()));
        QueryParam param4 = Utils.deepCopy(queryParam);// 深拷贝
        param4.getParams().put("contractProperty", new Parameter(QueryParam.EQ, ContractPropertyEnum.支出合同.getPropertyCode()));
        QueryParam param5 = Utils.deepCopy(queryParam);// 深拷贝
        param5.getParams().put("settleProperty", new Parameter(QueryParam.EQ, "0"));// 支出
        param5.getParams().put("sourceType", new Parameter(QueryParam.NE, SettleSourceTypeEnum.诉讼费结算.getCode()));
        QueryParam webParam = Utils.deepCopy(queryParam);// 深拷贝
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效
        QueryParam param6 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param7 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param8 = Utils.deepCopy(param);// 深拷贝
        param8.getParams().put("sourceType", new Parameter(QueryParam.EQ, SettleSourceTypeEnum.对甲报量.getCode()));


        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, contractService);// 施工合同
        Future<JSONArray> future2 = ListCallable.excute(threadPool, param2, settleService);// 产值报量
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param4, contractService);// 支出合同
        Future<JSONArray> future5 = ListCallable.excute(threadPool, param5, settleService);// 累计结算
        Future<JSONArray> future6 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/paymentRegister/queryList", param6);// 付款登记
        Future<JSONArray> future7 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/receiptRegister/queryList", param7);// 收款登记
        Future<JSONArray> future8 = ListCallable.excute(threadPool, param8, settleService);// 对甲报量

        List<ContractPoolEntity> contractList = new ArrayList<>();// 施工合同
        List<SettlePoolEntity> productionList = new ArrayList<>();// 产值报量
        List<ContractPoolEntity> outContractList = new ArrayList<>();// 支出合同
        List<SettlePoolEntity> settleList = new ArrayList<>();// 累计结算
        JSONArray paymentList = new JSONArray();// 付款登记
        JSONArray receiptList = new JSONArray();// 收款登记
        List<SettlePoolEntity> quoteList = new ArrayList<>();// 对甲报量
        try {
            contractList = JSONObject.parseArray(future1.get().toJSONString(), ContractPoolEntity.class);
            productionList = JSONObject.parseArray(future2.get().toJSONString(), SettlePoolEntity.class);
            outContractList = JSONObject.parseArray(future4.get().toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray(future5.get().toJSONString(), SettlePoolEntity.class);
            paymentList = future6.get();
            receiptList = future7.get();
            quoteList = JSONObject.parseArray(future8.get().toJSONString(), SettlePoolEntity.class);
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
        Map<Long, List<ContractPoolEntity>> incomeMap = contractList.stream().collect(Collectors.groupingBy(ContractPoolEntity::getProjectId));
        Map<Long, List<SettlePoolEntity>> productionMap = productionList.stream().collect(Collectors.groupingBy(SettlePoolEntity::getProjectId));
        Map<Long, List<ContractPoolEntity>> outContractMap = outContractList.stream().collect(Collectors.groupingBy(ContractPoolEntity::getProjectId));
        Map<Long, List<SettlePoolEntity>> settleMap = settleList.stream().collect(Collectors.groupingBy(SettlePoolEntity::getProjectId));
        Map<Long, List<SettlePoolEntity>> quoteMap = quoteList.stream().collect(Collectors.groupingBy(SettlePoolEntity::getProjectId));
        Map<Long, List<Object>> paymentMap = paymentList.stream().collect(Collectors.groupingBy(item -> ((JSONObject) item).getLong("projectId")));
        Map<Long, List<Object>> receiptMap = receiptList.stream().collect(Collectors.groupingBy(item -> ((JSONObject) item).getLong("projectId")));
        Map<Long, ProjectPoolSetVO> projectMap = projectList.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId,a -> a,(k1,k2)->k1));
        // 查询累计履约金额
        Map<Long,BigDecimal> performanceMap = this.getPerformProjectMap(projectIds);
        List<FinanceCountVO> fclist = new ArrayList<>();
        BigDecimal incomeMny = BigDecimal.ZERO;
        BigDecimal totalReplyMoney = BigDecimal.ZERO;
        BigDecimal costAdjustMoney = BigDecimal.ZERO;
        BigDecimal productionMoney = BigDecimal.ZERO;
        BigDecimal outContractMoney = BigDecimal.ZERO;
        BigDecimal totalSettleMoney = BigDecimal.ZERO;
        BigDecimal totalReceiveMoney = BigDecimal.ZERO;
        BigDecimal totalOutMoney = BigDecimal.ZERO;
        BigDecimal inContractMoney = BigDecimal.ZERO;
        BigDecimal receiveRate = BigDecimal.ZERO;
        BigDecimal settleOutRate = BigDecimal.ZERO;
        BigDecimal performanceMoney = BigDecimal.ZERO;
        BigDecimal totalQuoteMoney = BigDecimal.ZERO;
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        for (Long k:projectMap.keySet()){
            incomeMny = BigDecimal.ZERO;
            totalReplyMoney = BigDecimal.ZERO;
            costAdjustMoney = BigDecimal.ZERO;
            productionMoney = BigDecimal.ZERO;
            outContractMoney = BigDecimal.ZERO;
            totalSettleMoney = BigDecimal.ZERO;
            totalReceiveMoney = BigDecimal.ZERO;
            totalOutMoney = BigDecimal.ZERO;
            inContractMoney = BigDecimal.ZERO;
            receiveRate = BigDecimal.ZERO;
            settleOutRate = BigDecimal.ZERO;
            performanceMoney = BigDecimal.ZERO;
            totalQuoteMoney = BigDecimal.ZERO;
            contractTaxMny = BigDecimal.ZERO;
            if (incomeMap.containsKey(k)) {
                incomeMny = incomeMap.get(k).stream().filter(x -> x.getContractTaxMny() != null).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                totalReplyMoney = incomeMap.get(k).stream().filter(x -> x.getTotalTeplyTaxMny() != null).map(ContractPoolEntity::getTotalTeplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 二次经营批复金额
                // 工程造价调整申请 申请变动金额 之和(合同池工程造价调整金额合计)
                costAdjustMoney = incomeMap.get(k).stream().filter(x -> x.getTotalCostAdjustTaxMny() != null)
                        .map(ContractPoolEntity::getTotalCostAdjustTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 内部工程造价合计
                contractTaxMny = incomeMap.get(k).stream().filter(x -> x.getContractTaxMny() != null)
                        .map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (productionMap.containsKey(k)){
                productionMoney = productionMap.get(k).stream().filter(x -> x.getCurTaxMny() != null)
                        .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 产值统计
            }
            if (outContractMap.containsKey(k)){
                outContractMoney = outContractMap.get(k).stream().filter(x -> x.getContractTaxMny() != null)
                        .map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 支出合同金额
            }
            if (settleMap.containsKey(k)){
                totalSettleMoney = settleMap.get(k).stream().filter(x -> x.getCurTaxMny() != null)
                        .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计结算金额
            }
            if (quoteMap.containsKey(k)){
                totalQuoteMoney = quoteMap.get(k).stream().filter(x -> x.getCurTaxMny() != null)
                        .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 批复金额
            }
            if (receiptMap.containsKey(k)){
                totalReceiveMoney = receiptMap.get(k).stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("sumReceivedMny") != null)
                        .map(x -> x.getBigDecimal("sumReceivedMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计收款
            }
            if (paymentMap.containsKey(k)){
                totalOutMoney = paymentMap.get(k).stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("payMny") != null)
                        .map(x -> x.getBigDecimal("payMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计付款
            }
            if (performanceMap.containsKey(k)){
                performanceMoney = performanceMap.get(k);
            }
            // 收入合同签订金额（合同变更后，合同池施工合同合同含税金额，不含签证洽商索赔）+ 二次经营批复金额
            inContractMoney = ComputeUtil.safeAdd(incomeMny, totalReplyMoney);
            // 合同收款比例：累计收款/收入合同金额
            receiveRate = ComputeUtil.bigDecimalPercent(totalReceiveMoney, inContractMoney, 2);
            // 结算支付比例：累计付款/累计结算金额
            settleOutRate = ComputeUtil.bigDecimalPercent(totalOutMoney, totalSettleMoney, 2);
            FinanceCountVO vo = new FinanceCountVO();
            if (projectMap.get(k).getProjectDepartmentId()!=null){
                vo.setOrgId(projectMap.get(k).getProjectDepartmentId());
                if (!orgIdMap.containsKey(vo.getOrgId())){
                    continue;
                }
                vo.setOrgName(orgIdMap.get(vo.getOrgId()).getName());
                vo.setOrgType(orgIdMap.get(vo.getOrgId()).getOrgType());
                vo.setInnerCode(orgIdMap.get(vo.getOrgId()).getInnerCode());
                vo.setParentId(orgIdMap.get(vo.getOrgId()).getParentId());
            }else {
                vo.setOrgId(projectMap.get(k).getOrgId());
                vo.setOrgName(projectMap.get(k).getOrgName());
                if (!orgIdMap.containsKey(vo.getOrgId())){
                    continue;
                }
                vo.setOrgType(orgIdMap.get(vo.getOrgId()).getOrgType());
                vo.setInnerCode(orgIdMap.get(vo.getOrgId()).getInnerCode());
                vo.setParentId(orgIdMap.get(vo.getOrgId()).getParentId());
            }
            vo.setProjectId(k);
            vo.setProjectCode(projectMap.get(k).getCode());
            vo.setProjectName(projectMap.get(k).getName());
            vo.setInContractMoney(inContractMoney);
            vo.setProductionMoney(productionMoney);
            vo.setCostAdjustMoney(ComputeUtil.safeAdd(costAdjustMoney,contractTaxMny));// 内部工程造价合计
            vo.setTotalReceiveMoney(totalReceiveMoney);
            vo.setReceiveRate(receiveRate);
            vo.setOutContractMoney(outContractMoney);
            vo.setPerformanceMoney(performanceMoney);
            vo.setTotalSettleMoney(totalSettleMoney);
            vo.setTotalOutMoney(totalOutMoney);
            vo.setSettleOutRate(settleOutRate);
            vo.setTotalQuoteMoney(totalQuoteMoney);
            fclist.add(vo);
        }
        List<FinanceCountVO> fList = new ArrayList<>();
        List<FinanceCountVO> listTree = new ArrayList<>();
        if (orgIdMap.get(orgId).getOrgType()!=5){
            List<FinanceCountVO> xmList = fclist.stream().filter(x->x.getOrgType()==5).collect(Collectors.toList());
            Map<Long, FinanceCountVO> fzMap = new HashMap<>();
            Map<Long, FinanceCountVO> xmMap = new HashMap<>();
            for (FinanceCountVO fVO : xmList) {
                if (!orgIdMap.containsKey(fVO.getParentId())){
                    continue;
                }
                if (xmMap.containsKey(fVO.getOrgId())) {
                    FinanceCountVO fco = xmMap.get(fVO.getOrgId());
                    fco.setInContractMoney(ComputeUtil.safeAdd(fco.getInContractMoney(),fVO.getInContractMoney()));
                    fco.setProductionMoney(ComputeUtil.safeAdd(fco.getProductionMoney(),fVO.getProductionMoney()));
                    fco.setCostAdjustMoney(ComputeUtil.safeAdd(fco.getCostAdjustMoney(),fVO.getCostAdjustMoney()));
                    fco.setTotalReceiveMoney(ComputeUtil.safeAdd(fco.getTotalReceiveMoney(),fVO.getTotalReceiveMoney()));
                    fco.setOutContractMoney(ComputeUtil.safeAdd(fco.getOutContractMoney(),fVO.getOutContractMoney()));
                    fco.setPerformanceMoney(ComputeUtil.safeAdd(fco.getPerformanceMoney(),fVO.getPerformanceMoney()));
                    fco.setTotalSettleMoney(ComputeUtil.safeAdd(fco.getTotalSettleMoney(),fVO.getTotalSettleMoney()));
                    fco.setTotalQuoteMoney(ComputeUtil.safeAdd(fco.getTotalQuoteMoney(),fVO.getTotalQuoteMoney()));
                    fco.setTotalOutMoney(ComputeUtil.safeAdd(fco.getTotalOutMoney(),fVO.getTotalOutMoney()));
                    fco.setReceiveRate(ComputeUtil.bigDecimalPercent(fco.getTotalReceiveMoney(), fco.getInContractMoney(), 2));
                    fco.setSettleOutRate(ComputeUtil.bigDecimalPercent(fco.getTotalOutMoney(), fco.getTotalSettleMoney(), 2));
                    xmMap.put(fco.getOrgId(), fco);
                }else {
                    FinanceCountVO fvo = new FinanceCountVO();
                    fvo.setOrgId(fVO.getOrgId());
                    fvo.setOrgName(fVO.getOrgName());
                    fvo.setInnerCode(fVO.getInnerCode());
                    fvo.setParentId(getOrgType(fVO.getParentId(), orgIdMap));
                    fvo.setInContractMoney(fVO.getInContractMoney());
                    fvo.setProductionMoney(fVO.getProductionMoney());
                    fvo.setCostAdjustMoney(fVO.getCostAdjustMoney());
                    fvo.setTotalReceiveMoney(fVO.getTotalReceiveMoney());
                    fvo.setReceiveRate(fVO.getReceiveRate());
                    fvo.setOutContractMoney(fVO.getOutContractMoney());
                    fvo.setPerformanceMoney(fVO.getPerformanceMoney());
                    fvo.setTotalSettleMoney(fVO.getTotalSettleMoney());
                    fvo.setTotalOutMoney(fVO.getTotalOutMoney());
                    fvo.setSettleOutRate(fVO.getSettleOutRate());
                    fvo.setTotalQuoteMoney(fVO.getTotalQuoteMoney());
                    xmMap.put(fvo.getOrgId(), fvo);
                }
            }
            List<FinanceCountVO> result4 = new ArrayList<>(xmMap.values());
            Map<Long, List<FinanceCountVO>> fcMap = result4.stream().collect(Collectors.groupingBy(FinanceCountVO::getParentId));
            for (Map.Entry<Long, List<FinanceCountVO>> le : fcMap.entrySet()) {
                List<FinanceCountVO> v = le.getValue();
                FinanceCountVO fvo = new FinanceCountVO();
                if (!orgIdMap.containsKey(le.getKey())){
                    continue;
                }
                fvo.setOrgId(le.getKey());
                fvo.setOrgName(orgIdMap.get(le.getKey()).getName());
                fvo.setInnerCode(orgIdMap.get(le.getKey()).getInnerCode());
                fvo.setParentId(0L);
                fvo.setInContractMoney(v.stream().filter(x -> x.getInContractMoney() != null)
                        .map(FinanceCountVO::getInContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setProductionMoney(v.stream().filter(x -> x.getProductionMoney() != null)
                        .map(FinanceCountVO::getProductionMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setCostAdjustMoney(v.stream().filter(x -> x.getCostAdjustMoney() != null)
                        .map(FinanceCountVO::getCostAdjustMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setTotalReceiveMoney(v.stream().filter(x -> x.getTotalReceiveMoney() != null)
                        .map(FinanceCountVO::getTotalReceiveMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setOutContractMoney(v.stream().filter(x -> x.getOutContractMoney() != null)
                        .map(FinanceCountVO::getOutContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setPerformanceMoney(v.stream().filter(x -> x.getPerformanceMoney() != null)
                        .map(FinanceCountVO::getPerformanceMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setTotalSettleMoney(v.stream().filter(x -> x.getTotalSettleMoney() != null)
                        .map(FinanceCountVO::getTotalSettleMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setTotalOutMoney(v.stream().filter(x -> x.getTotalOutMoney() != null)
                        .map(FinanceCountVO::getTotalOutMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setTotalQuoteMoney(v.stream().filter(x -> x.getTotalQuoteMoney() != null)
                        .map(FinanceCountVO::getTotalQuoteMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setReceiveRate(ComputeUtil.bigDecimalPercent(fvo.getTotalReceiveMoney(), fvo.getInContractMoney(), 2));
                fvo.setSettleOutRate(ComputeUtil.bigDecimalPercent(fvo.getTotalOutMoney(), fvo.getTotalSettleMoney(), 2));
                fzMap.put(le.getKey(),fvo);
            }
            fzMap.putAll(xmMap);
            //logger.info("查询结果-{}", JSONObject.toJSONString(fclist));
            fList = new ArrayList<>(fzMap.values());
            List<FinanceCountVO> finalFList = fList;
            listTree = fList.stream().filter(x -> x.getParentId() == 0)
                    .map(e -> {
                        e.setChildren(getChildList(e, finalFList));return e;
                    }) .collect(Collectors.toList());
            // logger.info("构造树形结果-{}", JSONObject.toJSONString(listTree));
        }else {
            listTree = fclist;
        }
        //logger.info("查询结果-{}", JSONObject.toJSONString(fList));
        if (Boolean.TRUE.equals(flag)){
            page.setRecords(fList);
            return page;
        }
        if (CollectionUtils.isNotEmpty(listTree)){
            page.setTotal(listTree.size());
            listTree = PageUtil.listToPage(listTree, pageNumber, pageSize);
        }
        page.setRecords(listTree);
        return page;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    private Long getOrgType(Long parentId,Map<Long,OrgVO> orgVOMap) {
        Integer orgType = orgVOMap.get(parentId).getOrgType();
        if (orgType == 1){
            return 0L;
        }
        if (orgType == 2 || orgType == 3){
            return parentId;
        }
        if (orgType == 4){
            getOrgType(orgVOMap.get(parentId).getParentId(),orgVOMap);
        }
        return parentId;
    }

    private List<FinanceCountVO> getChildList(FinanceCountVO vo, List<FinanceCountVO> list) {
        List<FinanceCountVO> children = list.stream().filter(x -> {
            return Objects.equals(x.getParentId(), vo.getOrgId());
        }).map(x -> {
            x.setChildren(getChildList(x, list));
            return x;
        }).collect(Collectors.toList());
        return children;
    }

    @Override
    public IPage<ProjectInOutVO> proPageList(Map<String, Object> params) {
        IPage<ProjectInOutVO> page = new Page<>();
        Integer pageNumber = Integer.valueOf(String.valueOf(params.get("pageIndex")));
        Integer pageSize = Integer.valueOf(String.valueOf(params.get("pageSize")));
        page.setCurrent(pageNumber);
        page.setSize(pageSize);

        String projectStatus = null;
        String dateIn = null;
        if (params.containsKey("range") && ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(String.valueOf(params.get("range")))){// 在建
            projectStatus = "1";
        }
        if (params.containsKey("dateIn") && ProjectSurveyEnum.THISYEAR.getCode().equals(String.valueOf(params.get("dateIn")))){// 今年
            dateIn = EJCDateUtil.getYear() + "";
        }
        List<ProjectInOutVO> projectList = new ArrayList<>();
        List<Long> projectIds = new ArrayList<>();
        Long orgId = null;
        if(params.containsKey("orgId")){
            orgId = Long.valueOf(String.valueOf(params.get("orgId")));
        }
        List<ProjectPoolSetVO> list = this.queryProjectPoolList(projectStatus, dateIn, orgId);
        if (CollectionUtils.isNotEmpty(list)){
            page.setTotal(list.size());
            list = PageUtil.listToPage(list, pageNumber, pageSize);
            projectIds = list.stream().map(ProjectPoolSetVO:: getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list)){
                for (ProjectPoolSetVO project : list) {
                    ProjectInOutVO vo = new ProjectInOutVO();
                    vo.setId(project.getId());
                    vo.setProjectName(project.getName());
                    vo.setProjectDepartmentId(project.getProjectDepartmentId());
                    if(StringUtils.isNotEmpty(project.getProjectStatus())){
                        vo.setProjectState(ProjectStatusEnum.getEnumByCode(project.getProjectStatus()).getName());// 项目状态：1、在建 2、项目中止 3、竣工 4、保修 5、 其他
                    } else {
                        vo.setProjectState(null);
                    }
                    if(StringUtils.isNotEmpty(project.getDevType())){
                        vo.setProjectType(DevTypeEnum.getEnumByCode(project.getDevType()).getName());// 实施方式:1、自营；2、联营
                    } else {
                        vo.setProjectType(null);
                    }
                    vo.setEngineeringType(project.getEngineeringTypeId());
                    vo.setEngineeringTypeName(this.getDefDocById(project.getEngineeringTypeId())!=null?this.getDefDocById(project.getEngineeringTypeId()).getName():project.getEngineeringTypeId().toString());
                    projectList.add(vo);
                }
            }
        }
        if(CollectionUtils.isEmpty(projectIds)){
            return new Page<>();
        }

        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));

        ExecutorService threadPool = Executors.newFixedThreadPool(9);

        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        param1.getParams().put("sourceType", new Parameter(QueryParam.EQ, ContractTypeEnum.施工合同.getTypeCode()));
        QueryParam param3 = Utils.deepCopy(param);// 深拷贝
        param3.getParams().put("sourceType", new Parameter(QueryParam.EQ, SettleSourceTypeEnum.对甲报量.getCode()));
        QueryParam param4 = Utils.deepCopy(param);// 深拷贝
        param4.getParams().put("contractProperty", new Parameter(QueryParam.EQ, ContractPropertyEnum.支出合同.getPropertyCode()));
        QueryParam param5 = Utils.deepCopy(param);// 深拷贝
        param5.getParams().put("settleProperty", new Parameter(QueryParam.EQ, "0"));// 支出
        //param5.getParams().put("sourceType", new Parameter(QueryParam.NE, SettleSourceTypeEnum.诉讼费结算.getCode()));
        CommonResponse<ParamRegisterSetVO> paramResponse = paramConfigApi.getByCode(PROJECT_SETTLE_RANGE_PARAM);
        if (!paramResponse.isSuccess() || paramResponse.getData() == null) {
            throw new BusinessException("获取项目结算查询结算单范围系统参数请求失败，失败原因：" + paramResponse.getMsg());
        }
        String valueData = paramResponse.getData().getValueData();
        if (valueData.contains(SettleSourceTypeEnum.诉讼费结算.getCode())){
            valueData = valueData.replace(","+SettleSourceTypeEnum.诉讼费结算.getCode(),"");
        }

        QueryParam webParam = Utils.deepCopy(param);// 深拷贝
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效

        QueryParam param2 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param6 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param7 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param8 = Utils.deepCopy(webParam);// 深拷贝

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, contractService);// 施工合同
        Future<JSONArray> future3 = ListCallable.excute(threadPool, param3, settleService);// 对甲报量
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param4, contractService);// 支出合同
        Future<JSONArray> future5 = ListCallable.excute(threadPool, param5, settleService);// 累计结算
        Future<JSONArray> future2 = ListCallable.excute(threadPool, BASE_HOST + "ejc-proincome-web/budget/queryList", param2);// 收入预算
        Future<JSONArray> future6 = ListCallable.excute(threadPool, BASE_HOST + "ejc-targetcost-web/duty/queryList", param6);// 目标责任成本
        Future<JSONArray> future7 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/paymentRegister/queryList", param7);// 付款登记
        Future<JSONArray> future8 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/receiptRegister/queryList", param8);// 收款登记

        List<ContractPoolEntity> contractList = new ArrayList<>();// 施工合同
        List<SettlePoolEntity> quoteList = new ArrayList<>();// 对甲报量
        List<ContractPoolEntity> outContractList = new ArrayList<>();// 支出合同
        List<SettlePoolEntity> settleList = new ArrayList<>();// 累计结算
        JSONArray budgetList = new JSONArray();// 收入预算
        JSONArray targetList = new JSONArray();// 目标责任成本
        JSONArray paymentList = new JSONArray();// 付款登记
        JSONArray receiptList = new JSONArray();// 收款登记
        try {
            contractList = JSONObject.parseArray(future1.get().toJSONString(), ContractPoolEntity.class);
            quoteList = JSONObject.parseArray(future3.get().toJSONString(), SettlePoolEntity.class);
            outContractList = JSONObject.parseArray(future4.get().toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray(future5.get().toJSONString(), SettlePoolEntity.class);
            budgetList = future2.get();
            targetList = future6.get();
            paymentList = future7.get();
            receiptList = future8.get();
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        // 查询项目对应累计履约金额
        Map<Long, BigDecimal> performanceMap = this.getPerformProjectMap(projectIds);

        for(ProjectInOutVO vo : projectList){
            // 合同池 施工合同 合同总金额 之和
            BigDecimal inContractMoney = contractList.stream().filter(x -> x.getContractTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 收入合同金额
            BigDecimal totalQuoteMoney = quoteList.stream().filter(x -> x.getCurTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 批复金额
            // 收款登记 本次收款 之和
            BigDecimal totalReceiveMoney = receiptList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("sumReceivedMny") != null &&
                    vo.getId().equals(x.getLong("projectId")))
                    .map(x -> x.getBigDecimal("sumReceivedMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计收款
            BigDecimal outContractMoney = outContractList.stream().filter(x -> x.getContractTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 支出合同金额
            // 查询项目对应累计履约金额
            BigDecimal performanceMoney = performanceMap.get(vo.getId());// 累计履约金额
            BigDecimal totalSettleMoney = settleList.stream().filter(x -> x.getCurTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计结算金额
            // 付款登记 本次付款 之和
            BigDecimal totalOutMoney = paymentList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("payMny") != null &&
                    vo.getId().equals(x.getLong("projectId")))
                    .map(x -> x.getBigDecimal("payMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计付款

            // 合同池 施工合同 二次经营批复金额(含税) 之和
            BigDecimal claimMoney = contractList.stream().filter(x -> x.getTotalTeplyTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(ContractPoolEntity::getTotalTeplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 变更签证索赔
            // 施工合同 + 变更签证索赔
            BigDecimal changeCostMoney = ComputeUtil.safeAdd(inContractMoney, claimMoney);// 变更后工程造价
            // 项目预算书 金额 之和
            BigDecimal budgetMoney = budgetList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("budgetTaxMny") != null &&
                    vo.getId().equals(x.getJSONObject("projectId").getLong("id")))
                    .map(x -> x.getBigDecimal("budgetTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 收入预算
            // 目标责任成本 金额 之和
            BigDecimal targetMoney = targetList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("taxMny") != null &&
                    vo.getId().equals(x.getJSONObject("projectId").getLong("id")))
                    .map(x -> x.getBigDecimal("taxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 目标责任成本

            vo.setInContractMoney(inContractMoney);// 施工合同
            vo.setClaimMoney(claimMoney);// 变更签证索赔
            vo.setChangeCostMoney(changeCostMoney);// 变更后工程造价
            vo.setBudgetMoney(budgetMoney);// 收入预算
            vo.setTotalQuoteMoney(totalQuoteMoney);// 批复金额
            vo.setTotalReceiveMoney(totalReceiveMoney);// 收款金额
            vo.setTargetMoney(targetMoney);// 目标责任成本
            vo.setOutContractMoney(outContractMoney);// 合同金额
            vo.setPerformanceMoney(performanceMoney);// 履约金额
            vo.setTotalSettleMoney(totalSettleMoney);// 结算金额
            vo.setTotalOutMoney(totalOutMoney);// 付款金额
        }
        page.setRecords(projectList);
        return page;
    }

    @Override
    public IPage<ProjectInOutVO> proPageOrgList(Map<String, Object> params) {
        IPage<ProjectInOutVO> page = new Page<>();
        Integer pageNumber = Integer.valueOf(String.valueOf(params.get("pageIndex")));
        Integer pageSize = Integer.valueOf(String.valueOf(params.get("pageSize")));
        page.setCurrent(pageNumber);
        page.setSize(pageSize);

        String projectStatus = null;
        String dateIn = null;
        if (params.containsKey("range") && ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(String.valueOf(params.get("range")))){// 在建
            projectStatus = "1";
        }
        if (params.containsKey("dateIn") && ProjectSurveyEnum.THISYEAR.getCode().equals(String.valueOf(params.get("dateIn")))){// 今年
            dateIn = EJCDateUtil.getYear() + "";
        }
        List<ProjectInOutVO> projectList = new ArrayList<>();
        List<Long> projectIds = new ArrayList<>();
        List<Long> ordIdsList = new ArrayList<>();
        Long orgId = null;
        Long projectId = null;
        if(params.containsKey("orgId")){
            orgId = Long.valueOf(String.valueOf(params.get("orgId")));
        }
        logger.info("入参params-{}", params);
        if(params.containsKey("projectId")){
            projectId = Long.valueOf(String.valueOf(params.get("projectId")));
            logger.info("projectId-{}", projectId);
        }
        List<ProjectPoolSetVO> listProject;
        if (null == projectId){
            listProject = this.queryProjectPoolList(projectStatus, dateIn, orgId);
            logger.info("查询到项目池的数据-{}", JSONObject.toJSONString(listProject));
        }else {
            listProject = this.queryProjectPoolByProjectId(projectId);
            logger.info("通过项目id查询到项目池的数据-{}", JSONObject.toJSONString(listProject));
        }
        List<ProjectPoolSetTreeVO> list = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(listProject)){
            // add by sunyj  展示数据按照父子项目改造
            List<ProjectPoolSetTreeVO> listTree = BeanMapper.mapList(listProject,ProjectPoolSetTreeVO.class);
            list = TreeNodeBUtil.buildTree(listTree);// 主子项目的返回数据
            page.setTotal(list.size());
            list = PageUtil.listToPage(list, pageNumber, pageSize);
            logger.info("转为主子项目后数据-{}", JSONObject.toJSONString(list));
//            projectIds = list.stream().map(ProjectPoolSetTreeVO:: getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list)){
                for (ProjectPoolSetTreeVO project : list) {
                    ProjectInOutVO vo = new ProjectInOutVO();
                    projectIds.add(project.getId());
                    ordIdsList.add(project.getProjectDepartmentId());
                    vo.setId(project.getId());
                    vo.setProjectName(project.getName());
                    vo.setParentProjectId(project.getParentProjectId());
                    vo.setParentProjectName(project.getParentProjectName());
                    vo.setProjectDepartmentId(project.getProjectDepartmentId());
                    if(StringUtils.isNotEmpty(project.getBusinessStatus())){
                        vo.setBusinessStatus(BusinessStatusEnum.getEnumByCode(project.getBusinessStatus()).getName());// 业务状态：1、开工准备 2、正式开工 3、停工 4、复工5、完工6、竣工验收 7、成本关门 8、决算中 9、已决算 10、资料未归档 11、资料已归档 12、保修中 13、保修结束 14、开账 15、资金冻结 16、资金恢复 17、已销账
                    } else {
                        vo.setBusinessStatus(null);
                    }
                    if(StringUtils.isNotEmpty(project.getDevType())){
                        vo.setProjectType(DevTypeEnum.getEnumByCode(project.getDevType()).getName());// 实施方式:1、自营；2、联营
                    } else {
                        vo.setProjectType(null);
                    }
                    vo.setEngineeringType(project.getEngineeringTypeId());
                    vo.setEngineeringTypeName(this.getDefDocById(project.getEngineeringTypeId()).getName());
                    vo.setOrgId(project.getOrgId());
                    vo.setOrgName(project.getOrgName());
                    projectList.add(vo);
                    if(null!=project.getChildren()){
                        List<ProjectPoolSetTreeVO> children = BeanMapper.mapList(project.getChildren(),ProjectPoolSetTreeVO.class);
                        children.forEach(e->{
                            ProjectInOutVO voChildren = new ProjectInOutVO();
                            projectIds.add(e.getId());
                            voChildren.setId(e.getId());
                            ordIdsList.add(e.getProjectDepartmentId());
                            voChildren.setProjectName(e.getName());
                            voChildren.setParentProjectId(e.getParentProjectId());
                            voChildren.setParentProjectName(e.getParentProjectName());
                            voChildren.setProjectDepartmentId(e.getProjectDepartmentId());
                            if(StringUtils.isNotEmpty(e.getBusinessStatus())){
                                voChildren.setBusinessStatus(BusinessStatusEnum.getEnumByCode(e.getBusinessStatus()).getName());// 业务状态：1、开工准备 2、正式开工 3、停工 4、复工5、完工6、竣工验收 7、成本关门 8、决算中 9、已决算 10、资料未归档 11、资料已归档 12、保修中 13、保修结束 14、开账 15、资金冻结 16、资金恢复 17、已销账
                            } else {
                                voChildren.setBusinessStatus(null);
                            }
                            if(StringUtils.isNotEmpty(e.getDevType())){
                                voChildren.setProjectType(DevTypeEnum.getEnumByCode(e.getDevType()).getName());// 实施方式:1、自营；2、联营
                            } else {
                                voChildren.setProjectType(null);
                            }
                            voChildren.setEngineeringType(e.getEngineeringTypeId());
                            voChildren.setEngineeringTypeName(this.getDefDocById(e.getEngineeringTypeId()).getName());
                            voChildren.setOrgId(e.getOrgId());
                            voChildren.setOrgName(e.getOrgName());
                            projectList.add(voChildren);
                        });
                    }

                }
            }
            logger.info("主子项目平铺后-{}", JSONObject.toJSONString(projectList));
        }
        if(CollectionUtils.isEmpty(projectIds)){
            return new Page<>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));

        ExecutorService threadPool = Executors.newFixedThreadPool(11);

        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        param1.getParams().put("sourceType", new Parameter(QueryParam.EQ, ContractTypeEnum.施工合同.getTypeCode()));
        QueryParam param3 = Utils.deepCopy(param);// 深拷贝
        param3.getParams().put("sourceType", new Parameter(QueryParam.EQ, SettleSourceTypeEnum.对甲报量.getCode()));
        QueryParam param4 = Utils.deepCopy(param);// 深拷贝
        param4.getParams().put("contractProperty", new Parameter(QueryParam.EQ, ContractPropertyEnum.支出合同.getPropertyCode()));
        QueryParam param5 = Utils.deepCopy(param);// 深拷贝
        param5.getParams().put("settleProperty", new Parameter(QueryParam.EQ, "0"));// 支出
        //param5.getParams().put("sourceType", new Parameter(QueryParam.NE, SettleSourceTypeEnum.诉讼费结算.getCode()));
        CommonResponse<ParamRegisterSetVO> paramResponse = paramConfigApi.getByCode(PROJECT_SETTLE_RANGE_PARAM);
        if (!paramResponse.isSuccess() || paramResponse.getData() == null) {
            throw new BusinessException("获取项目结算查询结算单范围系统参数请求失败，失败原因：" + paramResponse.getMsg());
        }
        String valueData = paramResponse.getData().getValueData();
        if (valueData.contains(SettleSourceTypeEnum.诉讼费结算.getCode())){
            valueData = valueData.replace(","+SettleSourceTypeEnum.诉讼费结算.getCode(),"");
        }
        Assert.hasText(valueData, "获取的项目结算查询结算单范围不能为空!");
        param5.getParams().put("sourceType", new Parameter(QueryParam.IN, valueData));

        QueryParam webParam = Utils.deepCopy(param);// 深拷贝
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效

        QueryParam param2 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param6 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param7 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param8 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param9 = Utils.deepCopy(webParam);// 深拷贝
        QueryParam param10 = Utils.deepCopy(webParam);// 深拷贝
        param10.getParams().put("isEstimation",new Parameter(QueryParam.IN,0));

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, contractService);// 施工合同
        Future<JSONArray> future3 = ListCallable.excute(threadPool, param3, settleService);// 对甲报量
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param4, contractService);// 支出合同
        Future<JSONArray> future5 = ListCallable.excute(threadPool, param5, settleService);// 累计结算
        Future<JSONArray> future2 = ListCallable.excute(threadPool, BASE_HOST + "ejc-proincome-web/budget/queryList", param2);// 收入预算
        Future<JSONArray> future6 = ListCallable.excute(threadPool, BASE_HOST + "ejc-targetcost-web/duty/queryList", param6);// 目标责任成本
        Future<JSONArray> future7 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/paymentRegister/queryList", param7);// 付款登记
        Future<JSONArray> future8 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/receiptRegister/queryList", param8);// 收款登记
        //Future<JSONArray> future9 = ListCallable.excute(threadPool, BASE_HOST + "ejc-procost-web/handshare/queryList", param9);// 已支付间接金额
        Future<JSONArray> future10 = ListCallable.excute(threadPool, BASE_HOST + "ejc-proincome-web/contractRegister/queryList", param10);// 施工合同

        List<ContractPoolEntity> contractList = new ArrayList<>();// 施工合同
        List<SettlePoolEntity> quoteList = new ArrayList<>();// 对甲报量
        List<ContractPoolEntity> outContractList = new ArrayList<>();// 支出合同
        List<SettlePoolEntity> settleList = new ArrayList<>();// 累计结算
        JSONArray budgetList = new JSONArray();// 收入预算
        JSONArray targetList = new JSONArray();// 目标责任成本
        JSONArray paymentList = new JSONArray();// 付款登记
        JSONArray receiptList = new JSONArray();// 收款登记
//        JSONArray handShareList = new JSONArray();// 已支付间接金额
        JSONArray incomeList = new JSONArray();// 施工合同
        try {
            contractList = JSONObject.parseArray(future1.get().toJSONString(), ContractPoolEntity.class);
            quoteList = JSONObject.parseArray(future3.get().toJSONString(), SettlePoolEntity.class);
            outContractList = JSONObject.parseArray(future4.get().toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray(future5.get().toJSONString(), SettlePoolEntity.class);
            budgetList = future2.get();
            targetList = future6.get();
            paymentList = future7.get();
            receiptList = future8.get();
//            handShareList = future9.get();
            incomeList = future10.get();
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
//        List<Long> ordIdsList = list.stream().map(ProjectPoolSetTreeVO::getProjectDepartmentId).collect(Collectors.toList());
        OutputValDTO dto = new OutputValDTO();
        dto.setYear(0);
        dto.setOrgIds(ordIdsList);//产值金额
        CommonResponse<HashMap<Long,BigDecimal>> outPut = outputValueApi.getSumByOrgIds(dto);
        HashMap<Long,BigDecimal> outPutMap = new HashMap<>();
        if(outPut.isSuccess()){
            outPutMap = outPut.getData();
        } else {
            logger.error(outPut.getMsg());
        }
        List<Long> targetIds = new ArrayList<>();
        for(int i = 0; i < targetList.size(); i++) {
            JSONObject obj = targetList.getJSONObject(i);
            targetIds.add(obj.getLong("id"));
        }
        List<TargetCostDetailVO> targetCost = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(targetIds)){
            targetCost = mapper.queryTargetCostDetailByIds(targetIds);
        }
        List<TargetCostDetailVO>  directList = targetCost.stream().filter(x->Integer.valueOf(x.getTreeIndex()) < 6).collect(Collectors.toList());
        List<TargetCostDetailVO>  indirectList = targetCost.stream().filter(x->Integer.valueOf(x.getTreeIndex()) == 6).collect(Collectors.toList());
        List<TargetCostDetailVO>  paidIndirectList = mapper.queryProCostDetailByProjectIds(projectIds);
        // 查询项目对应累计履约金额
        Map<Long, BigDecimal> performanceMap = this.getPerformProjectMap(projectIds);
        for(ProjectInOutVO vo : projectList){
            // 合同池 施工合同 合同总金额 之和
            BigDecimal inContractMoney = contractList.stream().filter(x -> x.getBaseTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(ContractPoolEntity::getBaseTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 收入合同金额
            BigDecimal bgIncomeMoney = contractList.stream().filter(x -> x.getContractTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 变更后合同金额
            BigDecimal totalQuoteMoney = quoteList.stream().filter(x -> x.getCurTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 批复金额
            // 收款登记 本次收款 之和
            BigDecimal totalReceiveMoney = receiptList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("sumReceivedMny") != null &&
                    vo.getId().equals(x.getLong("projectId")))
                    .map(x -> x.getBigDecimal("sumReceivedMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计收款
            BigDecimal outContractMoney = outContractList.stream().filter(x -> x.getContractTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 支出合同金额
            // 查询项目对应累计履约金额
            BigDecimal performanceMoney = performanceMap.get(vo.getId());// 累计履约金额
            BigDecimal productionMoney = outPutMap.get(vo.getProjectDepartmentId())!=null?outPutMap.get(vo.getProjectDepartmentId()):BigDecimal.ZERO;//产值金额
            BigDecimal handShareMoney = paidIndirectList.stream().filter(x -> x.getMny() != null && vo.getId().equals(x.getProjectId()) && x.getSubjectCode().startsWith("07"))
                    .map(TargetCostDetailVO::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 已付间接费 --税金
            BigDecimal paidIndirectMny = paidIndirectList.stream().filter(x -> x.getMny() != null && vo.getId().equals(x.getProjectId()) && x.getSubjectCode().startsWith("06"))
                    .map(TargetCostDetailVO::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal directMny = directList.stream().filter(x -> x.getTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(TargetCostDetailVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 直接费用
            BigDecimal indirectMny = indirectList.stream().filter(x -> x.getTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(TargetCostDetailVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 间接费用
            BigDecimal totalSettleMoney = settleList.stream().filter(x -> x.getCurTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计结算金额
            // 付款登记 本次付款 之和
            BigDecimal totalOutMoney = paymentList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("payMny") != null &&
                    vo.getId().equals(x.getLong("projectId")))
                    .map(x -> x.getBigDecimal("payMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计付款

            // 合同池 施工合同 二次经营批复金额(含税) 之和
            BigDecimal claimMoney = contractList.stream().filter(x -> x.getTotalTeplyTaxMny() != null &&
                    vo.getId().equals(x.getProjectId()))
                    .map(ContractPoolEntity::getTotalTeplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 变更签证索赔
            // 工程造价总金额
//            BigDecimal changeCostMoney = incomeList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("costChangeTotalTaxMny") != null &&
//                    vo.getId().equals(x.getJSONObject("projectId").getLong("id")))
//                    .map(x -> x.getBigDecimal("costChangeTotalTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 工程造价总金额
            BigDecimal contractTaxMny = incomeList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("contractTaxMny") != null &&
                    vo.getId().equals(x.getJSONObject("projectId").getLong("id")))
                    .map(x -> x.getBigDecimal("contractTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 工程造价总金额
            BigDecimal totalCostAdjustTaxMny = incomeList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("totalCostAdjustTaxMny") != null &&
                    vo.getId().equals(x.getJSONObject("projectId").getLong("id")))
                    .map(x -> x.getBigDecimal("totalCostAdjustTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 工程造价总金额
            //BigDecimal changeCostMoney = ComputeUtil.safeAdd(bgIncomeMoney, claimMoney);// 变更后工程造价
            // 项目预算书 金额 之和
            BigDecimal budgetMoney = budgetList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("budgetTaxMny") != null &&
                    vo.getId().equals(x.getJSONObject("projectId").getLong("id")))
                    .map(x -> x.getBigDecimal("budgetTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 收入预算
            // 目标责任成本 金额 之和
            BigDecimal targetMoney = targetList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("taxMny") != null &&
                    vo.getId().equals(x.getJSONObject("projectId").getLong("id")))
                    .map(x -> x.getBigDecimal("taxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 目标责任成本

            vo.setInContractMoney(inContractMoney);
            vo.setClaimMoney(claimMoney);// 变更签证索赔
            vo.setBgIncomeMoney(bgIncomeMoney);// 变更后施工合同
            vo.setChangeCostMoney(ComputeUtil.safeAdd(contractTaxMny,totalCostAdjustTaxMny));//工程造价金额
            vo.setBudgetMoney(budgetMoney);// 收入预算
            vo.setTotalQuoteMoney(totalQuoteMoney);// 批复金额
            vo.setProductionMoney(productionMoney);
            vo.setPaidIndirectMny(paidIndirectMny);
            vo.setDirectMny(directMny);
            vo.setIndirectMny(indirectMny);
            vo.setTotalReceiveMoney(totalReceiveMoney);// 收款金额
            vo.setTargetMoney(targetMoney);// 目标责任成本
            vo.setOutContractMoney(outContractMoney);// 合同金额
            vo.setPerformanceMoney(performanceMoney);// 履约金额
            vo.setTotalSettleMoney(totalSettleMoney);// 结算金额
            vo.setTotalOutMoney(totalOutMoney);// 付款金额
            vo.setHandShareMoney(handShareMoney);//间接费税金
        }
        //将子项目金额 汇总到主项目金额上
        List<ProjectInOutVO> projectListRes = TreeNodeBUtil.buildTree(projectList);
        if(CollectionUtils.isNotEmpty(projectListRes)){
            for (ProjectInOutVO project : projectListRes) {
                if(null!=project.getChildren()){
                    //说明有子项目，需要将子项目的金额合计到主项目上
                    List<ProjectInOutVO> children = BeanMapper.mapList(project.getChildren(),ProjectInOutVO.class);
                    BigDecimal inContractMoney = children.stream().filter(item -> null != item.getInContractMoney()).map(ProjectInOutVO::getInContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 施工合同
                    BigDecimal hinContractMoney = project.getInContractMoney()==null?BigDecimal.ZERO:project.getInContractMoney();
                    project.setInContractMoney(hinContractMoney.add(inContractMoney==null?BigDecimal.ZERO:inContractMoney));

                    BigDecimal claimMoney = children.stream().filter(item -> null != item.getClaimMoney()).map(ProjectInOutVO::getClaimMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 变更签证索赔
                    BigDecimal hclaimMoney = project.getClaimMoney()==null?BigDecimal.ZERO:project.getClaimMoney();
                    project.setClaimMoney(hclaimMoney.add(claimMoney==null?BigDecimal.ZERO:claimMoney));

                    BigDecimal changeCostMoney = children.stream().filter(item -> null != item.getChangeCostMoney()).map(ProjectInOutVO::getChangeCostMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 变更后工程造价
                    BigDecimal hchangeCostMoney = project.getChangeCostMoney()==null?BigDecimal.ZERO:project.getChangeCostMoney();
                    project.setChangeCostMoney(hchangeCostMoney.add(changeCostMoney==null?BigDecimal.ZERO:changeCostMoney));

                    BigDecimal budgetMoney = children.stream().filter(item -> null != item.getBudgetMoney()).map(ProjectInOutVO::getBudgetMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 收入预算
                    BigDecimal hbudgetMoney = project.getBudgetMoney()==null?BigDecimal.ZERO:project.getBudgetMoney();
                    project.setBudgetMoney(hbudgetMoney.add(budgetMoney==null?BigDecimal.ZERO:budgetMoney));

                    BigDecimal totalQuoteMoney = children.stream().filter(item -> null != item.getTotalQuoteMoney()).map(ProjectInOutVO::getTotalQuoteMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 批复金额
                    BigDecimal htotalQuoteMoney = project.getTotalQuoteMoney()==null?BigDecimal.ZERO:project.getTotalQuoteMoney();
                    project.setTotalQuoteMoney(htotalQuoteMoney.add(totalQuoteMoney==null?BigDecimal.ZERO:totalQuoteMoney));

                    BigDecimal totalReceiveMoney = children.stream().filter(item -> null != item.getTotalReceiveMoney()).map(ProjectInOutVO::getTotalReceiveMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 收款金额
                    BigDecimal htotalReceiveMoney = project.getTotalReceiveMoney()==null?BigDecimal.ZERO:project.getTotalReceiveMoney();
                    project.setTotalReceiveMoney(htotalReceiveMoney.add(totalReceiveMoney==null?BigDecimal.ZERO:totalReceiveMoney));

                    BigDecimal targetMoney = children.stream().filter(item -> null != item.getTargetMoney()).map(ProjectInOutVO::getTargetMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 目标责任成本
                    BigDecimal htargetMoney = project.getTargetMoney()==null?BigDecimal.ZERO:project.getTargetMoney();
                    project.setTargetMoney(htargetMoney.add(targetMoney==null?BigDecimal.ZERO:targetMoney));

                    BigDecimal outContractMoney = children.stream().filter(item -> null != item.getOutContractMoney()).map(ProjectInOutVO::getOutContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 合同金额
                    BigDecimal houtContractMoney = project.getOutContractMoney()==null?BigDecimal.ZERO:project.getOutContractMoney();
                    project.setOutContractMoney(houtContractMoney.add(outContractMoney==null?BigDecimal.ZERO:outContractMoney));

                    BigDecimal performanceMoney = children.stream().filter(item -> null != item.getPerformanceMoney()).map(ProjectInOutVO::getPerformanceMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 履约金额
                    BigDecimal hperformanceMoney = project.getPerformanceMoney()==null?BigDecimal.ZERO:project.getPerformanceMoney();
                    project.setPerformanceMoney(hperformanceMoney.add(performanceMoney==null?BigDecimal.ZERO:performanceMoney));

                    BigDecimal totalSettleMoney = children.stream().filter(item -> null != item.getTotalSettleMoney()).map(ProjectInOutVO::getTotalSettleMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 结算金额
                    BigDecimal htotalSettleMoney = project.getTotalSettleMoney()==null?BigDecimal.ZERO:project.getTotalSettleMoney();
                    project.setTotalSettleMoney(htotalSettleMoney.add(totalSettleMoney==null?BigDecimal.ZERO:totalSettleMoney));

                    BigDecimal totalOutMoney = children.stream().filter(item -> null != item.getTotalOutMoney()).map(ProjectInOutVO::getTotalOutMoney).reduce(BigDecimal.ZERO, BigDecimal::add);// 付款金额
                    BigDecimal htotalOutMoney = project.getTotalOutMoney()==null?BigDecimal.ZERO:project.getTotalOutMoney();
                    project.setTotalOutMoney(htotalOutMoney.add(totalOutMoney==null?BigDecimal.ZERO:totalOutMoney));

                    BigDecimal productionMoney = children.stream().filter(item -> null != item.getProductionMoney()).map(ProjectInOutVO::getProductionMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal hproductionMoney = project.getProductionMoney()==null?BigDecimal.ZERO:project.getProductionMoney();
                    project.setProductionMoney(hproductionMoney.add(productionMoney==null?BigDecimal.ZERO:productionMoney));

                    BigDecimal directMny = children.stream().filter(item -> null != item.getDirectMny()).map(ProjectInOutVO::getDirectMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 直接费用
                    BigDecimal hdirectMny = project.getDirectMny()==null?BigDecimal.ZERO:project.getDirectMny();
                    project.setDirectMny(hdirectMny.add(directMny==null?BigDecimal.ZERO:directMny));

                    BigDecimal indirectMny = children.stream().filter(item -> null != item.getIndirectMny()).map(ProjectInOutVO::getIndirectMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 间接费用
                    BigDecimal hindirectMny = project.getIndirectMny()==null?BigDecimal.ZERO:project.getIndirectMny();
                    project.setIndirectMny(hindirectMny.add(indirectMny==null?BigDecimal.ZERO:indirectMny));

                    BigDecimal paidIndirectMny = children.stream().filter(item -> null != item.getPaidIndirectMny()).map(ProjectInOutVO::getPaidIndirectMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 已支间接费用
                    BigDecimal hpaidIndirectMny = project.getPaidIndirectMny()==null?BigDecimal.ZERO:project.getPaidIndirectMny();
                    project.setPaidIndirectMny(hpaidIndirectMny.add(paidIndirectMny==null?BigDecimal.ZERO:paidIndirectMny));

                    BigDecimal bgIncomeMoney = children.stream().filter(item -> null != item.getBgIncomeMoney()).map(ProjectInOutVO::getBgIncomeMoney).reduce(BigDecimal.ZERO, BigDecimal::add); //变更后总金额
                    BigDecimal hbgIncomeMoney = project.getBgIncomeMoney()==null?BigDecimal.ZERO:project.getBgIncomeMoney();
                    project.setBgIncomeMoney(hbgIncomeMoney.add(bgIncomeMoney==null?BigDecimal.ZERO:bgIncomeMoney));

                    BigDecimal handShareMoney = children.stream().filter(item -> null != item.getHandShareMoney()).map(ProjectInOutVO::getHandShareMoney).reduce(BigDecimal.ZERO, BigDecimal::add); //变更后总金额
                    BigDecimal hhandShareMoney = project.getHandShareMoney()==null?BigDecimal.ZERO:project.getHandShareMoney();
                    project.setHandShareMoney(hhandShareMoney.add(handShareMoney==null?BigDecimal.ZERO:handShareMoney));
                }
         }
        }
        page.setRecords(projectListRes);
        return page;
    }

    private List<ProjectPoolSetVO> queryProjectPoolByProjectId(Long projectId) {
        CommonResponse<JSONArray> resp = projectSetApi.queryProjectPoolById(projectId);
        List<ProjectPoolSetVO> result = new ArrayList<>();
        if(resp.isSuccess()){
            result = JSONArray.parseArray(JSONObject.toJSONString(resp.getData()), ProjectPoolSetVO.class);
        } else {
            logger.error(resp.getMsg());
        }
        return result;
    }

    /**
     * 根据id查询自定义档案
     * @param id
     * @return
     */
    public DefdocDetailVO getDefDocById(Long id){
        if(id == null) return new DefdocDetailVO();
        CommonResponse<DefdocDetailVO> resp = defdocApi.getDefDocById(id);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        return resp.getData() != null ? resp.getData() : new DefdocDetailVO();
    }

    /**
     * @param dateIn
     * @description: 公司领导门户资金使用
     * * "contract":新签合同额
     * * "production":产值统计1
     * * "partAReport":甲方报量1
     * * "backMoney":回款 = 累计收款1
     * * "openInvince":"开票
     * * "performance":履约
     * * "jiesuanjine":结算金额1
     * * "receiveInvince":收票金额
     * * "payMoney":"付款金额1
     * * "monthData":['2021-09', '2021-10', '2021-11', '2021-12', '2022-01', '2022-02', '2022-03']
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.income.vo.FinanceUseVO>
     * @author yqls
     * @date: 2022/4/28
     */
    @Override
    public CommonResponse<FinanceUseResVO> queryFinanceUse(String dateIn, Long orgId) {
        String startMonth = null;
        String endMonth = null;
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getYear() + "-01" + "-01";
            endMonth = EJCDateUtil.getMonth(0) + "-31";
        } else if (ProjectSurveyEnum.NEAR3MON.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth(-2) + "-01";
            endMonth = EJCDateUtil.getMonth(0) + "-31";
        } else if (ProjectSurveyEnum.NEAR6MON.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth(-5) + "-01";
            endMonth = EJCDateUtil.getMonth(0) + "-31";
        } else {
            startMonth = EJCDateUtil.getLastYear() + "-01" + "-01";
            endMonth = EJCDateUtil.getLastYear() + "-12" + "-31";
        }

        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));

        ExecutorService threadPool = Executors.newFixedThreadPool(7);

        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        param1.getParams().put("sourceType", new Parameter(QueryParam.EQ, ContractTypeEnum.施工合同.getTypeCode()));
        param1.getParams().put("signDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));
        QueryParam param2 = Utils.deepCopy(param);// 深拷贝
        param2.getParams().put("sourceType", new Parameter(QueryParam.EQ, SettleSourceTypeEnum.产值报量.getCode()));
        param2.getParams().put("settleDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));
        QueryParam param3 = Utils.deepCopy(param);// 深拷贝
        param3.getParams().put("sourceType", new Parameter(QueryParam.EQ, SettleSourceTypeEnum.对甲报量.getCode()));
        param3.getParams().put("settleDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));
        QueryParam param5 = Utils.deepCopy(param);// 深拷贝
        param5.getParams().put("settleProperty", new Parameter(QueryParam.EQ, "0"));// 支出
        param5.getParams().put("sourceType", new Parameter(QueryParam.NE, SettleSourceTypeEnum.诉讼费结算.getCode()));
        param5.getParams().put("settleDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));

        QueryParam webParam = Utils.deepCopy(param);// 深拷贝
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效

        QueryParam param6 = Utils.deepCopy(webParam);// 深拷贝
        param6.getParams().put("paymentDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));
        QueryParam param7 = Utils.deepCopy(webParam);// 深拷贝
        param7.getParams().put("receiptDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, contractService);// 施工合同
        Future<JSONArray> future2 = ListCallable.excute(threadPool, param2, settleService);// 产值报量
        Future<JSONArray> future3 = ListCallable.excute(threadPool, param3, settleService);// 对甲报量
        Future<JSONArray> future5 = ListCallable.excute(threadPool, param5, settleService);// 累计结算
        Future<JSONArray> future6 = ListCallable.excute(threadPool,
                BASE_HOST + "ejc-profinance-web/api/paymentApplyApi/queryActualPayGroupByMonth", param6, false);// 付款登记
        Future<JSONArray> future7 = ListCallable.excute(threadPool, BASE_HOST + "ejc-profinance-web/receiptRegister/queryList", param7);// 收款登记

        List<ContractPoolEntity> contractList = new ArrayList<>();// 施工合同
        List<SettlePoolEntity> productionList = new ArrayList<>();// 产值报量
        List<SettlePoolEntity> quoteList = new ArrayList<>();// 对甲报量
        List<SettlePoolEntity> settleList = new ArrayList<>();// 累计结算
        JSONArray paymentList = new JSONArray();// 付款登记
        JSONArray receiptList = new JSONArray();// 收款登记
        try {
            contractList = JSONObject.parseArray(future1.get().toJSONString(), ContractPoolEntity.class);
            productionList = JSONObject.parseArray(future2.get().toJSONString(), SettlePoolEntity.class);
            quoteList = JSONObject.parseArray(future3.get().toJSONString(), SettlePoolEntity.class);
            settleList = JSONObject.parseArray(future5.get().toJSONString(), SettlePoolEntity.class);
            paymentList = JSONObject.parseArray(future6.get().toJSONString());
            receiptList = future7.get();
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        // 按年月分组求和
        Map<String, BigDecimal> contractMap = contractList.stream().filter(x->x.getContractTaxMny() != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getSignDate(), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getContractTaxMny(), BigDecimal::add)));

        Map<String, BigDecimal> prodMap = productionList.stream().filter(x->x.getCurTaxMny() != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getSettleDate(), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getCurTaxMny(), BigDecimal::add)));

        Map<String, BigDecimal> quoteMap = quoteList.stream().filter(x->x.getCurTaxMny() != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getSettleDate(), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getCurTaxMny(), BigDecimal::add)));

        Map<String, BigDecimal> settleMap = settleList.stream().filter(x->x.getCurTaxMny() != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getSettleDate(), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getCurTaxMny(), BigDecimal::add)));

        // TODO 无发票池
        Map<String, BigDecimal> openInvoiceMap = new HashMap<>();
        // TODO 无发票池
        Map<String, BigDecimal> recInvoiceMap = new HashMap<>();
        // 收款登记 按照收款月份分组求和
        Map<String, BigDecimal> recMoneyMap = receiptList.stream().map(x -> ((JSONObject)x)).filter(x->x.getBigDecimal("sumReceivedMny") != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getDate("receiptDate"), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getBigDecimal("sumReceivedMny"), BigDecimal::add)));
        // 付款登记 按照付款月份分组求和
        logger.info("按月查询实付结果：{}", JSONObject.toJSONString(paymentList));
        Map<String, BigDecimal> payMap = CollectionUtils.isNotEmpty(paymentList) ? JSONObject.parseObject(JSONObject.toJSONString(paymentList.get(0)), Map.class) : new HashMap<>();

        // 按月份分组汇总累计履约金额
        Map<String, BigDecimal> performanceMap = this.getPerformMonthMap(orgIds, startMonth, endMonth);

        FinanceUseResVO resVO = new FinanceUseResVO();
        List<String> monthData = EJCDateUtil.getMonthBetween(startMonth, endMonth);
        HashMap<String, FinanceUseResSubVO> subVOMap = new HashMap<>();

        //合计字段
        List<String> keyList = Arrays.asList("production", "partAReport", "backMoney", "openInvince", "jiesuanjine",
                "receiveInvince",  "payMoney", "contract", "performance");

        for (String mon : monthData) {
            BigDecimal monVal = BigDecimal.ZERO;
            for (String key : keyList) {
                //产值
                if (key.equals(keyList.get(0))) {
                    monVal = ComputeUtil.nullToZero(prodMap.get(mon));
                }
                //甲方报量
                if (key.equals(keyList.get(1))) {
                    monVal = ComputeUtil.nullToZero(quoteMap.get(mon));
                }
                //收款
                if (key.equals(keyList.get(2))) {
                    monVal = ComputeUtil.nullToZero(recMoneyMap.get(mon));
                }
                //开票
                if (key.equals(keyList.get(3))) {
                    monVal = ComputeUtil.nullToZero(openInvoiceMap.get(mon));
                }
                //结算
                if (key.equals(keyList.get(4))) {
                    monVal = ComputeUtil.nullToZero(settleMap.get(mon));
                }
                //收票
                if (key.equals(keyList.get(5))) {
                    monVal = ComputeUtil.nullToZero(recInvoiceMap.get(mon));
                }
                //付款
                if (key.equals(keyList.get(6))) {
                    monVal = ComputeUtil.nullToZero(payMap.get(mon));
                }
                //施工
                if (key.equals(keyList.get(7))) {
                    monVal = ComputeUtil.nullToZero(contractMap.get(mon));
                }
                //履约
                if (key.equals(keyList.get(8))) {
                    monVal = ComputeUtil.nullToZero(performanceMap.get(mon));
                }

                FinanceUseResSubVO subVO = subVOMap.get(key);
                if (subVO == null) {
                    subVO = new FinanceUseResSubVO();
                    subVOMap.put(key, subVO);
                }
                subVO.setTotal(ComputeUtil.safeAdd(subVO.getTotal(), monVal));
                List<BigDecimal> monthDataList = subVO.getMonthData();
                if (monthDataList == null) {
                    monthDataList = new ArrayList<>();
                    subVO.setMonthData(monthDataList);
                }
                monthDataList.add(monVal);
            }
        }

        resVO.setMonthData(monthData);
        resVO.setProduction(subVOMap.get(keyList.get(0)));
        resVO.setPartAReport(subVOMap.get(keyList.get(1)));
        resVO.setBackMoney(subVOMap.get(keyList.get(2)));
        resVO.setOpenInvince(subVOMap.get(keyList.get(3)));
        resVO.setSettleMoney(subVOMap.get(keyList.get(4)));
        resVO.setReceiveInvince(subVOMap.get(keyList.get(5)));
        resVO.setPayMoney(subVOMap.get(keyList.get(6)));
        resVO.setContract(subVOMap.get(keyList.get(7)));
        resVO.setPerformance(subVOMap.get(keyList.get(8)));

        return CommonResponse.success("查询资金使用数据成功！", resVO);
    }

    @Override
    public CommonResponse<FinanceUseResVO> queryFinanceUseLeader(String dateIn, Long orgId) {
        String startMonth = null;
        String endMonth = null;
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getYear() + "-01" + "-01";
            endMonth = EJCDateUtil.getMonth(0) + "-31";
        } else if (ProjectSurveyEnum.NEAR3MON.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth(-2) + "-01";
            endMonth = EJCDateUtil.getMonth(0) + "-31";
        } else if (ProjectSurveyEnum.NEAR6MON.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth(-5) + "-01";
            endMonth = EJCDateUtil.getMonth(0) + "-31";
        } else {
            startMonth = EJCDateUtil.getLastYear() + "-01" + "-01";
            endMonth = EJCDateUtil.getLastYear() + "-12" + "-31";
        }

        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<Long> orgIds = orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));

        ExecutorService threadPool = Executors.newFixedThreadPool(7);

        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        param1.getParams().put("contractProperty", new Parameter(QueryParam.EQ, ContractPropertyEnum.支出合同.getPropertyCode()));
        param1.getParams().put("signDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));
        QueryParam param5 = Utils.deepCopy(param);// 深拷贝
        param5.getParams().put("settleProperty", new Parameter(QueryParam.EQ, "0"));// 支出
        param5.getParams().put("sourceType", new Parameter(QueryParam.NE, SettleSourceTypeEnum.诉讼费结算.getCode()));
        param5.getParams().put("settleDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));

        QueryParam webParam = Utils.deepCopy(param);// 深拷贝
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效

        QueryParam param6 = Utils.deepCopy(webParam);// 深拷贝
        param6.getParams().put("paymentDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, contractService);// 施工合同
        Future<JSONArray> future5 = ListCallable.excute(threadPool, param5, settleService);// 累计结算
        Future<JSONArray> future6 = ListCallable.excute(threadPool,
                BASE_HOST + "ejc-profinance-web/api/paymentApplyApi/queryActualPayGroupByMonth", param6, false);// 付款登记

        List<ContractPoolEntity> contractList = new ArrayList<>();// 支出合同
        List<SettlePoolEntity> settleList = new ArrayList<>();// 累计结算
        JSONArray paymentList = new JSONArray();// 付款登记
        try {
            contractList = JSONObject.parseArray(future1.get().toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray(future5.get().toJSONString(), SettlePoolEntity.class);
            paymentList = JSONObject.parseArray(future6.get().toJSONString());
            logger.info("按月查询实付结果：{}", JSONObject.toJSONString(paymentList));
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        // 按年月分组求和
        Map<String, BigDecimal> contractMap = contractList.stream().filter(x->x.getContractTaxMny() != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getSignDate(), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getContractTaxMny(), BigDecimal::add)));

        Map<String, BigDecimal> settleMap = settleList.stream().filter(x->x.getCurTaxMny() != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getSettleDate(), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getCurTaxMny(), BigDecimal::add)));

        // 付款登记 按照付款月份分组求和
        Map<String, BigDecimal> payMap = CollectionUtils.isNotEmpty(paymentList) ? JSONObject.parseObject(JSONObject.toJSONString(paymentList.get(0)), Map.class) : new HashMap<>();

        // 按月份分组汇总累计履约金额
        Map<String, BigDecimal> performanceMap = this.getPerformMonthMap(orgIds, startMonth, endMonth);

        FinanceUseResVO resVO = new FinanceUseResVO();
        List<String> monthData = EJCDateUtil.getMonthBetween(startMonth, endMonth);
        HashMap<String, FinanceUseResSubVO> subVOMap = new HashMap<>();

        //合计字段
        List<String> keyList = Arrays.asList(
                "jiesuanjine",
                "payMoney",
                "contract",
                "performance"
        );

        for (String mon : monthData) {
            BigDecimal monVal = BigDecimal.ZERO;
            for (String key : keyList) {
                //结算
                if (key.equals(keyList.get(0))) {
                    monVal = ComputeUtil.nullToZero(settleMap.get(mon));
                }
                //付款
                if (key.equals(keyList.get(1))) {
                    monVal = ComputeUtil.nullToZero(payMap.get(mon));
                }
                //合同
                if (key.equals(keyList.get(2))) {
                    monVal = ComputeUtil.nullToZero(contractMap.get(mon));
                }
                //履约
                if (key.equals(keyList.get(3))) {
                    monVal = ComputeUtil.nullToZero(performanceMap.get(mon));
                }

                FinanceUseResSubVO subVO = subVOMap.get(key);
                if (subVO == null) {
                    subVO = new FinanceUseResSubVO();
                    subVOMap.put(key, subVO);
                }
                subVO.setTotal(ComputeUtil.safeAdd(subVO.getTotal(), monVal));
                List<BigDecimal> monthDataList = subVO.getMonthData();
                if (monthDataList == null) {
                    monthDataList = new ArrayList<>();
                    subVO.setMonthData(monthDataList);
                }
                monthDataList.add(monVal);
            }
        }

        resVO.setMonthData(monthData);
        resVO.setSettleMoney(subVOMap.get(keyList.get(0)));
        resVO.setPayMoney(subVOMap.get(keyList.get(1)));
        resVO.setContract(subVOMap.get(keyList.get(2)));
        resVO.setPerformance(subVOMap.get(keyList.get(3)));

        return CommonResponse.success("查询资金使用数据成功！", resVO);
    }

    /**
     * 根据参数查询累计履约金额
     * @param projectIds
     * @return
     */
    private BigDecimal getPerformanceMny(List<Long> projectIds) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));

        ExecutorService threadPool = Executors.newFixedThreadPool(4);

        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        List<String> sourceTypes = getSourceTypes();// 累计履约金额所需结算类型
        param1.getParams().put("sourceType", new Parameter(QueryParam.IN, sourceTypes));

        QueryParam webParam = Utils.deepCopy(param);// 深拷贝
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);

        QueryParam param2 = Utils.deepCopy(webParam);// 深拷贝
        param2.getParams().put("inOutFlag", new Parameter(QueryParam.EQ, 1));// 入库单
        param2.getParams().put("effectiveState", new Parameter(QueryParam.EQ, 1));// 生效
        QueryParam param3 = Utils.deepCopy(webParam);// 深拷贝
        param3.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效
        QueryParam param4 = Utils.deepCopy(webParam);// 深拷贝
        param4.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, settleService);// 累计结算
        Future<JSONArray> future2 = ListCallable.excute(threadPool, BASE_HOST + "ejc-store-web/statisics/queryList", param2);// 入库单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, BASE_HOST + "ejc-prormat-web/rentCalculate/queryList", param3);// 周转材租金计算
        Future<JSONArray> future4 = ListCallable.excute(threadPool, BASE_HOST + "ejc-proequipment-web/rentRental/queryList", param4);// 设备租金计算

        List<SettlePoolEntity> settleList = new ArrayList<>();
        JSONArray instoreList = new JSONArray();
        JSONArray rmatCalList = new JSONArray();
        JSONArray equipCalList = new JSONArray();
        try {
            settleList = JSONObject.parseArray(future1.get().toJSONString(), SettlePoolEntity.class);
            instoreList = future2.get();
            rmatCalList = future3.get();
            equipCalList = future4.get();
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        BigDecimal settleMny = settleList.stream().filter(x -> x.getCurTaxMny() != null)
                .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计结算金额
        // 入库单 入库金额 之和
        BigDecimal instoreMny = instoreList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("taxMny") != null)
                .map(x -> x.getBigDecimal("taxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 入库金额
        // 周转材租金计算 本次计算租金 之和
        BigDecimal rmatCalMny = rmatCalList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("rentTaxMny") != null)
                .map(x -> x.getBigDecimal("rentTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 入库金额
        // 设备租金计算 本次计算租金 之和
        BigDecimal equipCalMny = equipCalList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("rentTotalTaxMny") != null)
                .map(x -> x.getBigDecimal("rentTotalTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 入库金额
        BigDecimal performanceMny = ComputeUtil.safeAdd(settleMny, instoreMny, rmatCalMny, equipCalMny);// 累计履约金额
        return performanceMny;
    }

    /**
     * 查询项目对应累计履约金额
     * @param projectIds
     * @return
     */
    public Map<Long, BigDecimal> getPerformProjectMap(List<Long> projectIds) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));

        ExecutorService threadPool = Executors.newFixedThreadPool(4);

        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        List<String> sourceTypes = getSourceTypes();// 累计履约金额所需结算类型
        param1.getParams().put("sourceType", new Parameter(QueryParam.IN, sourceTypes));

        QueryParam webParam = Utils.deepCopy(param);// 深拷贝
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);

        QueryParam param2 = Utils.deepCopy(webParam);// 深拷贝
        param2.getParams().put("inOutFlag", new Parameter(QueryParam.EQ, 1));// 入库单
        param2.getParams().put("effectiveState", new Parameter(QueryParam.EQ, 1));// 生效
        QueryParam param3 = Utils.deepCopy(webParam);// 深拷贝
        param3.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效
        QueryParam param4 = Utils.deepCopy(webParam);// 深拷贝
        param4.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, settleService);// 累计结算
        Future<JSONArray> future2 = ListCallable.excute(threadPool, BASE_HOST + "ejc-store-web/statisics/queryList", param2);// 入库单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, BASE_HOST + "ejc-prormat-web/rentCalculate/queryList", param3);// 周转材租金计算
        Future<JSONArray> future4 = ListCallable.excute(threadPool, BASE_HOST + "ejc-proequipment-web/rentRental/queryList", param4);// 设备租金计算

        List<SettlePoolEntity> settleList = new ArrayList<>();
        JSONArray instoreList = new JSONArray();
        JSONArray rmatCalList = new JSONArray();
        JSONArray equipCalList = new JSONArray();
        try {
            settleList = JSONObject.parseArray(future1.get().toJSONString(), SettlePoolEntity.class);
            instoreList = future2.get();
            rmatCalList = future3.get();
            equipCalList = future4.get();
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        BigDecimal settleMny = BigDecimal.ZERO;
        BigDecimal instoreMny = BigDecimal.ZERO;
        BigDecimal rmatCalMny = BigDecimal.ZERO;
        BigDecimal equipCalMny = BigDecimal.ZERO;
        Map<Long, BigDecimal> performanceMap = new HashMap<>();
        for(Long projectId : projectIds) {
            settleMny = settleList.stream().filter(x -> x.getCurTaxMny() != null &&
                    projectId.equals(x.getProjectId()))
                    .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);// 累计结算金额
            // 入库单 入库金额 之和
            instoreMny = instoreList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("taxMny") != null &&
                    projectId.equals(x.getLong("projectId")))
                    .map(x -> x.getBigDecimal("taxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 入库金额
            // 周转材租金计算 本次计算租金 之和
            rmatCalMny = rmatCalList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("rentTaxMny") != null &&
                    projectId.equals(x.getJSONObject("projectId").getLong("id")))
                    .map(x -> x.getBigDecimal("rentTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 入库金额
            // 设备租金计算 本次计算租金 之和
            equipCalMny = equipCalList.stream().map(x -> ((JSONObject)x)).filter(x -> x.getBigDecimal("rentTotalTaxMny") != null &&
                    projectId.equals(x.getJSONObject("projectId").getLong("id")))
                    .map(x -> x.getBigDecimal("rentTotalTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);// 入库金额
            performanceMap.put(projectId, ComputeUtil.safeAdd(settleMny, instoreMny, rmatCalMny, equipCalMny));// 累计履约金额
        }
        return performanceMap;
    }

    /**
     * 按月份分组汇总累计履约金额
     * @param orgIds
     * @param startMonth
     * @param endMonth
     * @return
     */
    public Map<String, BigDecimal> getPerformMonthMap(List<Long> orgIds, String startMonth, String endMonth) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));

        ExecutorService threadPool = Executors.newFixedThreadPool(4);

        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        List<String> sourceTypes = getSourceTypes();// 累计履约金额所需结算类型
        param1.getParams().put("sourceType", new Parameter(QueryParam.IN, sourceTypes));

        QueryParam webParam = Utils.deepCopy(param);// 深拷贝
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);

        QueryParam param2 = Utils.deepCopy(webParam);// 深拷贝
        param2.getParams().put("inOutFlag", new Parameter(QueryParam.EQ, 1));// 入库单
        param2.getParams().put("effectiveState", new Parameter(QueryParam.EQ, 1));// 生效
        param2.getParams().put("sourceBillDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));
        QueryParam param3 = Utils.deepCopy(webParam);// 深拷贝
        param3.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效
        param3.getParams().put("rentDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));
        QueryParam param4 = Utils.deepCopy(webParam);// 深拷贝
        param4.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效
        param4.getParams().put("rentalDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, settleService);// 累计结算
        Future<JSONArray> future2 = ListCallable.excute(threadPool, BASE_HOST + "ejc-store-web/statisics/queryList", param2);// 入库单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, BASE_HOST + "ejc-prormat-web/rentCalculate/queryList", param3);// 周转材租金计算
        Future<JSONArray> future4 = ListCallable.excute(threadPool, BASE_HOST + "ejc-proequipment-web/rentRental/queryList", param4);// 设备租金计算

        List<SettlePoolEntity> settleList = new ArrayList<>();
        JSONArray instoreList = new JSONArray();
        JSONArray rmatCalList = new JSONArray();
        JSONArray equipCalList = new JSONArray();
        try {
            settleList = JSONObject.parseArray(future1.get().toJSONString(), SettlePoolEntity.class);
            instoreList = future2.get();
            rmatCalList = future3.get();
            equipCalList = future4.get();
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        Map<String, BigDecimal> settleMap = settleList.stream().filter(x->x.getCurTaxMny() != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getSettleDate(), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getCurTaxMny(), BigDecimal::add)));

        // 入库单 入库金额 之和
        Map<String, BigDecimal> instoreMap = instoreList.stream().map(x -> ((JSONObject)x)).filter(x->x.getBigDecimal("taxMny") != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getDate("sourceBillDate"), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getBigDecimal("taxMny"), BigDecimal::add)));

        // 周转材租金计算 本次计算租金 之和
        Map<String, BigDecimal> rmatCalMap = rmatCalList.stream().map(x -> ((JSONObject)x)).filter(x->x.getBigDecimal("rentTaxMny") != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getDate("rentDate"), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getBigDecimal("rentTaxMny"), BigDecimal::add)));

        // 设备租金计算 本次计算租金 之和
        Map<String, BigDecimal> equipCalMap = equipCalList.stream().map(x -> ((JSONObject)x)).filter(x->x.getBigDecimal("rentTotalTaxMny") != null).collect(
                Collectors.groupingBy(x -> EJCDateUtil.format(x.getDate("rentalDate"), EJCDateUtil.MONTH),
                        Collectors.reducing(BigDecimal.ZERO, x->x.getBigDecimal("rentTotalTaxMny"), BigDecimal::add)));

        // 累计履约金额
        Map<String, BigDecimal> performanceMap = sumMap(settleMap, instoreMap, rmatCalMap, equipCalMap);
        return performanceMap;
    }

    public static Map<String, BigDecimal> sumMap(Map<String, BigDecimal> map1, Map<String, BigDecimal>... addNums) {
        for (Map<String, BigDecimal> temp : addNums) {
            map1 = sumMap(map1, temp);
        }
        return map1;
    }

    private static Map<String, BigDecimal> sumMap(Map<String, BigDecimal> map1, Map<String, BigDecimal> map2){
        for(String key : map2.keySet()){
            if(map1.containsKey(key)){
                map1.put(key, ComputeUtil.safeAdd(map1.get(key), map2.get(key)));
            } else {
                map1.put(key, map2.get(key));
            }
        }
        return map1;
    }

    /**
     * 累计履约金额所需结算类型
     * “结算单类型”为“专业分包月度结算”、“劳务分包月度结算”、“设备采购结算”或“临时设备结算”、“大型设备安拆合同结算”、“其他支出合同结算”的【结算池】，“本次结算金额”之和
     * @return
     */
    private static List<String> getSourceTypes(){
        List<String> sourceTypes = new ArrayList<>();
        sourceTypes.add(SettleSourceTypeEnum.专业分包月度结算.getCode());
        sourceTypes.add(SettleSourceTypeEnum.劳务分包月度结算.getCode());
        sourceTypes.add(SettleSourceTypeEnum.设备采购结算.getCode());
        sourceTypes.add(SettleSourceTypeEnum.临时设备结算.getCode());
//        sourceTypes.add(SettleSourceTypeEnum.大型设备安拆结算.getCode());
        sourceTypes.add(SettleSourceTypeEnum.安拆合同过程结算.getCode());
        sourceTypes.add(SettleSourceTypeEnum.安拆合同最终结算.getCode());
        sourceTypes.add(SettleSourceTypeEnum.其他支出结算.getCode());
        sourceTypes.add(SettleSourceTypeEnum.其他支出合同过程结算.getCode());
        sourceTypes.add(SettleSourceTypeEnum.其他支出合同最终结算.getCode());
        return sourceTypes;
    }



    public JSONObject queryOutputScale(Long projectId){
        JSONObject object = new JSONObject();

        LambdaQueryWrapper<ContractPoolEntity> contractQueryWrapper = new LambdaQueryWrapper();
        contractQueryWrapper.eq(ContractPoolEntity::getProjectId,projectId);
        contractQueryWrapper.eq(ContractPoolEntity::getTenantId,InvocationInfoProxy.getTenantid());
        contractQueryWrapper.eq(ContractPoolEntity::getSourceType,ContractTypeEnum.施工合同.getTypeCode());
        contractQueryWrapper.eq(ContractPoolEntity::getDr,0);
        List<ContractPoolEntity> listContractPool = contractService.list(contractQueryWrapper);

        BigDecimal sumContractTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(listContractPool)){
            sumContractTaxMny = listContractPool.stream().map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal::add).get();
        }

        LambdaQueryWrapper<SettlePoolEntity> settleQueryWrapper = new LambdaQueryWrapper();
        settleQueryWrapper.eq(SettlePoolEntity::getProjectId,projectId);
        settleQueryWrapper.eq(SettlePoolEntity::getTenantId,InvocationInfoProxy.getTenantid());
        settleQueryWrapper.eq(SettlePoolEntity::getSourceType,SettleSourceTypeEnum.产值报量.getCode());
        settleQueryWrapper.eq(SettlePoolEntity::getContractType,ContractTypeEnum.施工合同.getTypeCode());
        settleQueryWrapper.eq(SettlePoolEntity::getDr,0);
        settleQueryWrapper.in(SettlePoolEntity::getBillState,1,3);
        List<SettlePoolEntity> listSettlePool = settleService.list(settleQueryWrapper);

        BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(listSettlePool)){
            sumSettleTaxMny = listSettlePool.stream().map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal::add).get();
        }

        object.put("contractMoney",sumContractTaxMny);
        object.put("outputMoney",sumSettleTaxMny);
        if (sumContractTaxMny.compareTo(BigDecimal.ZERO) == 0) {
            object.put("outputProgress", BigDecimal.ZERO);
        } else {
            object.put("outputProgress", ComputeUtil.safeMultiply(ComputeUtil.safeDiv(sumSettleTaxMny,sumContractTaxMny),new BigDecimal(100)));
        }
        return object;
    }

    @Override
    public JSONObject costSquareChart(Long projectId){
        JSONObject object = new JSONObject();

        BigDecimal sumAllCostMny = BigDecimal.ZERO; //项目实际成本
        BigDecimal sumRgfCostMny = BigDecimal.ZERO; //人工费
        BigDecimal sumJxfCostMny = BigDecimal.ZERO; //机械费
        BigDecimal sumZyfbfCostMny = BigDecimal.ZERO; //专业分包费
        BigDecimal sumClfCostMny = BigDecimal.ZERO; //材料费
        BigDecimal sumOtherCostMny = BigDecimal.ZERO; //其它费用
        List<CostDetailVO> costDetailVOS = mapper.queryCostByProjectId(projectId);
        if (CollectionUtils.isNotEmpty(costDetailVOS)){
            sumAllCostMny = costDetailVOS.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);

            List<Long> rgfSubjectOrgIds = subjectOrgApi.querySubjectOrgIds("人工费").getData();
            List<CostDetailVO> rgfList = costDetailVOS.stream().filter(e -> rgfSubjectOrgIds.contains(e.getSubjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(rgfList)){
                sumRgfCostMny = rgfList.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }

            List<Long> jxfSubjectOrgIds = subjectOrgApi.querySubjectOrgIds("机械费").getData();
            List<CostDetailVO> jxfList = costDetailVOS.stream().filter(e -> jxfSubjectOrgIds.contains(e.getSubjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(jxfList)){
                sumJxfCostMny = jxfList.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }

            List<Long> zyfbfSubjectOrgIds = subjectOrgApi.querySubjectOrgIds("专业分包费").getData();
            List<CostDetailVO> zyfbfList = costDetailVOS.stream().filter(e -> zyfbfSubjectOrgIds.contains(e.getSubjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(zyfbfList)){
                sumZyfbfCostMny = zyfbfList.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }

            List<Long> clfSubjectOrgIds = subjectOrgApi.querySubjectOrgIds("材料费").getData();
            List<CostDetailVO> clfList = costDetailVOS.stream().filter(e -> clfSubjectOrgIds.contains(e.getSubjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(clfList)){
                sumClfCostMny = clfList.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }

            List<Long> allSubjectIdS = new ArrayList<>();
            allSubjectIdS.addAll(rgfSubjectOrgIds);
            allSubjectIdS.addAll(jxfSubjectOrgIds);
            allSubjectIdS.addAll(zyfbfSubjectOrgIds);
            allSubjectIdS.addAll(clfSubjectOrgIds);
            List<CostDetailVO> otherList = costDetailVOS.stream().filter(e -> !allSubjectIdS.contains(e.getSubjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(otherList)){
                sumOtherCostMny = otherList.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }

        }

        LambdaQueryWrapper<ContractPoolEntity> contractQueryWrapper = new LambdaQueryWrapper();
        contractQueryWrapper.eq(ContractPoolEntity::getProjectId,projectId);
        contractQueryWrapper.eq(ContractPoolEntity::getTenantId,InvocationInfoProxy.getTenantid());
        //contractQueryWrapper.eq(ContractPoolEntity::getContractProperty,ContractPropertyEnum.收入合同.getPropertyCode());
        contractQueryWrapper.eq(ContractPoolEntity::getSourceType,ContractTypeEnum.施工合同.getTypeCode());
        contractQueryWrapper.eq(ContractPoolEntity::getDr,0);
        List<ContractPoolEntity> listContractPool = contractService.list(contractQueryWrapper);

        BigDecimal sumContractMny = BigDecimal.ZERO; //项目合同造价
        if (CollectionUtils.isNotEmpty(listContractPool)){
            BigDecimal contractMny = listContractPool.stream().filter(x -> x.getContractMny() != null).map(ContractPoolEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add);

            BigDecimal replyMny = BigDecimal.ZERO;
            List<ContractPoolEntity> replyList = listContractPool.stream().filter(e -> null != e.getTotalTeplyMny()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(replyList)){
                replyMny = replyList.stream().map(ContractPoolEntity::getTotalTeplyMny).reduce(BigDecimal::add).get();
            }

            sumContractMny = ComputeUtil.safeAdd(contractMny,replyMny);
        }

        Map<String, Object> targetCost = mapper.queryTargetCostByProjectId(projectId);
        BigDecimal targetCostMny = BigDecimal.ZERO; //项目目标成本
        if (null != targetCost && null != targetCost.get("mny")){
            targetCostMny = (BigDecimal) targetCost.get("mny");
            if (targetCostMny.compareTo(new BigDecimal("0E-8"))==0){
                targetCostMny = BigDecimal.ZERO;
            }
        }

        LambdaQueryWrapper<SettlePoolEntity> settleQueryWrapper = new LambdaQueryWrapper();
        settleQueryWrapper.eq(SettlePoolEntity::getProjectId,projectId);
        settleQueryWrapper.eq(SettlePoolEntity::getTenantId,InvocationInfoProxy.getTenantid());
        settleQueryWrapper.eq(SettlePoolEntity::getSourceType,SettleSourceTypeEnum.对甲报量.getCode());
        settleQueryWrapper.eq(SettlePoolEntity::getDr,0);
        settleQueryWrapper.in(SettlePoolEntity::getBillState,1,3);
        List<SettlePoolEntity> listSettlePool = settleService.list(settleQueryWrapper);

        BigDecimal sumSettleMny = BigDecimal.ZERO; //项目结算总价
        if (CollectionUtils.isNotEmpty(listSettlePool)){
            sumSettleMny = listSettlePool.stream().filter(x -> x.getCurMny() != null).map(SettlePoolEntity::getCurMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }

        BigDecimal jjxyMny = ComputeUtil.safeSub(sumContractMny, targetCostMny); //经营效益
        BigDecimal glxyMny = ComputeUtil.safeSub(targetCostMny, sumAllCostMny); //管理效益
        BigDecimal jsxyMny = ComputeUtil.safeSub(sumSettleMny, sumContractMny); //结算效益

        object.put("sumRgfCostTaxMny",sumRgfCostMny); //人工费
        object.put("sumJxfCostTaxMny",sumJxfCostMny); //机械费
        object.put("sumZyfbfCostTaxMny",sumZyfbfCostMny); //专业分包费用
        object.put("sumClfCostTaxMny",sumClfCostMny); //材料费
        object.put("sumOtherCostTaxMny",sumOtherCostMny); //其他费
        object.put("sumContractTaxMny",sumContractMny); //项目合同造价
        object.put("targetCostTaxMny",targetCostMny); //项目目标成本
        object.put("sumAllCostTaxMny",sumAllCostMny); //项目实际成本
        object.put("sumSettleTaxMny",sumSettleMny); //项目结算总价
        object.put("jjxyTaxMny",jjxyMny); //经营效益
        object.put("glxyTaxMny",glxyMny); //管理效益
        object.put("jsxyTaxMny",jsxyMny); //结算效益

        return object;
    }

    @Override
    public BigDecimal thisProductMny() {
        String startMonth = EJCDateUtil.getYear() + "-01" + "-01";
        String endMonth = EJCDateUtil.getMonth(0) + "-31";
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, SettleSourceTypeEnum.产值报量.getCode()));
        param.getParams().put("settleDate", new Parameter(QueryParam.BETWEEN, startMonth + "," + endMonth));
        // 产值统计
        List<SettlePoolEntity> productionList = settleService.queryList(param);
        BigDecimal productionMoney = productionList.stream().filter(x -> x.getCurTaxMny() != null)
                .map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        return productionMoney;
    }

    /**
     * 根据项目主键查询项目列表，之前接口返回较慢，超时
     * @return
     */
    public List<ProjectPoolSetVO> queryProjectPoolList() {
        return this.queryProjectPoolList(null, null, null);
    }

    /**
     * 根据项目主键查询项目列表，之前接口返回较慢，超时
     * @param projectStatus
     * @return
     */
    public List<ProjectPoolSetVO> queryProjectPoolList(String projectStatus, String dateIn, Long orgId) {
        CommonResponse<JSONArray> resp = projectSetApi.queryProjectPoolList(projectStatus, dateIn, orgId);
        List<ProjectPoolSetVO> result = new ArrayList<>();
        if(resp.isSuccess()){
            result = JSONArray.parseArray(JSONObject.toJSONString(resp.getData()), ProjectPoolSetVO.class);
        } else {
            logger.error(resp.getMsg());
        }
        return result;
    }


    public static void main(String[] args) {
        System.out.println(EJCDateUtil.getMonthBetween("2022-08-01", "2023-03-31"));
    }

}
