package com.ejianc.business.contractbase.pool.contractpool.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.HeadUserVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplyVO;
import com.ejianc.business.contractbase.vo.report.SubUnitTopVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 合同池主实体
 * 
 * @author generator
 * 
 */
public interface IContractPoolService extends IBaseService<ContractPoolEntity> {

    // 根据项目id查询当前项目下的 最新一条施工合同的合同金额 - 专业合同的合同金额的累计
    BigDecimal queryContractionSubtractProTaxMny(Long projectId);

    // 数据导入
    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    /**
     * 根据id物理删除合同信息
     *
     * @param sourceId
     */
    void deleteBySourceId(Long sourceId);

    /**
     * 保存或更新合同信息
     *
     * @param contract
     */
    ContractPoolVO saveOrUpdateContract(ContractPoolVO contract);

    // 更新合同履约状态
    ContractPoolVO updatePerformanceStatusByContractId(ContractPoolVO contractPoolVO);

    List<SubUnitTopVO> querySubUnitTopN(Integer topN, Integer mnyFlag, Integer yearFlag, Long orgId);

    List<ContractDTO> getContractList(SupplyVO vo);

    List<ContractDTO> getContractListByHeadUser(HeadUserVO vo);


    //

    /**
     * 查询合同的履约金额
     * @param vo
     * @return
     */
    BigDecimal queryContractHonourMny(ContractPoolVO vo);

    CommonResponse<IPage<com.ejianc.business.contractbase.pool.contractpool.vo.SupplierVO>> querySumContract(QueryParam param);

    List<ContractPoolEntity> queryMdmPage(QueryParam param);

    /**
     * 统计合同总金额合计值
     *
     * @param param
     * @return
     */
    BigDecimal calcTotalMny(QueryParam param);
    List<ContractPoolVO> getSupplierSignMny();
}
