/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.check.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.check.service.IParamCheckService;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.pro.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParamCheckServiceImpl
implements IParamCheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String CHECK_PARAM_CODE = "P-434f5499";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IContractPoolService contractService;
    @Autowired
    private ISettlePoolService settleService;

    @Override
    public ParamsCheckVO paramsCheck(Long projectId, Long contractId, BigDecimal contractTaxMny) {
        CommonResponse billParamByCode;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        LambdaQueryWrapper incomeQueryWrapper = new LambdaQueryWrapper();
        incomeQueryWrapper.eq(ContractPoolEntity::getProjectId, (Object)projectId);
        incomeQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        incomeQueryWrapper.eq(ContractPoolEntity::getSourceType, (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode());
        incomeQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        List listContractPool = this.contractService.list((Wrapper)incomeQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)listContractPool)) {
            paramsCheckVO.setWarnType(paramsArray[0]);
            return paramsCheckVO;
        }
        BigDecimal sumIncomeContractTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)listContractPool)) {
            sumIncomeContractTaxMny = listContractPool.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE)).isSuccess() && null != billParamByCode.getData()) {
            List contractListB;
            BillParamVO billParamVO = (BillParamVO)billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)sumIncomeContractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
            BigDecimal sumPayContractTaxMny = BigDecimal.ZERO;
            LambdaQueryWrapper payQueryWrapper = new LambdaQueryWrapper();
            if (null != contractId) {
                payQueryWrapper.ne(BaseEntity::getId, (Object)contractId);
            }
            payQueryWrapper.eq(ContractPoolEntity::getProjectId, (Object)projectId);
            payQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            payQueryWrapper.in(ContractPoolEntity::getContractProperty, new Object[]{ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()});
            payQueryWrapper.eq(BaseEntity::getDr, (Object)0);
            List payContractPool = this.contractService.list((Wrapper)payQueryWrapper);
            List contractListA = payContractPool.stream().filter(e -> PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(contractListA)) {
                sumPayContractTaxMny = contractListA.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
            }
            if (CollectionUtils.isNotEmpty(contractListB = payContractPool.stream().filter(e -> PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u7ed3\u675f.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList()))) {
                List subContractList;
                List notSubContractList = contractListB.stream().filter(e -> !ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType()) && !ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(notSubContractList)) {
                    List ids = notSubContractList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(BaseEntity::getDr, (Object)0);
                    queryWrapper.in(SettlePoolEntity::getBillState, new Object[]{1, 3});
                    queryWrapper.in(SettlePoolEntity::getContractId, ids);
                    List settleList = this.settleService.list((Wrapper)queryWrapper);
                    BigDecimal sumNotSubSettleTaxMny = BigDecimal.ZERO;
                    if (CollectionUtils.isNotEmpty((Collection)settleList)) {
                        sumNotSubSettleTaxMny = settleList.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                    }
                    sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumPayContractTaxMny, (BigDecimal)sumNotSubSettleTaxMny);
                }
                if (CollectionUtils.isNotEmpty(subContractList = contractListB.stream().filter(e -> ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList()))) {
                    List otherList;
                    List yzfList = subContractList.stream().filter(e -> PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(yzfList)) {
                        List yzfIds = yzfList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(BaseEntity::getDr, (Object)0);
                        queryWrapper.in(SettlePoolEntity::getBillState, new Object[]{1, 3});
                        queryWrapper.in(SettlePoolEntity::getSourceType, new Object[]{SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode()});
                        queryWrapper.in(SettlePoolEntity::getContractId, yzfIds);
                        List settleListOne = this.settleService.list((Wrapper)queryWrapper);
                        BigDecimal settleOne = BigDecimal.ZERO;
                        if (CollectionUtils.isNotEmpty((Collection)settleListOne)) {
                            settleOne = settleListOne.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                        }
                        sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumPayContractTaxMny, (BigDecimal)settleOne);
                    }
                    if (CollectionUtils.isNotEmpty(otherList = subContractList.stream().filter(e -> !PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList()))) {
                        List otherIds = otherList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(BaseEntity::getDr, (Object)0);
                        queryWrapper.in(SettlePoolEntity::getBillState, new Object[]{1, 3});
                        queryWrapper.in(SettlePoolEntity::getSourceType, new Object[]{SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97, SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode()});
                        queryWrapper.in(SettlePoolEntity::getContractId, otherIds);
                        List settleListTwo = this.settleService.list((Wrapper)queryWrapper);
                        BigDecimal settleTwo = BigDecimal.ZERO;
                        if (CollectionUtils.isNotEmpty((Collection)settleListTwo)) {
                            settleTwo = settleListTwo.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                        }
                        sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumPayContractTaxMny, (BigDecimal)settleTwo);
                    }
                }
            }
            sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumPayContractTaxMny, (BigDecimal)contractTaxMny).setScale(2, 4);
            BigDecimal bigDecimal = contractTaxMny = contractTaxMny != null ? contractTaxMny.setScale(2, 4) : BigDecimal.ZERO;
            if (sumPayContractTaxMny.compareTo(comMny) <= 0) {
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
            paramsCheckDsVO.setWarnItem("\u652f\u51fa\u8d85\u65bd\u5de5\u5408\u540c");
            paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u652f\u51fa\u5408\u540c\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u91d1\u989d");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(contractTaxMny).append("\u5143\uff0c\u542b\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(sumPayContractTaxMny).append("\u5143\uff0c\u65bd\u5de5\u5408\u540c\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sumPayContractTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
            paramsCheckDsVO.setContent(stringBuffer.toString());
            checkDsVOS.add(paramsCheckDsVO);
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> paramsCheck(Long projectId, Long contractId, BigDecimal contractTaxMny, Long orgId) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        LambdaQueryWrapper incomeQueryWrapper = new LambdaQueryWrapper();
        incomeQueryWrapper.eq(ContractPoolEntity::getProjectId, (Object)projectId);
        incomeQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        incomeQueryWrapper.eq(ContractPoolEntity::getSourceType, (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode());
        incomeQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        List listContractPool = this.contractService.list((Wrapper)incomeQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)listContractPool)) {
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            paramsCheckVO.setWarnType(paramsArray[0]);
            paramsCheckVOList.add(paramsCheckVO);
            return paramsCheckVOList;
        }
        List zsht = listContractPool.stream().filter(x -> x.getIsEstimation() == null || x.getIsEstimation() == 0).collect(Collectors.toList());
        List zght = listContractPool.stream().filter(x -> x.getIsEstimation() == 1).collect(Collectors.toList());
        BigDecimal sumIncomeContractTaxMny = BigDecimal.ZERO;
        sumIncomeContractTaxMny = CollectionUtil.isNotEmpty(zsht) ? zsht.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO) : zght.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO billParamVO : data) {
                    List contractListB;
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)sumIncomeContractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    BigDecimal sumPayContractTaxMny = BigDecimal.ZERO;
                    LambdaQueryWrapper payQueryWrapper = new LambdaQueryWrapper();
                    if (null != contractId) {
                        payQueryWrapper.ne(BaseEntity::getId, (Object)contractId);
                    }
                    payQueryWrapper.eq(ContractPoolEntity::getProjectId, (Object)projectId);
                    payQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    payQueryWrapper.in(ContractPoolEntity::getContractProperty, new Object[]{ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()});
                    payQueryWrapper.eq(BaseEntity::getDr, (Object)0);
                    List payContractPool = this.contractService.list((Wrapper)payQueryWrapper);
                    List contractListA = payContractPool.stream().filter(e -> PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(contractListA)) {
                        sumPayContractTaxMny = contractListA.stream().map(ContractPoolEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                    }
                    if (CollectionUtils.isNotEmpty(contractListB = payContractPool.stream().filter(e -> PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(e.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u7ed3\u675f.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList()))) {
                        List subContractList;
                        List notSubContractList = contractListB.stream().filter(e -> !ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType()) && !ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(notSubContractList)) {
                            List ids = notSubContractList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                            queryWrapper.eq(BaseEntity::getDr, (Object)0);
                            queryWrapper.in(SettlePoolEntity::getBillState, new Object[]{1, 3});
                            queryWrapper.in(SettlePoolEntity::getContractId, ids);
                            List settleList = this.settleService.list((Wrapper)queryWrapper);
                            BigDecimal sumNotSubSettleTaxMny = BigDecimal.ZERO;
                            if (CollectionUtils.isNotEmpty((Collection)settleList)) {
                                sumNotSubSettleTaxMny = settleList.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                            }
                            sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumPayContractTaxMny, (BigDecimal)sumNotSubSettleTaxMny);
                        }
                        if (CollectionUtils.isNotEmpty(subContractList = contractListB.stream().filter(e -> ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType()) || ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType())).collect(Collectors.toList()))) {
                            List otherList;
                            List yzfList = subContractList.stream().filter(e -> PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(yzfList)) {
                                List yzfIds = yzfList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                                queryWrapper.eq(BaseEntity::getDr, (Object)0);
                                queryWrapper.in(SettlePoolEntity::getBillState, new Object[]{1, 3});
                                queryWrapper.in(SettlePoolEntity::getSourceType, new Object[]{SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode()});
                                queryWrapper.in(SettlePoolEntity::getContractId, yzfIds);
                                List settleListOne = this.settleService.list((Wrapper)queryWrapper);
                                BigDecimal settleOne = BigDecimal.ZERO;
                                if (CollectionUtils.isNotEmpty((Collection)settleListOne)) {
                                    settleOne = settleListOne.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                                }
                                sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumPayContractTaxMny, (BigDecimal)settleOne);
                            }
                            if (CollectionUtils.isNotEmpty(otherList = subContractList.stream().filter(e -> !PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(e.getPerformanceStatus())).collect(Collectors.toList()))) {
                                List otherIds = otherList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                                queryWrapper.eq(BaseEntity::getDr, (Object)0);
                                queryWrapper.in(SettlePoolEntity::getBillState, new Object[]{1, 3});
                                queryWrapper.in(SettlePoolEntity::getSourceType, new Object[]{SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97, SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode()});
                                queryWrapper.in(SettlePoolEntity::getContractId, otherIds);
                                List settleListTwo = this.settleService.list((Wrapper)queryWrapper);
                                BigDecimal settleTwo = BigDecimal.ZERO;
                                if (CollectionUtils.isNotEmpty((Collection)settleListTwo)) {
                                    settleTwo = settleListTwo.stream().map(SettlePoolEntity::getCurTaxMny).filter(Objects::nonNull).reduce(BigDecimal::add).get();
                                }
                                sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumPayContractTaxMny, (BigDecimal)settleTwo);
                            }
                        }
                    }
                    sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumPayContractTaxMny, (BigDecimal)contractTaxMny).setScale(2, 4);
                    BigDecimal bigDecimal = contractTaxMny = contractTaxMny != null ? contractTaxMny.setScale(2, 4) : BigDecimal.ZERO;
                    if (sumPayContractTaxMny.compareTo(comMny) <= 0) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u652f\u51fa\u8d85\u65bd\u5de5\u5408\u540c");
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u652f\u51fa\u5408\u540c\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(contractTaxMny).append("\u5143\uff0c\u542b\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(sumPayContractTaxMny).append("\u5143\uff0c\u65bd\u5de5\u5408\u540c\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sumPayContractTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }
}

